/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.schedule.sdk.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.io.Serializable;

public class RetentionPolicy
implements Serializable {
    private static final long serialVersionUID = 613974871848075589L;
    private static final Log logger = LogFactory.getInstance(RetentionPolicy.class);
    private static final int MAX_LATEST_COPY = 2048;
    private static final int MIN_LATEST_COPY = 1;
    private static final int MAX_DAIYLY_COPY = 365;
    private static final int MAX_WEEKLY_COPY = 52;
    private static final int MAX_MONTHLY_COPY = 60;
    private static final int MIN_COPY = 0;
    private static final int MAX_SECOND_SNAPSHOT_LATEST_COPY = 256;
    private static final int MAX_CDP_COPY = 60000;
    private static final int MAX_CDP_DAIYLY_COPY = 256;
    private static final int MAX_CDP_WEEKLY_COPY = 256;
    private static final int MAX_CDP_MONTHLY_COPY = 256;
    private static final int MAX_KUBE_BACKUP_COPY = 256;
    public static final int DAY_UNIT = 46;
    public static final int MONTH_UNIT = 47;
    public static final int YEAR_UNIT = 48;
    private static final int MAX_DAY_VALUE = 7300;
    private static final int MAX_MONTH_VALUE = 240;
    private static final int MAX_YEAR_VALUE = 20;
    public static final int MIN_SECURE_SNAPSHOT_COPIES = 96;
    private int latestCopies;
    private int dailyCopies;
    private int weeklyCopies;
    private int monthlyCopyies;
    private int protectPeriod;
    private int unitType;

    public int getLatestCopies() {
        return this.latestCopies;
    }

    public void setLatestCopies(int latestCopies) {
        if (latestCopies < 1 || latestCopies > 60000) {
            throw new LegoCheckedException(1073947393L);
        }
        this.latestCopies = latestCopies;
    }

    public int getDailyCopies() {
        return this.dailyCopies;
    }

    public void setDailyCopies(int dailyCopies) {
        this.dailyCopies = dailyCopies;
    }

    public int getWeeklyCopies() {
        return this.weeklyCopies;
    }

    public void setWeeklyCopies(int weeklyCopies) {
        this.weeklyCopies = weeklyCopies;
    }

    public int getMonthlyCopyies() {
        return this.monthlyCopyies;
    }

    public void setMonthlyCopyies(int monthlyCopyies) {
        this.monthlyCopyies = monthlyCopyies;
    }

    @JsonIgnore
    public int getTotalCopyies() {
        return this.latestCopies + this.dailyCopies + this.weeklyCopies + this.monthlyCopyies;
    }

    public void checkCDPCopies() {
        this.checkCopies(60000, 256, 256, 256);
    }

    public int getProtectPeriod() {
        return this.protectPeriod;
    }

    public void setProtectPeriod(int protectPeriod) {
        this.protectPeriod = protectPeriod;
    }

    public void setUnitType(int unitType) {
        this.unitType = unitType;
    }

    public int getUnitType() {
        return this.unitType;
    }

    public void checkSecondSnapshotCopies() {
        if (this.latestCopies < 1 || this.latestCopies > 256) {
            throw new LegoCheckedException(1073947393L);
        }
    }

    public void checkCopies() {
        this.checkCopies(2048, 365, 52, 60);
    }

    public void checkKubeBackupCopies() {
        this.checkCopies(256, 256, 256, 256);
    }

    private void checkCopies(int maxLatestCopies, int maxDailyCopies, int maxWeeklyCopies, int maxMonthlyCopies) {
        if (this.latestCopies < 1 || this.latestCopies > maxLatestCopies) {
            throw new LegoCheckedException(1073947393L);
        }
        if (this.dailyCopies < 0 || this.dailyCopies > maxDailyCopies) {
            throw new LegoCheckedException(1073947393L);
        }
        if (this.weeklyCopies < 0 || this.weeklyCopies > maxWeeklyCopies) {
            throw new LegoCheckedException(1073947393L);
        }
        if (this.monthlyCopyies < 0 || this.monthlyCopyies > maxMonthlyCopies) {
            throw new LegoCheckedException(1073947393L);
        }
    }

    public void checkProtectPeriod() {
        switch (this.unitType) {
            case 46: {
                if (this.protectPeriod >= 1 && this.protectPeriod <= 7300) break;
                logger.error((Object)"The period does not match the unit. period: %s with day", (long)this.protectPeriod);
                throw new LegoCheckedException(1073947393L);
            }
            case 47: {
                if (this.protectPeriod >= 1 && this.protectPeriod <= 240) break;
                logger.error((Object)"The period does not match the unit. period: %s with month", (long)this.protectPeriod);
                throw new LegoCheckedException(1073947393L);
            }
            case 48: {
                if (this.protectPeriod >= 1 && this.protectPeriod <= 20) break;
                logger.error((Object)"The period does not match the unit. period: %s with month", (long)this.protectPeriod);
                throw new LegoCheckedException(1073947393L);
            }
            default: {
                logger.error((Object)"secure unit is null");
                throw new LegoCheckedException(1073947393L);
            }
        }
    }

    public String toString() {
        return "RetentionPolicy{latestCopies=" + this.latestCopies + ", dailyCopies=" + this.dailyCopies + ", weeklyCopies=" + this.weeklyCopies + ", monthlyCopyies=" + this.monthlyCopyies + '}';
    }
}

