/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.report.sdk;

import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.lego.cbb.i18n.I18nMgrImpl;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

public class ReportUtil {
    public static final String CONTENT_BLANK = "--";
    public static final Map<Integer, String> POLICYTEMPLATE_TYPE_RESOURCE_KEY_MAP;
    private static final int TIME_24_HOURS = 24;
    private static final int TIME_3_DAYS = 3;
    private static final int TIME_7_DAYS = 7;
    private static final int TIME_30_DAYS = 30;
    private static final String BLANK_SPACE = " ";
    private static final long SIXTY = 60L;
    private static final long SECOND = 1000L;
    private static final long MINUTE = 60000L;
    private static final long HOUR = 3600000L;
    private static final long DAY = 86400000L;
    private static final I18nMgrImpl I18N_MGR;

    public static String getPolicyTemplateSolution(int type, Locale locale) {
        String solution = null;
        switch (type) {
            case 25: 
            case 29: {
                solution = "common_term_AAdataCenterSolution_label";
                break;
            }
            case 21: 
            case 22: 
            case 38: 
            case 39: 
            case 56: {
                solution = "common_term_activeBackupSolution_label";
                break;
            }
            case 34: 
            case 37: {
                solution = "common_term_3dcSolution_label";
                break;
            }
        }
        return solution != null ? ":" + ReportUtil.getText(solution, locale) : "";
    }

    public static DrmEnumDefine.ReportTimeRangeE getQueryConditionForProtectReport(int timeType) {
        DrmEnumDefine.ReportTimeRangeE queryTime = DrmEnumDefine.ReportTimeRangeE.ALL_TIME;
        switch (timeType) {
            case 0: {
                queryTime = DrmEnumDefine.ReportTimeRangeE.ALL_TIME;
                break;
            }
            case 24: {
                queryTime = DrmEnumDefine.ReportTimeRangeE.LAST_24_HOURS;
                break;
            }
            case 3: {
                queryTime = DrmEnumDefine.ReportTimeRangeE.LAST_THREE_DAYS;
                break;
            }
            case 7: {
                queryTime = DrmEnumDefine.ReportTimeRangeE.LAST_SEVEN_DAYS;
                break;
            }
            case 30: {
                queryTime = DrmEnumDefine.ReportTimeRangeE.LAST_30_DAYS;
                break;
            }
        }
        return queryTime;
    }

    public static String getRPOStr(JSONArray rpoJsonArray, String rpoKey, Locale locale) {
        StringBuilder sbRpo = new StringBuilder();
        Iterator rpoJsonIterator = rpoJsonArray.iterator();
        while (rpoJsonIterator.hasNext()) {
            JSONObject rpoJson = JSONObject.fromObject(rpoJsonIterator.next());
            String rpo = rpoJson.getString(rpoKey);
            sbRpo.append(ReportUtil.formatTime(rpo, locale)).append(",");
        }
        if (sbRpo.length() < 1) {
            return CONTENT_BLANK;
        }
        return sbRpo.substring(0, sbRpo.length() - 1);
    }

    public static String formatTime(String configuredRPO, Locale locale) {
        Long time = NumberUtil.convertToLong((Object)configuredRPO);
        if (time == 0L) {
            return "0";
        }
        if (time < 0L) {
            return CONTENT_BLANK;
        }
        return ReportUtil.calculateTime(time, locale);
    }

    public static String calculateTime(long milliSecondTime, Locale locale) {
        long minute;
        long seconds;
        long tempMilliSecondTime = milliSecondTime;
        long day = tempMilliSecondTime / 86400000L;
        long hour = (tempMilliSecondTime -= day * 86400000L) / 3600000L;
        tempMilliSecondTime -= hour * 3600000L;
        if ((seconds = (tempMilliSecondTime -= (minute = tempMilliSecondTime / 60000L) * 60000L) / 1000L) >= 60L) {
            minute += (seconds %= 60L) / 60L;
        }
        if (minute >= 60L) {
            hour += (minute %= 60L) / 60L;
        }
        if (hour >= 24L) {
            day += (hour %= 24L) / 24L;
        }
        String dayText = ReportUtil.getText("common_term_day_plural_label", locale);
        String hourText = ReportUtil.getText("common_term_hour_plural_label", locale);
        String minText = ReportUtil.getText("common_term_minute_plural_label", locale);
        String secText = ReportUtil.getText("common_term_second_plural_label", locale);
        if (!VerifyUtil.isEmpty((Object)locale) && "en".equalsIgnoreCase(locale.toString())) {
            dayText = BLANK_SPACE + dayText + BLANK_SPACE;
            hourText = BLANK_SPACE + hourText + BLANK_SPACE;
            minText = BLANK_SPACE + minText + BLANK_SPACE;
            secText = BLANK_SPACE + secText + BLANK_SPACE;
        }
        StringBuilder sbBuilder = new StringBuilder();
        ReportUtil.appendTime(day, sbBuilder, dayText);
        ReportUtil.appendTime(hour, sbBuilder, hourText);
        ReportUtil.appendTime(minute, sbBuilder, minText);
        ReportUtil.appendTime(seconds, sbBuilder, secText);
        if (sbBuilder.length() == 0) {
            sbBuilder.append(CONTENT_BLANK);
        } else if (!VerifyUtil.isEmpty((Object)locale) && "en".equalsIgnoreCase(locale.toString())) {
            sbBuilder.replace(sbBuilder.length() - 1, sbBuilder.length(), "");
        }
        return sbBuilder.toString();
    }

    public static String calcExecuteTime(String startTimeStr, String endTimeStr, Locale locale) {
        if (VerifyUtil.isEmpty((String)startTimeStr) || VerifyUtil.isEmpty((String)endTimeStr)) {
            return CONTENT_BLANK;
        }
        Long startTime = ReportUtil.getTime(startTimeStr);
        Long endTime = ReportUtil.getTime(endTimeStr);
        if (startTime == null || startTime == 0L || endTime == null || endTime == 0L) {
            return CONTENT_BLANK;
        }
        long executeTime = endTime / 1000L - startTime / 1000L;
        if (executeTime < 0L) {
            return CONTENT_BLANK;
        }
        long temp = 3600L;
        long hour = executeTime / temp;
        long minutes = (executeTime %= temp) / 60L;
        long seconds = executeTime % 60L;
        if (hour > 0L) {
            String[] param = new String[]{"" + hour, "" + minutes, "" + seconds};
            return ReportUtil.getText("common_time_hour_min_second", locale, param);
        }
        if (minutes > 0L) {
            String[] param = new String[]{"" + minutes, "" + seconds};
            return ReportUtil.getText("common_time_min_second", locale, param);
        }
        String[] param = new String[]{"" + seconds};
        return ReportUtil.getText("common_time_second", locale, param);
    }

    public static String getText(String key, Locale locale) {
        return I18N_MGR.getString(key, locale);
    }

    public static String getText(String key, Locale locale, String[] params) {
        String value = ReportUtil.getText(key, locale);
        if (value != null && !VerifyUtil.isEmpty((Object[])params)) {
            int i = 0;
            for (String param : params) {
                String str = "{" + i + "}";
                if (value.indexOf(str) != -1) {
                    value = value.replace(str, param);
                }
                ++i;
            }
        }
        return value;
    }

    private static Long getTime(String timeStr) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date date = format.parse(timeStr);
            return date.getTime();
        }
        catch (ParseException e) {
            return NumberUtil.convertToLong((Object)timeStr, (long)0L);
        }
    }

    private static void appendTime(long time, StringBuilder sbBuilder, String text) {
        if (time > 0L) {
            sbBuilder.append(time + text);
        }
    }

    static {
        I18N_MGR = new I18nMgrImpl();
        I18N_MGR.afterPropertiesSet();
        POLICYTEMPLATE_TYPE_RESOURCE_KEY_MAP = new HashMap<Integer, String>();
        POLICYTEMPLATE_TYPE_RESOURCE_KEY_MAP.put(0, "array.replica.sync.name");
        POLICYTEMPLATE_TYPE_RESOURCE_KEY_MAP.put(1, "array.replica.async.name");
        POLICYTEMPLATE_TYPE_RESOURCE_KEY_MAP.put(2, "array.snapshot.name");
        POLICYTEMPLATE_TYPE_RESOURCE_KEY_MAP.put(3, "array.cascade3dc.syncasync.name");
        POLICYTEMPLATE_TYPE_RESOURCE_KEY_MAP.put(4, "array.cascade3dc.asyncasync.name");
        POLICYTEMPLATE_TYPE_RESOURCE_KEY_MAP.put(5, "array.concurrent3dc.syncasync.name");
        POLICYTEMPLATE_TYPE_RESOURCE_KEY_MAP.put(6, "array.concurrent3dc.asyncasync.name");
        POLICYTEMPLATE_TYPE_RESOURCE_KEY_MAP.put(11, "host.base.replica.name");
        POLICYTEMPLATE_TYPE_RESOURCE_KEY_MAP.put(14, "array.snapshot.name");
        POLICYTEMPLATE_TYPE_RESOURCE_KEY_MAP.put(16, "array.clone.name");
        POLICYTEMPLATE_TYPE_RESOURCE_KEY_MAP.put(19, "array.activeactive.storageSnapshot.name");
        POLICYTEMPLATE_TYPE_RESOURCE_KEY_MAP.put(17, "array.integratedBackup.name");
        POLICYTEMPLATE_TYPE_RESOURCE_KEY_MAP.put(28, "array.hyperMetroVault.name");
        POLICYTEMPLATE_TYPE_RESOURCE_KEY_MAP.put(20, "array.async.activeactive.name");
        POLICYTEMPLATE_TYPE_RESOURCE_KEY_MAP.put(18, "array.activeactive.async.name");
        POLICYTEMPLATE_TYPE_RESOURCE_KEY_MAP.put(29, "array.activeactive.name");
        POLICYTEMPLATE_TYPE_RESOURCE_KEY_MAP.put(25, "array.activeactive.name");
        POLICYTEMPLATE_TYPE_RESOURCE_KEY_MAP.put(21, "array.replica.sync.name");
        POLICYTEMPLATE_TYPE_RESOURCE_KEY_MAP.put(22, "array.replica.async.name");
        POLICYTEMPLATE_TYPE_RESOURCE_KEY_MAP.put(34, "array.activeactive.async.ring.name");
        POLICYTEMPLATE_TYPE_RESOURCE_KEY_MAP.put(37, "array.activeactive.async.ring.name");
        POLICYTEMPLATE_TYPE_RESOURCE_KEY_MAP.put(35, "array.cascade4dc.asyncasync.name");
        POLICYTEMPLATE_TYPE_RESOURCE_KEY_MAP.put(36, "array.concurrent4dc.asyncasync.name");
        POLICYTEMPLATE_TYPE_RESOURCE_KEY_MAP.put(33, "array.replica.async.name");
        POLICYTEMPLATE_TYPE_RESOURCE_KEY_MAP.put(38, "array.replica.sync.name");
        POLICYTEMPLATE_TYPE_RESOURCE_KEY_MAP.put(39, "array.replica.async.name");
        POLICYTEMPLATE_TYPE_RESOURCE_KEY_MAP.put(56, "array.replica.sync.name");
    }
}

