/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.util;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class RPOMeetCaculator {
    public static final int OK = 0;
    public static final int NOT_OK = -1;
    public static final int UNKNOWN = -2;
    public static final int CONFIG_RPO_NOT_CONFIGGED = -3;

    public static int calculateSinglePgRPOMet(JSONArray rpoJsonArray) {
        if (VerifyUtil.isEmpty((Collection)rpoJsonArray)) {
            return -2;
        }
        ArrayList<Integer> allRpoMeetStatus = new ArrayList<Integer>();
        Iterator iterator = rpoJsonArray.iterator();
        while (iterator.hasNext()) {
            JSONObject obj = JSONObject.fromObject(iterator.next());
            int rpoMeetStatus = RPOMeetCaculator.statistSingleReplicaRPOMeet(obj);
            allRpoMeetStatus.add(rpoMeetStatus);
        }
        if (VerifyUtil.isEmpty(allRpoMeetStatus)) {
            return -2;
        }
        if (allRpoMeetStatus.contains(-1)) {
            return -1;
        }
        if (allRpoMeetStatus.contains(-2)) {
            return -2;
        }
        if (allRpoMeetStatus.contains(0)) {
            return 0;
        }
        return -2;
    }

    public static int statistSingleReplicaRPOMeet(JSONObject obj) {
        long configuredRPO = obj.getLong("configuredRPO");
        long actualRPO = obj.getLong("actualRPO");
        if (actualRPO == -2L || actualRPO == -1L || configuredRPO == -1L) {
            return -2;
        }
        if (configuredRPO == -3L) {
            return -3;
        }
        if (actualRPO == -3L) {
            return -1;
        }
        if (actualRPO == -4L) {
            return 0;
        }
        if (actualRPO <= configuredRPO) {
            return 0;
        }
        return -1;
    }
}

