/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.util;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupBaseService;
import com.huawei.ism.drm.protection.replica.sdk.model.LocalStorageReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.HashSet;
import java.util.Set;

public class ReplicaUtil {
    private static final Log LOGGER = LogFactory.getInstance(ReplicaUtil.class);

    public static boolean isLocalStorageReplica(ProtectGroupReplica replica) {
        if (replica == null) {
            return false;
        }
        if (replica.isStorageSnapshotReplica()) {
            return true;
        }
        return replica.isBackUpReplica();
    }

    public static String getReplicaStorageIds(ProtectGroupReplica pgr) {
        if (VerifyUtil.isEmpty((Object)pgr)) {
            LOGGER.error((Object)"ProtectGroupReplica is null");
            throw new LegoCheckedException(1073947393L);
        }
        if (101 == pgr.getType()) {
            return pgr.getProperty("IMAGE_ID");
        }
        HashSet<String> storageSet = new HashSet<String>();
        Set<ProtectObjectReplica> pors = pgr.getReplicas();
        if (!VerifyUtil.isEmpty(pors)) {
            for (ProtectObjectReplica por : pors) {
                ReplicaUtil.handleStorageInfoSet(storageSet, por, pgr.getType());
            }
        }
        return String.join((CharSequence)",", storageSet);
    }

    private static void handleStorageInfoSet(Set<String> storageSet, ProtectObjectReplica por, int type) {
        Set<RelicaStorageInfo> rsis = por.getStorageInfos();
        if (!VerifyUtil.isEmpty(rsis)) {
            for (RelicaStorageInfo rsi : rsis) {
                if (rsi instanceof LocalStorageReplica && !VerifyUtil.isEmpty((String)((LocalStorageReplica)rsi).getConsistentGroupId())) {
                    storageSet.add(((LocalStorageReplica)rsi).getConsistentGroupId());
                    continue;
                }
                storageSet.add(rsi.getStorageId());
            }
        }
    }

    public static void checkReplicaRelateTemplate(ProtectGroupReplica replica) {
        if (VerifyUtil.isEmpty((Object)replica.getPg())) {
            LOGGER.error((Object)"Replica has not relate to ProtectGroup.");
        }
        if (VerifyUtil.isEmpty((Object)replica.getPg().getTemplate())) {
            ProtectGroup pg = ((IProtectGroupBaseService)ServiceLocator.getInstance().getService(IProtectGroupBaseService.class)).getProtectGroupByID(replica.getPg().getUuid(), false);
            replica.setPg(pg);
        }
    }
}

