/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.xve;

import com.huawei.ism.array.sdk.model.ArrayHost;
import com.huawei.ism.array.sdk.model.Fan;
import com.huawei.ism.array.sdk.model.PowerSupply;
import com.huawei.ism.array.sdk.model.XveDisk;
import com.huawei.ism.array.sdk.model.XveStoragePool;
import com.huawei.ism.array.sdk.model.XveTier;
import com.huawei.ism.cbb.base.sdk.constant.DiskConstant;
import com.huawei.ism.cbb.discover.xve.V2TypeMapper;
import com.huawei.ism.cbb.proxy.protocol.tlv.msg.Record;
import com.huawei.ism.cbb.proxy.xve.TLVParamUtil;
import com.huawei.ism.cbb.proxy.xve.XveEnumDefinePParent;
import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.cbb.proxy.xve.XveTLV;
import com.huawei.ism.cbb.proxy.xve.XveTLVParent;
import com.huawei.ism.cbb.proxy.xve.XveUUID;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.StringUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.cbb.util.unit.CapabilityUnitType;
import com.huawei.ism.cbb.util.unit.IUnitType;
import com.huawei.ism.cbb.util.unit.UnitConvert;

public class XveTLVTransition {
    public static PowerSupply transitionPower(String deviceId, Record record) {
        PowerSupply xvePower = new PowerSupply();
        String powerId = record.getParamStrValue(XveTLVParent.Power.ID.getParamIndex());
        String name = record.getParamStrValue(XveTLVParent.Power.NAME.getParamIndex());
        String parentId = record.getParamStrValue(XveTLVParent.Power.PARENTID.getParamIndex());
        String manufacturer = record.getParamStrValue(XveTLVParent.Power.MANUFACTURER.getParamIndex());
        Integer powerType = TLVParamUtil.getEnumValue(record, XveTLVParent.Power.POWERTYPE);
        String produceDate = record.getParamStrValue(XveTLVParent.Power.PRODUCEDATE.getParamIndex());
        String version = record.getParamStrValue(XveTLVParent.Power.VERSION.getParamIndex());
        String productModel = record.getParamStrValue(XveTLVParent.Power.MODEL.getParamIndex());
        Long temperature = TLVParamUtil.getLongValue(record, XveTLVParent.Power.TEMPERATURE);
        Integer healthStatus = TLVParamUtil.getEnumValue(record, XveTLVParent.Power.HEALTHSTATUS);
        Integer runningStatus = TLVParamUtil.getEnumValue(record, XveTLVParent.Power.RUNNINGSTATUS);
        xvePower.setUuid(new XveUUID(deviceId, XveMOType.POWER, powerId).toString());
        xvePower.setPowerId(powerId);
        xvePower.setName(name);
        xvePower.setManufacturer(manufacturer);
        if (null != powerType) {
            xvePower.setPowerType(XveEuumDefineParent.POWER_TYPE_E.valueOf((int)powerType).name());
        }
        xvePower.setChassisId(parentId);
        xvePower.setProduceDate(produceDate);
        xvePower.setPowerVersion(version);
        xvePower.setProductModel(productModel);
        xvePower.setTemperature(temperature);
        runningStatus = V2TypeMapper.POWER_RUNNING_STATE.get(runningStatus);
        if (null != runningStatus) {
            xvePower.setRunningState(String.valueOf(runningStatus));
        }
        if (null != (healthStatus = V2TypeMapper.POWER_HEALTH_STATE.get(healthStatus))) {
            xvePower.setStatus(healthStatus);
            xvePower.setHealthState(String.valueOf(healthStatus));
        }
        return xvePower;
    }

    public static Fan transitionFan(String deviceId, Record record) {
        Fan fan = new Fan();
        String fanId = record.getParamStrValue(XveTLVParent.Fan.ID.getParamIndex());
        String name = record.getParamStrValue(XveTLVParent.Fan.NAME.getParamIndex());
        String parentId = record.getParamStrValue(XveTLVParent.Fan.PARENTID.getParamIndex());
        Integer runLevel = TLVParamUtil.getEnumValue(record, XveTLVParent.Fan.RUNLEVEL);
        String elabel = record.getParamStrValue(XveTLVParent.Fan.ELABEL.getParamIndex());
        Integer healthStatus = TLVParamUtil.getEnumValue(record, XveTLVParent.Fan.HEALTHSTATUS);
        Integer runningStatus = TLVParamUtil.getEnumValue(record, XveTLVParent.Fan.RUNNINGSTATUS);
        fan.setUuid(new XveUUID(deviceId, XveMOType.FAN, fanId).toString());
        fan.setFanId(fanId);
        fan.setName(name);
        fan.setElecLabel(elabel);
        fan.setRunlevel(runLevel);
        fan.setChassisId(parentId);
        runningStatus = V2TypeMapper.FAN_RUNNING_STATE.get(runningStatus);
        if (null != runningStatus) {
            fan.setRunningState(String.valueOf(runningStatus));
        }
        if (null != (healthStatus = V2TypeMapper.FAN_HEALTH_STATE.get(healthStatus))) {
            fan.setStatus(healthStatus);
            fan.setHealthState(String.valueOf(healthStatus));
        }
        return fan;
    }

    public static XveStoragePool transitionXveStoragePool(String deviceId, Record record) {
        Integer runningStatus;
        XveStoragePool xvePool = new XveStoragePool();
        String poolId = record.getParamStrValue(XveTLV.StoragePool.ID.getParamIndex());
        String name = record.getParamStrValue(XveTLV.StoragePool.NAME.getParamIndex());
        xvePool.setPoolId(poolId);
        xvePool.setName(name);
        Integer healthStatus = V2TypeMapper.STORAGE_HEALTH_STUS.get(TLVParamUtil.getEnumValue(record, XveTLV.StoragePool.HEALTHSTATUS));
        if (null == healthStatus) {
            healthStatus = 0;
        }
        if (null == (runningStatus = V2TypeMapper.STORAGE_RUNNING_STUS.get(TLVParamUtil.getEnumValue(record, XveTLV.StoragePool.RUNNINGSTATUS)))) {
            runningStatus = 0;
        }
        xvePool.setHealthStatus(String.valueOf(healthStatus));
        xvePool.setStatus(healthStatus);
        xvePool.setRunningStatus(String.valueOf(runningStatus));
        xvePool.setNeSN(deviceId);
        Integer threshold = TLVParamUtil.getIntValue(record, XveTLV.StoragePool.USERCONSUMEDCAPACITYTHRESHOLD);
        xvePool.setThreshold(threshold);
        xvePool.setUuid(new XveUUID(deviceId, XveMOType.STORAGEPOOL, poolId).toString());
        XveTLVTransition.setStoragePoolTierInfo(record, xvePool);
        Long totalCapacity = TLVParamUtil.getCapacityBySectorValue(record, XveTLV.StoragePool.USERTOTALCAPACITY);
        Long usedCapacity = TLVParamUtil.getCapacityBySectorValue(record, XveTLV.StoragePool.USERCONSUMEDCAPACITY);
        Long freeCapacity = TLVParamUtil.getCapacityBySectorValue(record, XveTLV.StoragePool.USERFREECAPACITY);
        Long hotspareSpaceConsumedCapacity = TLVParamUtil.getCapacityBySectorValue(record, XveTLV.StoragePool.HOTSPARESPACECONSUMEDCAPACITY);
        Long hotspareSpaceTotalCapacity = TLVParamUtil.getCapacityBySectorValue(record, XveTLV.StoragePool.HOTSPARESPACETOTALCAPACITY);
        XveTLVTransition.setStoragePoolCapacity(xvePool, totalCapacity, usedCapacity, freeCapacity, hotspareSpaceConsumedCapacity, hotspareSpaceTotalCapacity);
        return xvePool;
    }

    private static void setStoragePoolTierInfo(Record record, XveStoragePool xvePool) {
        Integer tier0RaidLv = TLVParamUtil.getEnumValue(record, XveTLV.StoragePool.TIER0RAIDLV);
        Integer tier0DiskType = TLVParamUtil.getEnumValue(record, XveTLV.StoragePool.TIER0DISKTYPE);
        Integer tier0HotspareSpaceStrategy = TLVParamUtil.getEnumValue(record, XveTLV.StoragePool.TIER0HOTSPARESPACESTRATEGY);
        Integer tier0RaidDiskNum = TLVParamUtil.getIntValue(record, XveTLV.StoragePool.TIER0RAIDDISKNUM);
        Integer tier0DiskNum = TLVParamUtil.getIntValue(record, XveTLV.StoragePool.TIER0DISKNUM);
        Integer tier1RaidLv = TLVParamUtil.getEnumValue(record, XveTLV.StoragePool.TIER1RAIDLV);
        Integer tier1DiskType = TLVParamUtil.getEnumValue(record, XveTLV.StoragePool.TIER1DISKTYPE);
        Integer tier1HotspareSpaceStrategy = TLVParamUtil.getEnumValue(record, XveTLV.StoragePool.TIER1HOTSPARESPACESTRATEGY);
        Integer tier1RaidDiskNum = TLVParamUtil.getIntValue(record, XveTLV.StoragePool.TIER1RAIDDISKNUM);
        Integer tier1DiskNum = TLVParamUtil.getIntValue(record, XveTLV.StoragePool.TIER1DISKNUM);
        Integer tier2RaidLv = TLVParamUtil.getEnumValue(record, XveTLV.StoragePool.TIER2RAIDLV);
        Integer tier2DiskType = TLVParamUtil.getEnumValue(record, XveTLV.StoragePool.TIER2DISKTYPE);
        Integer tier2HotspareSpaceStrategy = TLVParamUtil.getEnumValue(record, XveTLV.StoragePool.TIER2HOTSPARESPACESTRATEGY);
        Integer tier2RaidDiskNum = TLVParamUtil.getIntValue(record, XveTLV.StoragePool.TIER2RAIDDISKNUM);
        Integer tier2DiskNum = TLVParamUtil.getIntValue(record, XveTLV.StoragePool.TIER2DISKNUM);
        xvePool.setTier0RaidLv(tier0RaidLv);
        xvePool.setTier0DiskType(tier0DiskType);
        xvePool.setTier0HotspareSpaceStrategy(tier0HotspareSpaceStrategy);
        xvePool.setTier0RaidDiskNum(tier0RaidDiskNum);
        xvePool.setTier0DiskNum(tier0DiskNum);
        xvePool.setTier1RaidLv(tier1RaidLv);
        xvePool.setTier1DiskType(tier1DiskType);
        xvePool.setTier1HotspareSpaceStrategy(tier1HotspareSpaceStrategy);
        xvePool.setTier1RaidDiskNum(tier1RaidDiskNum);
        xvePool.setTier1DiskNum(tier1DiskNum);
        xvePool.setTier2RaidLv(tier2RaidLv);
        xvePool.setTier2DiskType(tier2DiskType);
        xvePool.setTier2HotspareSpaceStrategy(tier2HotspareSpaceStrategy);
        xvePool.setTier2RaidDiskNum(tier2RaidDiskNum);
        xvePool.setTier2DiskNum(tier2DiskNum);
        String tier0disklist = record.getParamStrValue(XveTLV.StoragePool.TIER0DISKLIST.getParamIndex());
        String tier1disklist = record.getParamStrValue(XveTLV.StoragePool.TIER1DISKLIST.getParamIndex());
        String tier2disklist = record.getParamStrValue(XveTLV.StoragePool.TIER2DISKLIST.getParamIndex());
        xvePool.setTier0DiskList(tier0disklist);
        xvePool.setTier1DiskList(tier1disklist);
        xvePool.setTier2DiskList(tier2disklist);
    }

    private static void setStoragePoolCapacity(XveStoragePool storagePool, Long totalCapacity, Long usedCapacity, Long freeCapacity, Long hotspareSpaceConsumedCapacity, Long hotspareSpaceTotalCapacity) {
        if (null != totalCapacity) {
            storagePool.setTotalCapacity(Double.valueOf(UnitConvert.convert((Double)NumberUtil.convertToDouble((Object)totalCapacity), (IUnitType)CapabilityUnitType.BYTE, (IUnitType)CapabilityUnitType.MB)));
            storagePool.setTotalCapacityUnit(CapabilityUnitType.MB.name());
        }
        if (null != usedCapacity) {
            storagePool.setUsedCapacity(Double.valueOf(UnitConvert.convert((Double)NumberUtil.convertToDouble((Object)usedCapacity), (IUnitType)CapabilityUnitType.BYTE, (IUnitType)CapabilityUnitType.MB)));
            storagePool.setUsedCapacityUnit(CapabilityUnitType.MB.name());
        }
        if (null != freeCapacity) {
            storagePool.setFreeCapacity(Double.valueOf(UnitConvert.convert((Double)NumberUtil.convertToDouble((Object)freeCapacity), (IUnitType)CapabilityUnitType.BYTE, (IUnitType)CapabilityUnitType.MB)));
            storagePool.setUsedCapacityUnit(CapabilityUnitType.MB.name());
        }
        if (null != hotspareSpaceConsumedCapacity) {
            Double hotSpareSpaceUsed = NumberUtil.convertToDouble((Object)hotspareSpaceConsumedCapacity);
            storagePool.setHotspareSpaceConsumedCapacity(Double.valueOf(UnitConvert.convert((Double)hotSpareSpaceUsed, (IUnitType)CapabilityUnitType.BYTE, (IUnitType)CapabilityUnitType.MB)));
            storagePool.setHotspareSpaceConsumedCapacityUnit(CapabilityUnitType.MB.name());
        }
        if (null != hotspareSpaceTotalCapacity) {
            storagePool.setHotspareSpaceTotalCapacity(Double.valueOf(UnitConvert.convert((Double)NumberUtil.convertToDouble((Object)hotspareSpaceTotalCapacity), (IUnitType)CapabilityUnitType.BYTE, (IUnitType)CapabilityUnitType.MB)));
            storagePool.setHotspareSpaceTotalCapacityUnit(CapabilityUnitType.MB.name());
        }
    }

    public static XveDisk transitionXveDisk(String deviceId, Record record) {
        String diskId = record.getParamStrValue(XveTLVParent.Disk.ID.getParamIndex());
        XveDisk xveDisk = new XveDisk();
        XveTLVTransition.setXveDiskProperties(deviceId, record, diskId, xveDisk);
        XveTLVTransition.setPhysicalDiskProperties(deviceId, record, diskId, xveDisk);
        return xveDisk;
    }

    private static void setPhysicalDiskProperties(String deviceId, Record record, String diskId, XveDisk xveDisk) {
        String phyType;
        Integer diskType = TLVParamUtil.getEnumValue(record, XveTLVParent.Disk.DISKTYPE);
        if (null == diskType) {
            diskType = -1;
        }
        Long sectors = TLVParamUtil.getLongValue(record, XveTLVParent.Disk.SECTORS);
        Integer sectorSize = TLVParamUtil.getIntValue(record, XveTLVParent.Disk.SECTORSIZE);
        Integer healthStatus = V2TypeMapper.V2_DISK_HEALTH_STATE.get(TLVParamUtil.getEnumValue(record, XveTLVParent.Disk.HEALTHSTATUS));
        Integer runningStatus = V2TypeMapper.V2_DISK_RUNNING_STATE.get(TLVParamUtil.getEnumValue(record, XveTLVParent.Disk.RUNNINGSTATUS));
        Integer speedRPM = TLVParamUtil.getIntValue(record, XveTLVParent.Disk.SPEEDRPM);
        String diskSN = record.getParamStrValue(XveTLVParent.Disk.SERIALNUMBER.getParamIndex());
        String parentId = record.getParamStrValue(XveTLVParent.Disk.PARENTID.getParamIndex());
        Integer parentType = TLVParamUtil.getEnumValue(record, XveTLVParent.Disk.PARENTTYPE);
        if (null == parentType) {
            parentType = -1;
        }
        if ((phyType = DiskConstant.DiskPhysicalType.getPhysicalType((int)diskType).name()).equalsIgnoreCase("NLSAS")) {
            phyType = "NL SAS";
        }
        xveDisk.setChassisUUID(new XveUUID(deviceId, XveMOType.getType((int)parentType), parentId).toString());
        xveDisk.setUuid(new XveUUID(deviceId, XveMOType.DISK, diskId).toString());
        xveDisk.setDiskPos(record.getParamStrValue(XveTLVParent.Disk.LOCATION.getParamIndex()));
        xveDisk.setDiskType(phyType);
        xveDisk.setBoxId(NumberUtil.convertToInteger((Object)parentId));
        xveDisk.setLogicalType(TLVParamUtil.getEnumValue(record, XveTLVParent.Disk.LOGICTYPE));
        xveDisk.setHealthStatus(null == healthStatus ? Integer.valueOf(0) : healthStatus);
        xveDisk.setStatus(null == healthStatus ? Integer.valueOf(0) : healthStatus);
        xveDisk.setDiskRuntime(TLVParamUtil.getIntValue(record, XveTLVParent.Disk.RUNTIME));
        xveDisk.setDiskSN(StringUtil.trim((String)diskSN));
        xveDisk.setSerialNo(StringUtil.trim((String)diskSN));
        xveDisk.setMoVersion(record.getParamStrValue(XveTLVParent.Disk.MODEL.getParamIndex()));
        xveDisk.setPhysicalModel(record.getParamStrValue(XveTLVParent.Disk.MODEL.getParamIndex()));
        xveDisk.setRunningStatus(null == runningStatus ? Integer.valueOf(0) : runningStatus);
        xveDisk.setPoolId(record.getParamStrValue(XveTLVParent.Disk.POOLID.getParamIndex()));
        xveDisk.setFirmwareNo(record.getParamStrValue(XveTLVParent.Disk.FIRMWAREVER.getParamIndex()));
        xveDisk.setManufacture(record.getParamStrValue(XveTLVParent.Disk.MANUFACTURER.getParamIndex()));
        xveDisk.setTemperature(TLVParamUtil.getIntValue(record, XveTLVParent.Disk.TEMPERATURE));
        if (null != speedRPM) {
            xveDisk.setSpinSpeed(Long.valueOf(speedRPM.intValue()));
        }
        if (null != sectors && null != sectorSize) {
            xveDisk.setTotalCapacity(Double.valueOf(UnitConvert.convert((Double)NumberUtil.convertToDouble((Object)(sectors * (long)sectorSize.intValue())), (IUnitType)CapabilityUnitType.BYTE, (IUnitType)CapabilityUnitType.GB)));
            xveDisk.setTotalCapacityUnit(CapabilityUnitType.GB.name());
        }
    }

    private static void setXveDiskProperties(String deviceId, Record record, String diskId, XveDisk xveDisk) {
        String barCode = record.getParamStrValue(XveTLVParent.Disk.BARCODE.getParamIndex());
        String poolName = record.getParamStrValue(XveTLVParent.Disk.POOLNAME.getParamIndex());
        String poolTierId = record.getParamStrValue(XveTLVParent.Disk.POOLTIERID.getParamIndex());
        xveDisk.setDiskId(diskId);
        xveDisk.setBarCode(barCode);
        xveDisk.setPoolName(poolName);
        xveDisk.setPoolTierUuid(new XveUUID(deviceId, XveMOType.DISK, poolTierId).toString());
    }

    public static ArrayHost transitionArrayHost(String deviceId, Record record) {
        Integer runningStatus;
        ArrayHost arrayHost = new ArrayHost();
        String hostId = record.getParamStrValue(XveTLV.Host.ID.getParamIndex());
        String name = record.getParamStrValue(XveTLV.Host.NAME.getParamIndex());
        String mappingViewID = record.getParamStrValue(XveTLV.Host.PARENTID.getParamIndex());
        Integer os = TLVParamUtil.getEnumValue(record, XveTLV.Host.OPERATIONSYSTEM);
        if (null == os) {
            os = -1;
        }
        String description = record.getParamStrValue(XveTLV.Host.DESCRIPTION.getParamIndex());
        String location = record.getParamStrValue(XveTLV.Host.LOCATION.getParamIndex());
        String ipAddress = record.getParamStrValue(XveTLV.Host.IP.getParamIndex());
        String model = record.getParamStrValue(XveTLV.Host.MODEL.getParamIndex());
        Integer healthStatus = V2TypeMapper.HOST_HEALTH_STATE.get(TLVParamUtil.getEnumValue(record, XveTLV.Host.HEALTHSTATUS));
        if (null == healthStatus) {
            healthStatus = 0;
        }
        if (null == (runningStatus = V2TypeMapper.HOST_RUNNING_STATE.get(TLVParamUtil.getEnumValue(record, XveTLV.Host.RUNNINGSTATUS)))) {
            runningStatus = 0;
        }
        arrayHost.setUuid(new XveUUID(deviceId, XveMOType.HOST, hostId).toString());
        arrayHost.setName(name);
        arrayHost.setStatus(healthStatus);
        arrayHost.setHealthStatus(String.valueOf(healthStatus));
        arrayHost.setRunningStatus(String.valueOf(runningStatus));
        arrayHost.setHostId(hostId);
        XveEnumDefinePParent.OS_TYPE_E osType = XveEnumDefinePParent.OS_TYPE_E.valueOf((int)os);
        if (null == osType) {
            arrayHost.setOs("--");
        } else {
            arrayHost.setOs(osType.name());
        }
        arrayHost.setDescription(description);
        arrayHost.setIpAddress(ipAddress);
        arrayHost.setModel(model);
        arrayHost.setLocation(location);
        if (!VerifyUtil.isEmpty((String)mappingViewID)) {
            String mappingViewUUID = new XveUUID(deviceId, XveMOType.MAPPINGVIEW, mappingViewID).toString();
            arrayHost.setHostGroupUuid(mappingViewUUID);
        }
        return arrayHost;
    }

    public static XveTier transitionXveTier(String deviceId, Record record) {
        Integer runningStatus;
        XveTier xveTier = new XveTier();
        String tierId = record.getParamStrValue(XveTLV.StorageTier.ID.getParamIndex());
        String poolId = record.getParamStrValue(XveTLV.StorageTier.PARENTID.getParamIndex());
        String tierName = record.getParamStrValue(XveTLV.StorageTier.NAME.getParamIndex());
        Integer healthStatus = V2TypeMapper.STORAGE_TIER_HEALTH_STUS.get(TLVParamUtil.getEnumValue(record, XveTLV.StorageTier.HEALTHSTATUS));
        if (null == healthStatus) {
            healthStatus = 0;
        }
        if (null == (runningStatus = V2TypeMapper.STORAGE_TIER_RUNNING_STUS.get(TLVParamUtil.getEnumValue(record, XveTLV.StorageTier.RUNNINGSTATUS)))) {
            runningStatus = 0;
        }
        Integer raidLevel = TLVParamUtil.getEnumValue(record, XveTLV.StorageTier.RAIDLV);
        Integer diskType = TLVParamUtil.getEnumValue(record, XveTLV.StorageTier.DISKTYPE);
        Integer diskNum = TLVParamUtil.getIntValue(record, XveTLV.StorageTier.DISKNUM);
        Long totalCapacity = TLVParamUtil.getCapacityBySectorValue(record, XveTLV.StorageTier.TIERUSERCAPACITY);
        Long usedCapacity = TLVParamUtil.getCapacityBySectorValue(record, XveTLV.StorageTier.TIERCONSUMEDCAPACITY);
        Long freeCapacity = TLVParamUtil.getCapacityBySectorValue(record, XveTLV.StorageTier.TIERAVAILABLECAPACITY);
        xveTier.setUuid(new XveUUID(deviceId, XveMOType.STORAGETIER, tierId).toString());
        xveTier.setTierId(tierId);
        xveTier.setName(tierName);
        xveTier.setHealthStatus(healthStatus);
        xveTier.setStatus(healthStatus);
        xveTier.setRunningStatus(runningStatus);
        xveTier.setRaidLv(raidLevel);
        xveTier.setDiskType(diskType);
        xveTier.setDiskNum(diskNum);
        xveTier.setPoolId(poolId);
        xveTier.setPoolUuid(new XveUUID(deviceId, XveMOType.STORAGEPOOL, poolId).toString());
        if (totalCapacity != null) {
            xveTier.setTierUserCapacity(Double.valueOf(UnitConvert.convert((Double)NumberUtil.convertToDouble((Object)totalCapacity), (IUnitType)CapabilityUnitType.BYTE, (IUnitType)CapabilityUnitType.MB)));
            xveTier.setTierUserCapacityUnit(CapabilityUnitType.MB.name());
        }
        if (usedCapacity != null) {
            xveTier.setTierConsumedCapacity(Double.valueOf(UnitConvert.convert((Double)NumberUtil.convertToDouble((Object)usedCapacity), (IUnitType)CapabilityUnitType.BYTE, (IUnitType)CapabilityUnitType.MB)));
            xveTier.setTierConsumedCapacityUnit(CapabilityUnitType.MB.name());
        }
        if (freeCapacity != null) {
            xveTier.setTierAvailableCapacity(Double.valueOf(UnitConvert.convert((Double)NumberUtil.convertToDouble((Object)freeCapacity), (IUnitType)CapabilityUnitType.BYTE, (IUnitType)CapabilityUnitType.MB)));
            xveTier.setTierAvailableCapacityUnit(CapabilityUnitType.MB.name());
        }
        return xveTier;
    }
}

