/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.xve;

import com.huawei.ism.array.sdk.model.ArrayUnit;
import com.huawei.ism.array.sdk.model.Controller;
import com.huawei.ism.array.sdk.model.XveIntfModule;
import com.huawei.ism.array.sdk.model.XveStorage;
import com.huawei.ism.array.sdk.model.XveUnit;
import com.huawei.ism.base.port.sdk.model.ManagementPort;
import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.base.sdk.model.StorageNE;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.service.impl.XveDeviceProxyImpl;
import com.huawei.ism.cbb.discover.xve.ConnectionManagerTlvImpl;
import com.huawei.ism.cbb.proxy.protocol.tlv.connection.TLVConnection;
import com.huawei.ism.cbb.proxy.protocol.tlv.msg.Record;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class XveUtil {
    private static final Log logger = LogFactory.getInstance((Object)new XveUtil(), (String)"UBase/Xve_Discover");

    public static StorageNE getTLVConn(String deviceId, NeMgrProtocolExtend neMgrProtocolExtend, List<String> manageIps) {
        ConnectionManagerTlvImpl connManager = new ConnectionManagerTlvImpl();
        if (connManager.isConnected(deviceId)) {
            connManager.removeConnection(deviceId);
        }
        return connManager.connect(manageIps, neMgrProtocolExtend);
    }

    public static List<String> getNewManagerIps(StorageNE storageNE, TLVConnection newConnection) {
        logger.info((Object)("Get new Managerips begin. Current Conn Ip: " + newConnection.getUrl() + " Current DeviceId=[" + newConnection.getDeviceId() + "]"), 90160777658372L);
        ArrayList<String> managerIps = new ArrayList<String>();
        try {
            String deviceID = newConnection.getDeviceId();
            IMoDao moDao = CommonDAOLocator.getMoDao();
            XveUnit xveUnitOld = (XveUnit)moDao.getMoByUuid("[deviceID=" + deviceID + ", moType=SYSTEM, id=]", Boolean.valueOf(true));
            XveStorage xveStorageOld = (XveStorage)moDao.getMoByUuid("XveStorage[deviceID=" + deviceID + ", moType=SYSTEM, id=]", Boolean.valueOf(true));
            if (null == xveUnitOld || null == xveStorageOld) {
                return managerIps;
            }
            List controllersOld = moDao.getAllSubMo(xveUnitOld.getMoId().longValue(), Controller.class);
            logger.info((Object)("Get Info from Db:XveUnit=" + xveUnitOld + " XveStorage=" + xveStorageOld + " ControllersOld=[" + controllersOld + "]"), 90160777658372L);
            XveDeviceProxyImpl xveDeviceProxy = new XveDeviceProxyImpl();
            XveUnit xveUnitNew = xveDeviceProxy.getComputerSystem(newConnection);
            List<Controller> controllersNew = xveDeviceProxy.getControllers(newConnection, xveUnitNew);
            List<XveIntfModule> intfModules = xveDeviceProxy.getIntfModules(newConnection, xveUnitNew, controllersNew);
            xveDeviceProxy.getStorageEtherPort(newConnection, xveUnitNew, intfModules, controllersNew);
            String tempMagIp = XveUtil.buildManageIPsByControllers(controllersNew);
            XveUtil.setManagerPortIp(controllersNew, moDao);
            logger.info((Object)("Link Ip=[" + storageNE.getLinkIp() + "] TempManagerIps=[" + tempMagIp + "]"), 90160777658372L);
            xveUnitOld.setLinkIp(storageNE.getLinkIp());
            if (VerifyUtil.isEmpty((String)tempMagIp)) {
                return managerIps;
            }
            xveUnitOld.setManageIps(tempMagIp);
            Integer status = xveStorageOld.getStatus();
            xveStorageOld.setArrayUnit((ArrayUnit)xveUnitOld);
            if (XveUtil.setControllerIp(controllersOld, controllersNew)) {
                for (Controller conl : controllersOld) {
                    moDao.saveOrUpdateMo((ManagedObject)conl);
                }
            }
            moDao.saveOrUpdateMo((ManagedObject)xveUnitOld);
            xveStorageOld.setStatus(status);
            moDao.saveOrUpdateMo((ManagedObject)xveStorageOld);
            logger.info((Object)("update xveStorage successstatus=" + status + ",xveStorageStatus=" + xveStorageOld.getStatus()), 90160777658372L);
            for (String ip : tempMagIp.split(",")) {
                managerIps.add(ip);
            }
            logger.info((Object)("New ManagerIps=" + managerIps), 90160777658372L);
        }
        catch (Exception ex) {
            logger.error((Object)("Get new managerips Error. " + ExceptionUtil.getErrorMessage((Throwable)ex)), 90160777658373L);
        }
        return managerIps;
    }

    private static void setManagerPortIp(List<Controller> controllersNew, IMoDao moDao) {
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(controllersNew)) {
            logger.error((Object)"setManagerPortIp, controllersNew is null");
            return;
        }
        for (Controller con : controllersNew) {
            Set portList = con.getChildMos();
            for (ManagedObject port : portList) {
                if (!(port instanceof ManagementPort)) continue;
                ManagementPort portOld = (ManagementPort)moDao.getMoByUuid(port.getUuid(), Boolean.valueOf(true));
                ManagementPort portNew = (ManagementPort)port;
                logger.info((Object)("New Port=[" + portNew.toString() + "]"), 90160777658372L);
                portOld.setIpAddress(portNew.getIpAddress());
                moDao.saveOrUpdateMo((ManagedObject)portOld);
            }
        }
    }

    private static boolean setControllerIp(List<Controller> controllersOld, List<Controller> controllersNew) {
        if (VerifyUtil.isEmpty(controllersOld) || VerifyUtil.isEmpty(controllersNew)) {
            return false;
        }
        for (Controller conNew : controllersNew) {
            for (Controller conOld : controllersOld) {
                if (!conNew.getControllerId().equals(conOld.getControllerId())) continue;
                conOld.setManageIpAddrs(conNew.getManageIpAddrs());
            }
        }
        return true;
    }

    public static String buildManageIPsByControllers(List<Controller> controllers) {
        if (controllers == null || controllers.isEmpty()) {
            return "";
        }
        String devIPs = null;
        StringBuilder buffer = new StringBuilder();
        for (Controller controller : controllers) {
            String ips = controller.getManageIpAddrs();
            if (null == ips || ips.isEmpty()) continue;
            buffer.append(',').append(ips);
        }
        if (0 < buffer.length()) {
            devIPs = buffer.substring(1);
        }
        logger.info((Object)("Manage Port Report:manageips=" + devIPs), 90160777658372L);
        return devIPs;
    }

    public static boolean socketIsNomal(TLVConnection connection) {
        if (null == connection) {
            logger.error((Object)"Connection is null", 90160777658373L);
            return false;
        }
        try {
            Record record = connection.pmGet(XveMOType.SYSTEM.getValue(), "", 30);
            if (!VerifyUtil.isEmpty((Object)record)) {
                return true;
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Report Socket Error." + ExceptionUtil.getErrorMessage((Throwable)ex)), 90160777658373L);
        }
        return false;
    }
}

