/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.xve.process;

import com.huawei.ism.array.sdk.model.ArrayUnit;
import com.huawei.ism.array.sdk.model.MappingView;
import com.huawei.ism.array.sdk.model.XveLun;
import com.huawei.ism.array.sdk.model.XveStorage;
import com.huawei.ism.array.sdk.model.XveStoragePool;
import com.huawei.ism.array.sdk.model.XveUnit;
import com.huawei.ism.base.port.sdk.model.ManagementPort;
import com.huawei.ism.base.sdk.model.StorageNE;
import com.huawei.ism.cbb.discover.array.ArrayDiscoverUtil;
import com.huawei.ism.cbb.discover.framework.AbstractContext;
import com.huawei.ism.cbb.discover.framework.IProcessor;
import com.huawei.ism.cbb.discover.service.XveDeviceProxy;
import com.huawei.ism.cbb.discover.service.impl.XveDeviceProxyImpl;
import com.huawei.ism.cbb.proxy.protocol.tlv.connection.ConnectionManager;
import com.huawei.ism.cbb.proxy.protocol.tlv.connection.TLVConnection;
import com.huawei.ism.cbb.util.TimeUtil;
import com.huawei.ism.cbb.util.unit.CapabilityUnitType;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.HashSet;
import java.util.List;
import java.util.TimeZone;

public class RetrieveXveStorageProcessor
implements IProcessor {
    private static final int LUNSIZE_LIMIT = 500;
    private final Log logger = LogFactory.getInstance((Object)this, (String)"UBase/Xve_Discover");

    public void clean(AbstractContext cmd) {
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public boolean process(AbstractContext context) {
        StorageNE device = (StorageNE)context.getAttribute("StorageDevice");
        if (null == device) {
            this.logger.error((Object)"StorageDevice is null.");
            throw new LegoCheckedException(1073947393L);
        }
        String deviceID = device.getSn();
        TLVConnection connection = (TLVConnection)ConnectionManager.getInstance().getConnection(deviceID);
        XveDeviceProxyImpl xveDeviceProxy = new XveDeviceProxyImpl();
        XveUnit xveUnit = xveDeviceProxy.getComputerSystem(connection);
        xveDeviceProxy.getControllers(connection, xveUnit);
        List<MappingView> mappingViews = xveDeviceProxy.getMappingViews(connection, xveUnit);
        xveDeviceProxy.getHosts(connection, xveUnit, mappingViews);
        xveDeviceProxy.getInitiators(connection, xveUnit);
        TimeZone timeZone = xveDeviceProxy.getSystemTimeZoneInfo(connection);
        List<XveStoragePool> storagePools = xveDeviceProxy.getStoragePools(connection, xveUnit);
        List<XveLun> xveLuns = xveDeviceProxy.getLuns(connection, deviceID, storagePools);
        if (null != xveLuns && xveLuns.size() > 500) {
            this.logger.info((Object)("the lun size is more than 500, lun size is :" + xveLuns.size()), 90160777658372L);
            for (XveStoragePool storagePool : storagePools) {
                storagePool.setChildMos(new HashSet());
            }
            context.setAttribute("XveLun", xveLuns);
        }
        xveUnit.setTopMoUuid("XveStorage" + xveUnit.getUuid());
        XveStorage xveStorage = new XveStorage();
        xveStorage.setUuid("XveStorage" + xveUnit.getUuid());
        xveStorage.setIsTopMo(Boolean.valueOf(true));
        xveStorage.setManaged(Boolean.valueOf(true));
        xveStorage.setManufacturer("Huawei Technologies Co., Ltd.");
        xveStorage.setManagementProtocol("TLV");
        String timezoneFormat = TimeUtil.getTimeZoneOffset((TimeZone)timeZone);
        xveStorage.setTimezoneFormat(timezoneFormat);
        xveUnit.setTimezoneFormat(timezoneFormat);
        this.processIps(connection, xveDeviceProxy, xveStorage, xveUnit);
        xveStorage.setArrayUnit((ArrayUnit)xveUnit);
        xveStorage.setTotalLunCap(Double.valueOf(ArrayDiscoverUtil.getTotalLunCap(xveLuns)));
        xveStorage.setTotalLunCapUnit(CapabilityUnitType.MB.name());
        xveStorage.setMappedLunCap(Double.valueOf(ArrayDiscoverUtil.getMappedLunCap(xveLuns)));
        xveStorage.setMappedLunCapUnit(CapabilityUnitType.MB.name());
        xveStorage.addChildMo((ManagedObject)xveUnit);
        xveUnit.setParentMo((ManagedObject)xveStorage);
        xveStorage.setManagementProtocolMap(device.getManagementProtocolMap());
        context.setAttribute("ArrayUnit", (Object)xveUnit);
        context.setAttribute("StorageArray", (Object)xveStorage);
        return true;
    }

    private void processIps(TLVConnection connection, XveDeviceProxy proxy, XveStorage storage, XveUnit unit) {
        StringBuilder sb = new StringBuilder();
        String linkIp = unit.getLinkIp();
        sb.append(linkIp);
        if (!unit.isHasSvp()) {
            List<ManagementPort> managementIps = proxy.getManagementPorts(connection, unit);
            for (ManagementPort managementPort : managementIps) {
                if (linkIp.equals(managementPort.getIpAddress())) continue;
                sb.append(",").append(managementPort.getIpAddress());
            }
        }
        storage.setLinkIp(linkIp);
        storage.setIpAddress(linkIp);
        storage.setManagedIps(sb.toString());
        unit.setManageIps(sb.toString());
        this.logger.info((Object)("XVE device mgmt Port info:" + storage.getSn() + ":" + storage.getManagedIps()), 90160777658372L);
    }

    public void postProcess(AbstractContext context) {
    }
}

