/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.proxy.util;

import com.huawei.lego.core.sdk.file.util.AdapterUtils;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.springframework.beans.factory.InitializingBean;

public class ResourceHelper
implements InitializingBean {
    private static final String DEFAULT_PROPERTIES = "conf.properties";
    private static final Log logger = LogFactory.getInstance(ResourceHelper.class);
    private static Properties props = null;

    public static String getValue(String key) {
        return ResourceHelper.getValue(key, null);
    }

    public static String getValue(String key, String defaultValue) {
        String value = defaultValue;
        if (props != null) {
            value = props.getProperty(key, defaultValue);
        }
        return value;
    }

    private void readProperties() {
        logger.info((Object)"Method readProperties is start!", 90160758784000L);
        props = new Properties();
        InputStream stream = null;
        try {
            stream = AdapterUtils.getStreamResourceFromJar(ResourceHelper.class, (String)DEFAULT_PROPERTIES);
            if (stream != null) {
                props.load(stream);
            }
        }
        catch (IOException e) {
            logger.error((Object)"read default.properties fail.", 90160758784000L);
        }
        finally {
            if (null != stream) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    logger.error((Object)"read default.properties fail.", 90160758784000L);
                }
            }
        }
        logger.info((Object)"Method readProperties is end!", 90160758784000L);
    }

    public void afterPropertiesSet() {
        this.readProperties();
    }
}

