/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.detect;

import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnectionManager;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.detect.ResourceDetectedEvent;
import com.huawei.ism.drm.detect.ResourceEventIterator;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.storage.hvs.discovery.proxy.HvsDeviceEvent;
import com.huawei.ism.drm.storage.hvs.discovery.proxy.HvsDeviceQuery;
import com.huawei.ism.drm.storage.sdk.model.DrStorage;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Collectors;

public class HvsStorageEventIteratorBuilder {
    private static final int PAGE_SIZE = 100;
    private final DrStorage storage;
    private final BiFunction<RestConnection, HvsDeviceQuery, List<HvsDeviceEvent>> function;
    private final Map<String, Object> conditions;

    public HvsStorageEventIteratorBuilder(DrStorage storage, BiFunction<RestConnection, HvsDeviceQuery, List<HvsDeviceEvent>> function, Map<String, Object> conditions) {
        this.storage = Objects.requireNonNull(storage);
        this.function = Objects.requireNonNull(function);
        this.conditions = Objects.requireNonNull(conditions);
    }

    public ResourceEventIterator<DrStorage, HvsDeviceEvent> build() {
        return new ResourceEventIterator(this::load);
    }

    private List<ResourceDetectedEvent<DrStorage, HvsDeviceEvent>> load(int page) {
        RestConnection hvsConnection = RestConnectionManager.getInstance().getConnection(this.storage.getDeviceSn());
        if (VerifyUtil.isEmpty((Object)hvsConnection)) {
            return Collections.emptyList();
        }
        HvsDeviceQuery query = HvsDeviceQuery.builder().index(page * 100).count(100).filters(this.conditions).build();
        return ((List)hvsConnection.use(this.function).apply(query)).stream().map(this::buildResourceEvent).collect(Collectors.toList());
    }

    private ResourceDetectedEvent<DrStorage, HvsDeviceEvent> buildResourceEvent(HvsDeviceEvent hvsDeviceEvent) {
        return ResourceDetectedEvent.builder().resource((DrResource)this.storage).timestamp(NumberUtil.convertToLong((Object)hvsDeviceEvent.getSequence(), (long)0L).longValue()).data((Object)hvsDeviceEvent).build();
    }
}

