/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.discovery.process;

import com.huawei.ism.cbb.base.poll.IPoller;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.storage.manager.proxy.StoragePortLinksManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStoragePortLinksManager;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.List;

public class HvsAirGapTimeWindowPoller
implements IPoller {
    private static final Log logger = LogFactory.getInstance(HvsAirGapTimeWindowPoller.class);
    private final String uuid;
    private final String pollerType;

    public HvsAirGapTimeWindowPoller(String uuid, String pollerType) {
        this.uuid = uuid;
        this.pollerType = pollerType;
    }

    public String getPollerID() {
        return this.uuid;
    }

    public String getPollerType() {
        return this.pollerType;
    }

    public void run() {
        List airGapResourceList = this.getResourceService().getAirGapResource();
        logger.debug((Object)"Start Updating Time-window for AirGap: %s-%s. size=%s", new Object[]{this.uuid, this.pollerType, airGapResourceList.size()});
        IResourceService resourceService = (IResourceService)ServiceLocator.getInstance().getService(IResourceService.class);
        for (DrResource drResource : airGapResourceList) {
            this.updateTimeWindowForResource(resourceService, drResource);
        }
    }

    private void updateTimeWindowForResource(IResourceService resourceService, DrResource drResource) {
        try {
            String deviceSn = drResource.getDeviceSn();
            IStoragePortLinksManager mgr = StoragePortLinksManagerProxy.getInstance().getStoragePortLinksMgrByDevId(deviceSn);
            List remoteDevices = mgr.getStorageRemoteDevice(deviceSn);
            resourceService.updateTimeWindowWithLatestRemoteDevices(deviceSn, remoteDevices);
            logger.debug((Object)"Finish Updating Time-window for AirGap");
        }
        catch (Exception e) {
            logger.error((Object)"AirGap Polling failed, errorMsg: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            String devSn = drResource.getDeviceSn();
            List portsInDb = resourceService.getResourceLinkPorts(devSn);
            portsInDb.forEach(linkPort -> {
                linkPort.setOperationalStatus(Boolean.valueOf(false));
                linkPort.setEnable(Boolean.valueOf(false));
                logger.error((Object)"Get remote device and port error, set port status disable. devSn: %s", new Object[]{devSn});
                CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate(linkPort);
            });
        }
    }

    private IResourceService getResourceService() {
        return (IResourceService)ServiceLocator.getBundleService((String)"DRM_Base", (String)IResourceService.class.getName());
    }
}

