/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.discovery.process;

import com.huawei.ism.array.sdk.model.HvsUnit;
import com.huawei.ism.array.sdk.model.HyperMetroConsistentGroup;
import com.huawei.ism.array.sdk.model.HyperMetroDomain;
import com.huawei.ism.array.sdk.model.HyperMetroPair;
import com.huawei.ism.array.sdk.model.QuorumServer;
import com.huawei.ism.array.sdk.model.QuorumServerLink;
import com.huawei.ism.array.sdk.model.StorageArray;
import com.huawei.ism.array.sdk.model.XveUnit;
import com.huawei.ism.cbb.discover.framework.AbstractContext;
import com.huawei.ism.cbb.discover.framework.IProcessorEx;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnectionManager;
import com.huawei.ism.drm.site.util.DrResourceTransUtil;
import com.huawei.ism.drm.storage.hvs.discovery.proxy.HvsDeviceProxyExtend;
import com.huawei.ism.drm.storage.hvs.discovery.proxy.HvsDeviceProxyLocator;
import com.huawei.ism.drm.storage.manager.proxy.StorageReplicationManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageReplicationBaseManager;
import com.huawei.ism.drm.storage.sdk.model.HyperClone;
import com.huawei.ism.drm.storage.sdk.model.ReplicationGroup;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelation;
import com.huawei.ism.unistor.sdk.model.HyperDRRing;
import com.huawei.ism.unistor.sdk.model.VstoreHyperMetroPair;
import com.huawei.ism.unistor.sdk.model.VstoreReplicationPair;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.cbb.resource.sdk.util.ManagedObjectUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class HvsDiscoverProcessorEx
implements IProcessorEx {
    private static final Log logger = LogFactory.getInstance(HvsDiscoverProcessorEx.class);

    public void clean(AbstractContext context) {
    }

    public String getName() {
        return this.getClass().getName();
    }

    public void postProcess(AbstractContext context) {
    }

    public boolean process(AbstractContext context) {
        List<ReplicationGroup> replicationGroups;
        StorageArray storageArray = (StorageArray)context.getAttribute("StorageArray");
        HvsUnit hvsUnit = (HvsUnit)context.getAttribute("ArrayUnit");
        if (null == storageArray || null == hvsUnit) {
            logger.error((Object)"storageArray or hvsUnit is null", 90160777658373L);
            return false;
        }
        RestConnection hvsConnection = RestConnectionManager.getInstance().getConnection(hvsUnit.getDevSn());
        if (null == hvsConnection) {
            throw new LegoCheckedException(104401L);
        }
        HvsDeviceProxyExtend hvsDeviceProxyExtend = HvsDeviceProxyLocator.getInstance().getHvsDeviceProxyExtend();
        this.getVstoreReplicationPairs(hvsUnit, hvsConnection, hvsDeviceProxyExtend);
        ArrayList<Object> replicationRelations = new ArrayList<Object>();
        List<ReplicationPair> relations = this.getReplicationPairs(storageArray, hvsUnit);
        if (!VerifyUtil.isEmpty(relations)) {
            replicationRelations.addAll(relations);
        }
        if (!VerifyUtil.isEmpty(replicationGroups = this.getReplicationGroups(storageArray, hvsUnit))) {
            replicationRelations.addAll(replicationGroups);
        }
        this.checkAndBuildReplicationPairDRRing(relations, replicationGroups);
        this.getVstoreHyperMetroPairs(hvsUnit, hvsConnection, hvsDeviceProxyExtend);
        this.getHyperCloneInfo(hvsUnit, hvsConnection, hvsDeviceProxyExtend);
        this.getHyperMetroInfo(hvsUnit, hvsConnection, hvsDeviceProxyExtend);
        for (ReplicationRelation replicationRelation : replicationRelations) {
            if (VerifyUtil.isEmpty((String)replicationRelation.getDrRingId())) continue;
            this.getHyperDRRings(hvsUnit, hvsConnection, hvsDeviceProxyExtend);
            break;
        }
        DrResourceTransUtil.updateDrStorageByXveUnit((XveUnit)hvsUnit);
        return true;
    }

    private void checkAndBuildReplicationPairDRRing(List<ReplicationPair> relations, List<ReplicationGroup> replicationGroups) {
        if (VerifyUtil.isEmpty(relations) || VerifyUtil.isEmpty(replicationGroups)) {
            return;
        }
        HashMap<String, String> replicationGroupMap = new HashMap<String, String>();
        for (ReplicationGroup replicationGroup : replicationGroups) {
            replicationGroupMap.put(replicationGroup.getReplicationId(), replicationGroup.getDrRingId());
        }
        for (ReplicationPair replicationPair : relations) {
            if (!VerifyUtil.isEmpty((String)replicationPair.getDrRingId())) continue;
            replicationPair.setDrRingId((String)replicationGroupMap.get(replicationPair.getConsistentGroupId()));
        }
    }

    private List<HyperDRRing> getHyperDRRings(HvsUnit hvsUnit, RestConnection hvsConnection, HvsDeviceProxyExtend hvsDeviceProxyExtend) {
        try {
            List<HyperDRRing> rings = hvsDeviceProxyExtend.getHyperDRRings(hvsConnection);
            if (null != rings && !rings.isEmpty()) {
                for (HyperDRRing ring : rings) {
                    hvsUnit.addChildMo((ManagedObject)ring);
                    ring.setParentMo((ManagedObject)hvsUnit);
                    ring.setTopMoUuid(hvsUnit.getTopMoUuid());
                }
            }
            return rings;
        }
        catch (LegoCheckedException ex) {
            logger.error((Object)("Exception while query HyperDRRings, sn=" + hvsUnit.getDevSn() + ExceptionUtil.getErrorMessage((Throwable)ex)), 90160777658373L);
            return Collections.emptyList();
        }
    }

    private List<VstoreHyperMetroPair> getVstoreHyperMetroPairs(HvsUnit hvsUnit, RestConnection hvsConnection, HvsDeviceProxyExtend hvsDeviceProxyExtend) {
        String productVersion = hvsUnit.getProductVersion();
        hvsConnection.setProductVersion(productVersion);
        List<VstoreHyperMetroPair> vstoreHyperMetroPairs = hvsDeviceProxyExtend.getVstoreHyperMetroPairs(hvsConnection);
        ManagedObjectUtil.associate(vstoreHyperMetroPairs, (ManagedObject)hvsUnit, (boolean)true);
        return vstoreHyperMetroPairs;
    }

    private List<VstoreReplicationPair> getVstoreReplicationPairs(HvsUnit hvsUnit, RestConnection hvsConnection, HvsDeviceProxyExtend hvsDeviceProxyExtend) {
        String productVersion = hvsUnit.getProductVersion();
        hvsConnection.setProductVersion(productVersion);
        List<VstoreReplicationPair> vstorePairs = hvsDeviceProxyExtend.getVstoreReplicationPairs(hvsConnection);
        ManagedObjectUtil.associate(vstorePairs, (ManagedObject)hvsUnit, (boolean)true);
        return vstorePairs;
    }

    private void getHyperCloneInfo(HvsUnit hvsUnit, RestConnection conn, HvsDeviceProxyExtend hvsDeviceProxyExtend) {
        try {
            List<HyperClone> hyperClones = hvsDeviceProxyExtend.getAllHyperClones(conn, hvsUnit.getDevSn());
            ManagedObjectUtil.associate(hyperClones, (ManagedObject)hvsUnit, (boolean)true);
        }
        catch (Exception ex) {
            logger.error((Object)("Exception while query HyperClone info, sn=" + hvsUnit.getDevSn() + ExceptionUtil.getErrorMessage((Throwable)ex)));
        }
    }

    private void getHyperMetroInfo(HvsUnit hvsUnit, RestConnection conn, HvsDeviceProxyExtend hvsDeviceProxyExtend) {
        List<HyperMetroDomain> domains;
        try {
            List<QuorumServer> quorumServers = hvsDeviceProxyExtend.getQuorumServers(conn);
            ManagedObjectUtil.associate(quorumServers, (ManagedObject)hvsUnit, (boolean)true);
        }
        catch (Exception ex) {
            logger.error((Object)("Exception while query QuorumServer info, sn=%s, ErrorMessage: %s" + ExceptionUtil.getErrorMessage((Throwable)ex)), new Object[]{hvsUnit.getDevSn(), 90160777658373L});
        }
        try {
            List<QuorumServerLink> links = hvsDeviceProxyExtend.getQuorumServerLinks(conn);
            ManagedObjectUtil.associate(links, (ManagedObject)hvsUnit, (boolean)true);
        }
        catch (Exception ex) {
            logger.error((Object)("Exception while query QuorumServerLink info, sn=%s, ErrorMessage: %s" + ExceptionUtil.getErrorMessage((Throwable)ex)), new Object[]{hvsUnit.getDevSn(), 90160777658373L});
        }
        try {
            domains = hvsDeviceProxyExtend.getHyperMetroDomains(conn);
            ManagedObjectUtil.associate(domains, (ManagedObject)hvsUnit, (boolean)true);
        }
        catch (Exception ex) {
            logger.error((Object)("Exception while query HyperMetroDomain info, sn=%s, ErrorMessage: %s" + ExceptionUtil.getErrorMessage((Throwable)ex)), new Object[]{hvsUnit.getDevSn(), 90160777658373L});
        }
        try {
            domains = hvsDeviceProxyExtend.getNasHyperMetroDomains(conn);
            ManagedObjectUtil.associate(domains, (ManagedObject)hvsUnit, (boolean)true);
        }
        catch (Exception ex) {
            logger.error((Object)("Exception while query NasHyperMetroDomain info, sn=%s, ErrorMessage: %s" + ExceptionUtil.getErrorMessage((Throwable)ex)), new Object[]{hvsUnit.getDevSn(), 90160777658373L});
        }
        List<HyperMetroPair> pairs = null;
        try {
            pairs = hvsDeviceProxyExtend.getHyperMetroPairs(conn, null);
            ManagedObjectUtil.associate(pairs, (ManagedObject)hvsUnit, (boolean)true);
        }
        catch (Exception ex) {
            logger.error((Object)("Exception while query HyperMetroPair info, sn=%s, ErrorMessage: %s" + ExceptionUtil.getErrorMessage((Throwable)ex)), new Object[]{hvsUnit.getDevSn(), 90160777658373L});
        }
        List<HyperMetroConsistentGroup> groups = null;
        try {
            groups = hvsDeviceProxyExtend.getHyperMetroConsistentGroups(conn);
            ManagedObjectUtil.associate(groups, (ManagedObject)hvsUnit, (boolean)true);
        }
        catch (Exception ex) {
            logger.error((Object)("Exception while query HyperMetroConsistentGroup info, sn=%s, ErrorMessage: %s" + ExceptionUtil.getErrorMessage((Throwable)ex)), new Object[]{hvsUnit.getDevSn(), 90160777658373L});
        }
        this.checkAndBuildHyperMetroPairDRRing(pairs, groups);
    }

    private void checkAndBuildHyperMetroPairDRRing(List<HyperMetroPair> pairs, List<HyperMetroConsistentGroup> groups) {
        if (VerifyUtil.isEmpty(pairs) || VerifyUtil.isEmpty(groups)) {
            return;
        }
        HashMap<String, String> groupsMap = new HashMap<String, String>();
        for (HyperMetroConsistentGroup hyperMetroConsistentGroup : groups) {
            groupsMap.put(hyperMetroConsistentGroup.getId(), hyperMetroConsistentGroup.getDrRingId());
        }
        for (HyperMetroPair pair : pairs) {
            if (!VerifyUtil.isEmpty((String)pair.getDrRingId())) continue;
            pair.setDrRingId((String)groupsMap.get(pair.getCgId()));
        }
    }

    private List<ReplicationGroup> getReplicationGroups(StorageArray storageArray, HvsUnit hvsUnit) {
        try {
            String devSn = hvsUnit.getDevSn();
            StorageReplicationManagerProxy proxy = StorageReplicationManagerProxy.getInstance();
            IStorageReplicationBaseManager manager = proxy.getStorageReplicationManager(hvsUnit.getClass().getName());
            List replicationGroups = manager.getAllReplicationGroups(devSn);
            ManagedObjectUtil.associate((Collection)replicationGroups, (ManagedObject)hvsUnit, (String)storageArray.getUuid(), (boolean)true);
            return replicationGroups;
        }
        catch (Exception ex) {
            logger.error((Object)("Exception while query ReplicationGroups, sn=%s, ErrorMessage:%s" + ExceptionUtil.getErrorMessage((Throwable)ex)), new Object[]{hvsUnit.getDevSn(), 90160777658373L});
            return new ArrayList<ReplicationGroup>();
        }
    }

    private List<ReplicationPair> getReplicationPairs(StorageArray storageArray, HvsUnit hvsUnit) {
        try {
            StorageReplicationManagerProxy proxy = StorageReplicationManagerProxy.getInstance();
            IStorageReplicationBaseManager manager = proxy.getStorageReplicationManager(hvsUnit.getClass().getName());
            List replicationPairs = manager.getAllReplicationPairs(hvsUnit.getDevSn(), null);
            ManagedObjectUtil.associate((Collection)replicationPairs, (ManagedObject)hvsUnit, (String)storageArray.getUuid(), (boolean)true);
            return replicationPairs;
        }
        catch (Exception ex) {
            logger.error((Object)("Exception while query ReplicationPairs, sn=" + hvsUnit.getDevSn() + ExceptionUtil.getErrorMessage((Throwable)ex)), 90160777658373L);
            return new ArrayList<ReplicationPair>();
        }
    }

    public Set<String> getSupportedManagementProtocolTypes() {
        HashSet<String> protocolTypes = new HashSet<String>();
        protocolTypes.add("REST");
        return protocolTypes;
    }
}

