/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.handler.impl;

import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.drm.storage.handler.IStorageSnapshotHandler;
import com.huawei.ism.drm.storage.hvs.discovery.util.HVSRestTransitionExtend;
import com.huawei.ism.drm.storage.hvs.handler.impl.StorageMappingHandlerRestImpl;
import com.huawei.ism.drm.storage.sdk.model.ArraySnapshot;
import com.huawei.ism.drm.storage.sdk.model.Snapshot;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.math.NumberUtils;

public class StorageSnapshotHandlerRestImpl
extends StorageMappingHandlerRestImpl
implements IStorageSnapshotHandler {
    public List<Snapshot> querySnapshots(String devSn, XveMOType associateObjType, String associateObjId) {
        if (VerifyUtil.isEmpty((String)devSn)) {
            logger.error((Object)"query snapshots error. devSn is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        if (null == associateObjType) {
            logger.error((Object)"query snapshots error. associateObjType is null.");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)associateObjId)) {
            logger.error((Object)"query snapshots error. associateObjId is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        RestConnection connection = this.getConnection(devSn);
        StringBuilder url = new StringBuilder("/rest/${deviceID}/snapshot/associate");
        url.append("?TYPE=").append(XveMOType.SNAPSHOT.getValue());
        url.append("&ASSOCIATEOBJTYPE=").append(associateObjType.getValue());
        url.append("&ASSOCIATEOBJID=").append(associateObjId);
        url.append("&range=[0-65536]");
        logger.debug((Object)"query snapshots start. devSn=%s, url=%s.", new Object[]{devSn, url.toString()});
        ArrayList<Snapshot> snapshots = new ArrayList<Snapshot>();
        List records = connection.getBatch(url.toString(), null);
        if (!VerifyUtil.isEmpty((Collection)records)) {
            for (Map record : records) {
                ArraySnapshot snapshot = HVSRestTransitionExtend.transitionSnapshot(devSn, record);
                snapshots.add((Snapshot)snapshot);
            }
        }
        logger.debug((Object)"query snapshots finished. devSn=%s, snapshots size=%s.", new Object[]{devSn, snapshots.size()});
        return snapshots;
    }

    private List<Snapshot> querySnapshots(String devSn, String lunId, String snapshotId) {
        VerifyUtil.checkStrs((String[])new String[]{devSn, lunId});
        StringBuilder url = new StringBuilder("/rest/${deviceID}/SNAPSHOT");
        if (!VerifyUtil.isEmpty((String)snapshotId)) {
            url.append("/").append(snapshotId);
        }
        url.append("?filter=PARENTID::").append(lunId).append("&range=[0-65536]");
        ArrayList<Snapshot> snapshots = new ArrayList<Snapshot>();
        logger.debug((Object)" Query snapshots by Lun start. devSn=%s, lunId=%s.", new Object[]{devSn, lunId});
        RestConnection connection = this.getConnection(devSn);
        List records = connection.getBatch(url.toString(), null);
        if (!VerifyUtil.isEmpty((Collection)records)) {
            for (Map record : records) {
                ArraySnapshot snapshot = HVSRestTransitionExtend.transitionSnapshot(devSn, record);
                snapshots.add((Snapshot)snapshot);
            }
        }
        logger.debug((Object)" Query snapshots by Lun finished. devSn=%s, lunId=%s, snapshots Size=%s .", new Object[]{devSn, lunId, snapshots.size()});
        return snapshots;
    }

    public Snapshot renameSnapshot(String devSn, Snapshot snapshot, String newName) {
        RestConnection connection = this.getConnection(devSn);
        String snapshotId = snapshot.getId();
        Integer srcLunId = snapshot.getSrcResourceId();
        logger.debug((Object)"Rename snapshot. devSn=%s, snapshotId=%s, newName=%s.", new Object[]{devSn, snapshotId, newName});
        try {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("NAME", newName);
            connection.put("/rest/${deviceID}/snapshot/" + snapshotId, paramMap);
            snapshot.setName(newName);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("Modify SnapshotName failed. DevSN:" + devSn + ",SnapshotId:" + snapshotId + ",srcLunId:" + srcLunId), (Throwable)e);
        }
        return snapshot;
    }

    public ArraySnapshot createSnapshot(String devSn, int parentId, String snapshotName, String snapshotDesc, XveMOType parentType) {
        ArraySnapshot arraySnapshot;
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("TYPE", String.valueOf(XveMOType.SNAPSHOT.getValue()));
        paramMap.put("NAME", snapshotName);
        paramMap.put("PARENTTYPE", String.valueOf(parentType.getValue()));
        paramMap.put("PARENTID", String.valueOf(parentId));
        boolean isVasa = LegoConfig.getInstance().getBoolean("VASA", Boolean.valueOf(false));
        if (isVasa) {
            paramMap.put("SUBTYPE", "1");
            paramMap.put("isReadOnly", "0");
        }
        if (null != snapshotDesc) {
            paramMap.put("DESCRIPTION", snapshotDesc);
        }
        RestConnection connection = this.getConnection(devSn);
        logger.debug((Object)"Create snapshot. devSn=%s, paramMap=%s.", new Object[]{devSn, paramMap});
        try {
            Map result = connection.post("/rest/${deviceID}/snapshot", paramMap);
            String snapshotId = (String)result.get("ID");
            String snapshotWWN = (String)result.get("WWN");
            arraySnapshot = new ArraySnapshot();
            arraySnapshot.setId(snapshotId);
            arraySnapshot.setWwn(snapshotWWN);
            arraySnapshot.setNguid((String)result.get("NGUID"));
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("Creating Snapshot failed. DevSN:" + devSn + ",ParentID:" + parentId + ",Name:" + snapshotName), (Throwable)e);
            throw new LegoCheckedException(e.getErrorCode(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)("Creating Snapshot failed. DevSN:" + devSn + ",ParentID:" + parentId + ",Name:" + snapshotName + ExceptionUtil.getErrorMessage((Throwable)e)));
            throw new LegoCheckedException(1073948680L, "Creating Snapshot failed. DevSN:" + devSn + ",ParentID:" + parentId + ",Name:" + snapshotName, (Throwable)e);
        }
        return arraySnapshot;
    }

    public void deleteSnapshot(String deviceSN, String snapshotId) {
        RestConnection connection = this.getConnection(deviceSN);
        logger.debug((Object)"Delete snapshot. devSn=%s, snapshotId=%s.", new Object[]{deviceSN, snapshotId});
        try {
            String deleteUrl = "/rest/${deviceID}/snapshot/" + snapshotId;
            boolean isVasa = LegoConfig.getInstance().getBoolean("VASA", Boolean.valueOf(false));
            if (isVasa) {
                deleteUrl = deleteUrl + "?SUBTYPE=1";
            }
            long startTime = System.currentTimeMillis();
            connection.delete(deleteUrl, null);
            long endTime = System.currentTimeMillis();
            logger.info((Object)"Delete snapshot. devSn=%s, snapshotId=%s, time=%s", new Object[]{deviceSN, snapshotId, endTime - startTime});
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("Deleting snapshot failed. DevSN:" + deviceSN + ",Id:" + snapshotId), (Throwable)e, 90160758784001L);
            throw new LegoCheckedException(e.getErrorCode(), (Throwable)e);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("Deleting snapshot failed. DevSN:" + deviceSN + ",Id:" + snapshotId), (long)1073948679L, (String[])new String[0], (Log)logger);
        }
    }

    public void deleteSnapshot(String deviceSN, List<String> snapshotIds) {
        RestConnection connection = this.getConnection(deviceSN);
        logger.debug((Object)"batch Delete snapshot. devSn=%s, snapshotId=%s.", new Object[]{deviceSN, snapshotIds});
        try {
            String deleteUrl = "/rest/${deviceID}/snapshot/batch";
            Map<String, String> paramMap = this.constructSnapshotParams(snapshotIds);
            boolean isVasa = LegoConfig.getInstance().getBoolean("VASA", Boolean.valueOf(false));
            if (isVasa) {
                paramMap.put("SUBTYPE", "1");
            }
            long startTime = System.currentTimeMillis();
            connection.delete(deleteUrl, paramMap);
            long endTime = System.currentTimeMillis();
            logger.info((Object)"batch Delete snapshot. devSn=%s, snapshotId=%s, time=%s", new Object[]{deviceSN, snapshotIds, endTime - startTime});
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"batch Deleting snapshot failed. DevSN:%s, Id:%s, errorCode:%s", new Object[]{deviceSN, snapshotIds, e.getErrorCode()});
            throw new LegoCheckedException(e.getErrorCode(), (Throwable)e);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("batch Deleting snapshot failed. DevSN:" + deviceSN + ",Id:" + snapshotIds), (long)1073948679L, (String[])new String[0], (Log)logger);
        }
    }

    public ArraySnapshot getArraySnapshot(String deviceSN, String snapshotId) {
        RestConnection connection = this.getConnection(deviceSN);
        try {
            Map result = connection.get("/rest/${deviceID}/snapshot/" + snapshotId, null);
            logger.info((Object)result, 90160758784000L);
            if (!VerifyUtil.isEmpty((Map)result)) {
                ArraySnapshot snapshot = new ArraySnapshot();
                snapshotId = (String)result.get("ID");
                snapshot.setId(snapshotId);
                snapshot.setSnapshotType(Integer.valueOf((String)result.get("TYPE")));
                snapshot.setRunningState((String)result.get("RUNNINGSTATUS"));
                snapshot.setSnapshotName((String)result.get("NAME"));
                snapshot.setWwn((String)result.get("WWN"));
                snapshot.setNguid((String)result.get("NGUID"));
                snapshot.setRestoreProgress(Integer.valueOf(VerifyUtil.isEmpty((String)((String)result.get("ROLLBACKRATE"))) ? -1 : Integer.parseInt((String)result.get("ROLLBACKRATE"))));
                if (NumberUtils.isDigits((String)((String)result.get("PARENTID")))) {
                    snapshot.setSrcResourceId(Integer.valueOf((String)result.get("PARENTID")));
                }
                if (NumberUtils.isDigits((String)((String)result.get("SOURCELUNID")))) {
                    snapshot.setSrcResourceId(Integer.valueOf((String)result.get("SOURCELUNID")));
                }
                snapshot.setSrcResourceName((String)result.get("PARENTNAME"));
                snapshot.setIsMapped(Boolean.valueOf((String)result.get("EXPOSEDTOINITIATOR")));
                snapshot.setTimeStamp((String)result.get("TIMESTAMP"));
                return snapshot;
            }
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("Get Snapshot failed. DevSN:" + deviceSN + ",snapshotId:" + snapshotId), (Throwable)e);
            throw new LegoCheckedException(e.getErrorCode(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)("Get Snapshot failed. DevSN:" + deviceSN + ",snapshotId:" + snapshotId), (Throwable)e);
            throw new LegoCheckedException(1073948682L, "Get Snapshot failed. DevSN:" + deviceSN + ",snapshotId:" + snapshotId, (Throwable)e);
        }
        return null;
    }

    public void stopSnapshot(String deviceSN, String snapshotId) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("ID", snapshotId);
        boolean isVasa = LegoConfig.getInstance().getBoolean("VASA", Boolean.valueOf(false));
        if (isVasa) {
            paramMap.put("SUBTYPE", "1");
        }
        RestConnection connection = this.getConnection(deviceSN);
        logger.debug((Object)"Stop snapshot. devSn=%s, params=%s.", new Object[]{deviceSN, paramMap});
        long startTime = System.currentTimeMillis();
        try {
            connection.put("/rest/${deviceID}/snapshot/stop", paramMap);
            long endTime = System.currentTimeMillis();
            logger.info((Object)"Stop snapshot. devSn=%s, params=%s. time=%s", new Object[]{deviceSN, paramMap, endTime - startTime});
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("Stop snapshot failed. DevSN:" + deviceSN + ",Id:" + snapshotId), (Throwable)e, 90160758784001L);
            throw new LegoCheckedException(e.getErrorCode(), (Throwable)e);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("Stop snapshot failed. DevSN:" + deviceSN + ",Id:" + snapshotId), (long)1073948681L, (String[])new String[0], (Log)logger);
        }
    }

    public void activeSnapshot(String deviceSN, List<String> snapshotIds) {
        RestConnection connection = this.getConnection(deviceSN);
        Map<String, String> paramMap = this.constructSnapshotParams(snapshotIds);
        String url = "/rest/${deviceID}/snapshot/activate";
        boolean isVasa = LegoConfig.getInstance().getBoolean("VASA", Boolean.valueOf(false));
        if (isVasa) {
            paramMap.put("SUBTYPE", "1");
            url = "/rest/${deviceID}/snapshot/activate_vvol";
        }
        logger.debug((Object)"Active snapshot. devSn=%s, params=%s.", new Object[]{deviceSN, paramMap});
        try {
            connection.post(url, paramMap);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("Active snapshot failed. DevSN:" + deviceSN + ",Ids:" + snapshotIds), (Throwable)e, 90160758784001L);
            this.deleteSnapshot(deviceSN, snapshotIds);
            throw new LegoCheckedException(e.getErrorCode(), (Throwable)e);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("Active snapshot failed. DevSN:" + deviceSN + ",Ids:" + snapshotIds.toString()), (long)1073948689L, (String[])new String[0], (Log)logger);
        }
    }

    public void restoreSnapshot(String deviceSN, String snapshotId, String restoreSpeed, String targetId) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("ID", snapshotId);
        paramMap.put("ROLLBACKSPEED", restoreSpeed);
        boolean isVasa = LegoConfig.getInstance().getBoolean("VASA", Boolean.valueOf(false));
        if (isVasa) {
            paramMap.put("SUBTYPE", "1");
        }
        if (!VerifyUtil.isEmpty((String)targetId)) {
            paramMap.put("ROLLBACKTARGETOBJID", targetId);
        }
        RestConnection connection = this.getConnection(deviceSN);
        logger.debug((Object)"Restore snapshot. devSn=%s, params=%s.", new Object[]{deviceSN, paramMap});
        try {
            connection.put("/rest/${deviceID}/snapshot/rollback", paramMap);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("rollback snapshot failed. DevSN:" + deviceSN + ",Id:" + snapshotId), (Throwable)e, 90160758784001L);
            throw new LegoCheckedException(e.getErrorCode(), (Throwable)e);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("rollback snapshot failed. DevSN:" + deviceSN + ",Id:" + snapshotId), (long)1073948712L, (String[])new String[0], (Log)logger);
        }
    }

    public void reCreateSnapshot(String deviceSN, List<String> snapshotIds) {
        RestConnection connection = this.getConnection(deviceSN);
        logger.debug((Object)("Recreate snapshot. DevSN:" + deviceSN + ", Ids:" + snapshotIds.toString()));
        try {
            Map<String, String> paramMap = new HashMap<String, String>();
            for (String snapshotId : snapshotIds) {
                paramMap.put("ID", snapshotId);
                connection.put("/rest/${deviceID}/snapshot/stop", paramMap);
            }
            paramMap.clear();
            paramMap = this.constructSnapshotParams(snapshotIds);
            connection.post("/rest/${deviceID}/snapshot/activate", paramMap);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("Recreate snapshot failed. DevSN:" + deviceSN + ",Ids:" + snapshotIds), (Throwable)e, 90160758784001L);
            this.deleteSnapshot(deviceSN, snapshotIds);
            throw new LegoCheckedException(e.getErrorCode(), (Throwable)e);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("Recreate snapshot failed. DevSN:" + deviceSN + ",Ids:" + snapshotIds.toString()), (long)1073948690L, (String[])new String[0], (Log)logger);
        }
    }

    private Map<String, String> constructSnapshotParams(List<String> snapshotIds) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        int index = 0;
        for (String snapshotId : snapshotIds) {
            if (++index < snapshotIds.size()) {
                builder.append('\"');
                builder.append(snapshotId);
                builder.append('\"');
                builder.append(",");
                continue;
            }
            builder.append('\"');
            builder.append(snapshotId);
            builder.append('\"');
        }
        builder.append("]");
        paramMap.put("SNAPSHOTLIST", builder.toString());
        return paramMap;
    }

    public Snapshot copySnapshot(String devSn, String srcSnapshotId, String copyName, boolean isHyperCDP) {
        ArraySnapshot arraySnapshot;
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("TYPE", String.valueOf(XveMOType.SNAPSHOT.getValue()));
        paramMap.put(isHyperCDP ? "CDPID" : "ID", srcSnapshotId);
        paramMap.put("NAME", copyName);
        boolean isVasa = LegoConfig.getInstance().getBoolean("VASA", Boolean.valueOf(false));
        if (isVasa) {
            paramMap.put("SUBTYPE", "1");
            paramMap.put("isReadOnly", "0");
        }
        RestConnection connection = this.getConnection(devSn);
        logger.debug((Object)"Copy snapshot start. DevSN:%s, Id:%s, copyName:%s.", new Object[]{devSn, srcSnapshotId, copyName});
        try {
            Map<String, String> result = this.doCreateAndFilterResult(srcSnapshotId, copyName, paramMap, connection);
            String snapshotId = result.get("ID");
            String snapshotWwn = result.get("WWN");
            arraySnapshot = new ArraySnapshot();
            arraySnapshot.setId(snapshotId);
            arraySnapshot.setWwn(snapshotWwn);
            arraySnapshot.setNguid(result.get("NGUID"));
            logger.debug((Object)"Copy snapshot finished. Snapshot copy info: %s", new Object[]{result});
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"Exception while coping snapshot, devSn=%s, srcSnapshotId=%s, copyName=%s, isHyperCDP=%s", new Object[]{devSn, srcSnapshotId, copyName, isHyperCDP, e});
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"Exception while coping snapshot, devSn=%s, srcSnapshotId=%s, copyName=%s, isHyperCDP=%s, errorMsg: %s", new Object[]{devSn, srcSnapshotId, copyName, isHyperCDP, ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(1073948680L, "Exception while coping snapshot, devSn=" + devSn + ", srcSnapshotId=" + srcSnapshotId + ", copyName=" + copyName, (Throwable)e);
        }
        return arraySnapshot;
    }

    private Map<String, String> doCreateAndFilterResult(String srcSnapshotId, String copyName, Map<String, String> paramMap, RestConnection connection) {
        Map result = connection.post("/rest/${deviceID}/snapshot/createcopy", paramMap);
        if (!srcSnapshotId.equals(result.get("ID"))) {
            return result;
        }
        result = connection.get("/rest/${deviceID}/snapshot/" + srcSnapshotId, null);
        String lunId = (String)result.get("PARENTID");
        List results = connection.getBatch("/rest/${deviceID}/SNAPSHOT?filter=PARENTID::" + lunId + "&range=[0-65536]", null);
        for (Map map : results) {
            if (!copyName.equals(map.get("NAME"))) continue;
            result = map;
            break;
        }
        return result;
    }

    public String createFsSnapshot(String devSn, String fsId, String snapshotName) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("TYPE", String.valueOf(XveMOType.FSSNAPSHOT.getValue()));
        paramMap.put("NAME", snapshotName);
        paramMap.put("PARENTTYPE", String.valueOf(XveMOType.FILESYSTEM.getValue()));
        paramMap.put("PARENTID", fsId);
        RestConnection connection = this.getConnection(devSn);
        logger.debug((Object)" Create FS snapshot start. devSn=%s, fsId=%s, snapshotName=%s ", new Object[]{devSn, fsId, snapshotName});
        try {
            Map result = connection.post("/rest/${deviceID}/fssnapshot", paramMap);
            String snapshotId = (String)result.get("ID");
            logger.debug((Object)" Create FS snapshot finished. devSn=%s, fsId=%s, snapshotId=%s ", new Object[]{devSn, fsId, snapshotId});
            return snapshotId;
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("Exception while create FS snapshot, devSn=" + devSn + ", fsId=" + fsId + ", snapshotName=" + snapshotName), (Throwable)e, 90160758784001L);
            throw e;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("Exception while create FS snapshot, devSn=" + devSn + ", fsId=" + fsId + ", snapshotName=" + snapshotName), (long)1073948680L, (String[])new String[0], (Log)logger);
            return null;
        }
    }

    public void deleteFsSnapshot(String devSn, String snapshotId) {
        RestConnection connection = this.getConnection(devSn);
        logger.debug((Object)" Delete FS snapshot. devSn=%s, snapshotId=%s ", new Object[]{devSn, snapshotId});
        try {
            connection.delete("/rest/${deviceID}/fssnapshot/" + snapshotId, null);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("Exception while deleting FS snapshot, devSn=" + devSn + ", snapshotId=" + snapshotId), 90160758784001L);
            throw e;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("Exception while deleting FS snapshot, devSn=" + devSn + ", snapshotId=" + snapshotId), (long)1073948679L, (String[])new String[0], (Log)logger);
        }
    }

    public List<Snapshot> querySnapshotsByLun(String devSn, String lunId) {
        return this.querySnapshots(devSn, lunId, null);
    }

    public Optional<Snapshot> querySpecificSnapshot(String devSn, String lunId, String snapshotId) {
        List<Snapshot> snapshots = this.querySnapshots(devSn, lunId, snapshotId);
        if (VerifyUtil.isEmpty(snapshots)) {
            logger.error((Object)"No snapshot was found on device(sn:%s), lun id=%s, snapshotId=%s.", new Object[]{devSn, lunId, snapshotId});
            return Optional.empty();
        }
        return snapshots.stream().findFirst();
    }

    public List<Snapshot> queryHyperCdpSnapshotsByLun(String devSn, String lunId) {
        VerifyUtil.checkStrs((String[])new String[]{devSn, lunId});
        RestConnection connection = this.getConnection(devSn);
        String url = "/rest/${deviceID}/cdp?filter=PARENTID::" + lunId + "&range=[0-65536]";
        ArrayList<Snapshot> snapshots = new ArrayList<Snapshot>();
        logger.debug((Object)" Query HyperCDP snapshots by Lun start. devSn=%s, lunId=%s.", new Object[]{devSn, lunId});
        List records = connection.getBatch(url, null);
        if (VerifyUtil.isEmpty((Collection)records)) {
            return snapshots;
        }
        for (Map record : records) {
            ArraySnapshot snapshot = HVSRestTransitionExtend.transitionSnapshot(devSn, record);
            snapshots.add((Snapshot)snapshot);
        }
        logger.debug((Object)" Query HyperCDP snapshots by Lun finished. devSn=%s, lunId=%s, snapshots Size=%s .", new Object[]{devSn, lunId, snapshots.size()});
        return snapshots;
    }
}

