/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.handler.impl.util;

import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnectionManager;
import com.huawei.ism.drm.storage.manager.proxy.StoragePortLinksManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStoragePortLinksManager;
import com.huawei.ism.drm.storage.sdk.model.RemoteLinkDevice;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.SecurityUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RemoteDeviceUtil {
    private static final Log LOGGER = LogFactory.getInstance(RemoteDeviceUtil.class);
    private static final String REMOTE_EXECUTE_API = "/api/v2/remote_execute";

    public static RemoteLinkDevice getSpecificRemoteLinkDevice(String devSn, String remoteDevSn) {
        VerifyUtil.checkStrs((String[])new String[]{devSn, remoteDevSn});
        IStoragePortLinksManager mgr = StoragePortLinksManagerProxy.getInstance().getStoragePortLinksMgrByDevId(devSn);
        List remoteDevices = mgr.getStorageRemoteDevice(devSn);
        if (VerifyUtil.isEmpty((Collection)remoteDevices)) {
            LOGGER.error((Object)"This remote device{%s} is not queried on the current device{%s}.", new Object[]{SecurityUtil.desensitizeId((String)remoteDevSn), SecurityUtil.desensitizeId((String)devSn)});
            throw new LegoCheckedException(1677929519L);
        }
        for (RemoteLinkDevice remoteDevice : remoteDevices) {
            if (!remoteDevSn.equals(remoteDevice.getEsn())) continue;
            return remoteDevice;
        }
        LOGGER.error((Object)"This remote device{%s} is not queried on the current device{%s}.", new Object[]{SecurityUtil.desensitizeId((String)remoteDevSn), SecurityUtil.desensitizeId((String)devSn)});
        throw new LegoCheckedException(1677929519L);
    }

    public static Map<String, String> executeCommandsOnRemoteDevice(RemoteLinkDevice remoteLinkDevice, String execUrl, String execMethod, JSONObject execParams) {
        Map<String, Object> paramMap = RemoteDeviceUtil.getParamMap(remoteLinkDevice, execUrl, execMethod, execParams);
        long startTime = System.currentTimeMillis();
        Map result = RemoteDeviceUtil.getConnection(remoteLinkDevice.getLocalDevSn()).postByPipe(REMOTE_EXECUTE_API, paramMap, true);
        long endTime = System.currentTimeMillis();
        LOGGER.info((Object)"Execute commands{%s} on remote device{%s} successfully! use time=%s ms.", new Object[]{execUrl, SecurityUtil.desensitizeId((String)remoteLinkDevice.getEsn()), String.valueOf(endTime - startTime)});
        return result;
    }

    public static Map<String, Object> executeCommandsOnRemoteDevice(RemoteLinkDevice remoteLinkDevice, String execUrl, String execMethod, JSONArray execParams) {
        Map<String, Object> paramMap = RemoteDeviceUtil.getParamMap(remoteLinkDevice, execUrl, execMethod, execParams);
        long startTime = System.currentTimeMillis();
        Map result = RemoteDeviceUtil.getConnection(remoteLinkDevice.getLocalDevSn()).postBatchByPipe(REMOTE_EXECUTE_API, paramMap, true);
        long endTime = System.currentTimeMillis();
        LOGGER.info((Object)"Execute commands{%s} on remote device{%s} successfully! use time=%s ms.", new Object[]{execUrl, SecurityUtil.desensitizeId((String)remoteLinkDevice.getEsn()), String.valueOf(endTime - startTime)});
        return result;
    }

    public static List<Map<String, String>> queryOnRemoteDevice(String devSn, String execUrl, RemoteLinkDevice remoteLinkDevice) {
        List resultMapList;
        Map<String, Object> paramMap = RemoteDeviceUtil.getParamMap(remoteLinkDevice, execUrl, "GET", new JSONObject());
        long startTime = System.currentTimeMillis();
        try {
            resultMapList = RemoteDeviceUtil.getConnection(devSn).getBatchByPipeQuery(REMOTE_EXECUTE_API, paramMap);
            LOGGER.info((Object)"Success query on remote device. use time=%s ms.", new Object[]{String.valueOf(System.currentTimeMillis() - startTime)});
        }
        catch (LegoCheckedException ex) {
            LOGGER.error((Object)"Fail query on remote device, error:%s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
            throw new LegoCheckedException(ex.getErrorCode(), (Throwable)ex);
        }
        return resultMapList;
    }

    private static Map<String, Object> getParamMap(RemoteLinkDevice remoteLinkDevice, String execUrl, String execMethod, Object execParams) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("device_id", remoteLinkDevice.getDeviceId());
        paramMap.put("url", execUrl);
        paramMap.put("method", execMethod);
        paramMap.put("body", execParams);
        return paramMap;
    }

    protected static RestConnection getConnection(String devSn) {
        RestConnection connection = RestConnectionManager.getInstance().getConnection(devSn);
        if (connection == null) {
            LOGGER.error((Object)"The connection does not exist. sn = %s.", new Object[]{SecurityUtil.desensitizeId((String)devSn)});
            throw new LegoCheckedException(1073947649L);
        }
        return connection;
    }
}

