/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.manager;

import com.huawei.ism.array.sdk.model.HvsUnit;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnectionManager;
import com.huawei.ism.drm.storage.hvs.discovery.util.HVSRestTransitionExtend;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageDrStarManager;
import com.huawei.ism.unistor.sdk.model.HyperDRRing;
import com.huawei.ism.unistor.sdk.model.HyperDRRingMember;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.SecurityUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class HvsStorageDrStarManager
implements IStorageDrStarManager {
    private static final Log LOGGER = LogFactory.getInstance(HvsStorageDrStarManager.class);

    public Optional<HyperDRRing> getDrStarById(String devSn, String ringId) {
        VerifyUtil.checkStrs((String[])new String[]{devSn, ringId});
        String drStarUrl = "/rest/${deviceID}/dr_star/" + ringId;
        try {
            Map record = this.getConn(devSn).get(drStarUrl, null);
            if (VerifyUtil.isEmpty((Map)record)) {
                return Optional.empty();
            }
            return Optional.of(HVSRestTransitionExtend.transitionHyperDRRing(devSn, record));
        }
        catch (LegoCheckedException ex) {
            LOGGER.error((Object)"Get dr_star: url = %s, deviceId = %s, ringId = %s, error = %s.", new Object[]{drStarUrl, SecurityUtil.desensitizeId((String)devSn), ringId, ExceptionUtil.getErrorMessage((Throwable)ex)});
            throw ex;
        }
        catch (Exception ex) {
            LOGGER.error((Object)"Get dr_star: url = %s, deviceId = %s, ringId = %s, error = %s.", new Object[]{drStarUrl, SecurityUtil.desensitizeId((String)devSn), ringId, ExceptionUtil.getErrorMessage((Throwable)ex)});
            throw new LegoCheckedException(1677929510L);
        }
    }

    public List<HyperDRRingMember> getDrStarMemberInfos(String devSn, String ringId) {
        VerifyUtil.checkStrs((String[])new String[]{devSn, ringId});
        String drStarMemberUrl = "/rest/${deviceID}/dr_star_member/associate?ASSOCIATEOBJID=" + ringId;
        ArrayList<HyperDRRingMember> members = new ArrayList<HyperDRRingMember>();
        try {
            List records = this.getConn(devSn).getBatch(drStarMemberUrl, null);
            if (VerifyUtil.isEmpty((Collection)records)) {
                return members;
            }
            for (Map record : records) {
                members.add(HVSRestTransitionExtend.transitionHyperDRRingMember(devSn, record));
            }
            return members;
        }
        catch (LegoCheckedException ex) {
            LOGGER.error((Object)"Get dr_star member: url = %s, deviceId = %s, ringId = %s, error = %s.", new Object[]{drStarMemberUrl, SecurityUtil.desensitizeId((String)devSn), ringId, ExceptionUtil.getErrorMessage((Throwable)ex)});
            throw ex;
        }
        catch (Exception ex) {
            LOGGER.error((Object)"Get dr_star member: url = %s, deviceId = %s, ringId = %s, error = %s", new Object[]{drStarMemberUrl, SecurityUtil.desensitizeId((String)devSn), ExceptionUtil.getErrorMessage((Throwable)ex)});
            throw new LegoCheckedException(1677929511L);
        }
    }

    public void swapDrStar(String devSn, String ringId) {
        VerifyUtil.checkStrs((String[])new String[]{devSn, ringId});
        String drStarSwapUrl = "/rest/${deviceID}/dr_star/swap_dr";
        try {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("ID", ringId);
            this.getConn(devSn).put(drStarSwapUrl, paramMap);
        }
        catch (LegoCheckedException ex) {
            LOGGER.error((Object)"Swap dr_star: url = %s, deviceId = %s, ringId = %s, error = %s.", new Object[]{drStarSwapUrl, SecurityUtil.desensitizeId((String)devSn), ringId, ExceptionUtil.getErrorMessage((Throwable)ex)});
            throw ex;
        }
        catch (Exception ex) {
            LOGGER.error((Object)"Swap dr_star: url = %s, deviceId = %s, ringId = %s, error = %s.", new Object[]{drStarSwapUrl, SecurityUtil.desensitizeId((String)devSn), ringId, ExceptionUtil.getErrorMessage((Throwable)ex)});
            throw new LegoCheckedException(1677929512L);
        }
    }

    public String getStorageType() {
        return HvsUnit.class.getName();
    }

    protected RestConnection getConn(String devSn) {
        RestConnection conn = RestConnectionManager.getInstance().getConnection(devSn);
        if (VerifyUtil.isEmpty((Object)conn)) {
            throw new LegoCheckedException(1073947649L);
        }
        return conn;
    }
}

