/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.manager;

import com.huawei.ism.array.sdk.model.HvsUnit;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnectionManager;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageFileSystemCloneManager;
import com.huawei.ism.drm.storage.sdk.model.NasCloneParam;
import com.huawei.ism.drm.storage.sdk.model.NasSnapshotClone;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.HashMap;
import java.util.Map;

public class HvsStorageFileSystemCloneManager
implements IStorageFileSystemCloneManager {
    private static final Log LOGGER = LogFactory.getInstance(HvsStorageFileSystemCloneManager.class);

    public String getStorageType() {
        return HvsUnit.class.getName();
    }

    private void checkConnection(String devSn, RestConnection connection) {
        if (VerifyUtil.isEmpty((Object)connection)) {
            LOGGER.error((Object)"Failed to get the connection. devSn=%s.", new Object[]{devSn});
            throw new LegoCheckedException(1073947393L);
        }
    }

    public NasSnapshotClone createFilesSystemClone(String devSn, NasCloneParam param) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("NAME", param.getName());
        paramMap.put("PARENTFILESYSTEMID", param.getParentFilesystemId());
        if (!VerifyUtil.isEmpty((String)param.getParentSnapshotId())) {
            paramMap.put("PARENTSNAPSHOTID", param.getParentSnapshotId());
        }
        if (!VerifyUtil.isEmpty((String)param.getScheduleName())) {
            paramMap.put("scheduleName", param.getScheduleName());
        }
        paramMap.put("DESCRIPTION", param.getDescription());
        paramMap.put("vstoreId", param.getVstoreId());
        RestConnection connection = RestConnectionManager.getInstance().getConnection(devSn);
        this.checkConnection(devSn, connection);
        try {
            String url = "/rest/${deviceID}/filesystem";
            LOGGER.info((Object)"Post createFilesSystemClone: url = %s, params = %s.", new Object[]{url, ((Object)paramMap).toString()});
            Map res = connection.post(url, paramMap);
            NasSnapshotClone nasSnapshotClone = this.transToNasSnapshotClone(res);
            nasSnapshotClone.setDevSn(devSn);
            nasSnapshotClone.setShareType(param.getShareType());
            return nasSnapshotClone;
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Create filesSystemClone failed. devSn:%s, name:%s, parentsnapshotid:%s, error:%s.", new Object[]{devSn, param.getName(), param.getParentSnapshotId(), ExceptionUtil.getErrorMessage((Throwable)e)});
            throw e;
        }
    }

    private NasSnapshotClone transToNasSnapshotClone(Map<String, String> res) {
        NasSnapshotClone nasSnapshotClone = new NasSnapshotClone();
        nasSnapshotClone.setId(res.get("ID"));
        nasSnapshotClone.setName(res.get("NAME"));
        nasSnapshotClone.setParentFilesystemId(res.get("PARENTFILESYSTEMID"));
        nasSnapshotClone.setParentSnapshotId(res.get("PARENTSNAPSHOTID"));
        nasSnapshotClone.setVstoreId(res.get("vstoreId"));
        return nasSnapshotClone;
    }

    public OperationResult splitFilesSystemClone(String devSn, NasCloneParam param) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("ID", param.getId());
        paramMap.put("SPLITSPEED", param.getCloneSplitRate());
        paramMap.put("deleteParentSnapshot", param.isDeleteParentSnapshot());
        paramMap.put("vstoreId", param.getVstoreId());
        paramMap.put("action", "1");
        RestConnection connection = RestConnectionManager.getInstance().getConnection(devSn);
        this.checkConnection(devSn, connection);
        try {
            String url = "/rest/${deviceID}/clone_fs_split";
            LOGGER.info((Object)"Put splitFilesSystemClone: url = %s, params = %s.", new Object[]{url, ((Object)paramMap).toString()});
            connection.putForObject(url, paramMap);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Create filesSystemClone failed. devSn:%s, id:%s, vstoreId:%s, error:%s.", new Object[]{devSn, param.getId(), param.getVstoreId(), ExceptionUtil.getErrorMessage((Throwable)e)});
            return new OperationResult("ism.drm.split.filesSystemClone.operation", true, false, String.valueOf(e.getErrorCode()), e.getParameters());
        }
        return new OperationResult("ism.drm.split.filesSystemClone.operation", true, true, new String[0]);
    }
}

