/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.manager;

import com.huawei.ism.array.sdk.model.ArrayHost;
import com.huawei.ism.array.sdk.model.ArrayHostGroup;
import com.huawei.ism.array.sdk.model.HvsUnit;
import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.array.sdk.model.Mapping;
import com.huawei.ism.array.sdk.model.MappingView;
import com.huawei.ism.array.sdk.model.XveLunGroup;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.drm.base.util.DrmStorageUtil;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.recovery.sdk.model.HostGroupVO;
import com.huawei.ism.drm.recovery.sdk.model.HostVO;
import com.huawei.ism.drm.storage.handler.IStorageHostHandler;
import com.huawei.ism.drm.storage.handler.IStorageLunHandler;
import com.huawei.ism.drm.storage.handler.IStorageMappingHandler;
import com.huawei.ism.drm.storage.hvs.manager.BaseHvsStorageManager;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageLunManager;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public class HvsStorageLunManager
extends BaseHvsStorageManager
implements IStorageLunManager {
    private static final Log logger = LogFactory.getInstance(HvsStorageLunManager.class);
    private static final int TIME_OUT = 180;
    private static final int PER_BATCH_TASK_AMOUNT = 20;
    private IStorageLunHandler handler;

    public String getStorageType() {
        return HvsUnit.class.getName();
    }

    public List<Lun> queryLuns(String deviceSn, List<String> lunIds) {
        List<Object> luns = new ArrayList<Lun>();
        if (VerifyUtil.isEmpty(lunIds)) {
            return luns;
        }
        ArrayList<QueryLunTask> queryLunTasks = new ArrayList<QueryLunTask>();
        for (String lunId : lunIds) {
            QueryLunTask queryLunTask = new QueryLunTask(deviceSn, lunId);
            queryLunTasks.add(queryLunTask);
        }
        luns = ExecutionService.batchSubmit(queryLunTasks, (ExecutionService.ExecuteType)ExecutionService.ExecuteType.FAILED_ABORT, (int)180, (int)20);
        if (null != luns && luns.size() != lunIds.size()) {
            logger.error((Object)("Querying lun failed.DevSN:" + deviceSn + ",LunIds:" + lunIds), 90160758784001L);
            throw new LegoCheckedException(1073948705L);
        }
        return luns;
    }

    public List<Lun> queryAllLunsBySn(String deviceSn) {
        try {
            return this.handler.queryAllLunBySn(deviceSn);
        }
        catch (LegoCheckedException le) {
            logger.error((Object)("query arry all luns failed, errorcode:" + le.getErrorCode() + "," + le.getMessage()));
            throw le;
        }
        catch (Exception e) {
            logger.error((Object)("Not found, LUN info=" + deviceSn + ":" + ExceptionUtil.getErrorMessage((Throwable)e)));
            throw new LegoCheckedException(1073948705L, (Throwable)e);
        }
    }

    public List<Lun> queryLunsWithHostName(String deviceSn, List<String> lunIds) {
        List<Lun> luns = this.queryLuns(deviceSn, lunIds);
        IStorageMappingHandler mappingHandler = this.getHandlerMgr().getMappingHandler();
        for (Lun lun : luns) {
            List mappings = null;
            try {
                mappings = mappingHandler.getMapping(deviceSn, XveMOType.LUN, lun.getLunId());
            }
            catch (LegoCheckedException le) {
                if (le.getErrorCode() == 404L) {
                    logger.error((Object)"current version not support this url, only after dorado v6 support.");
                }
                throw le;
            }
            if (null != mappings && mappings.size() >= 1) {
                for (Mapping mapping : mappings) {
                    if (!VerifyUtil.isEmpty((String)mapping.getHostGroupName())) {
                        lun.setHostGroupName(mapping.getHostGroupName());
                        continue;
                    }
                    if (!VerifyUtil.isEmpty((String)mapping.getHostName())) {
                        lun.setHostName(mapping.getHostName());
                        continue;
                    }
                    logger.error((Object)"mapping doesn't have either hostId or hostGroupId. lunId:%s", new Object[]{lun.getLunId()});
                    throw new LegoCheckedException(1073947394L);
                }
                continue;
            }
            String hgName = this.getHostGroupName(deviceSn, lun);
            if (VerifyUtil.isEmpty((String)hgName)) continue;
            lun.setHostGroupName(hgName);
        }
        return luns;
    }

    private String getHostGroupName(String deviceSn, Lun lun) {
        IStorageMappingHandler mappingHandler = this.getHandlerMgr().getMappingHandler();
        List lunMvs = mappingHandler.queryMappingView(deviceSn, XveMOType.LUN, lun.getLunId());
        if (VerifyUtil.isEmpty((Collection)lunMvs)) {
            logger.debug((Object)"MappingView queried through resource is empty.");
            return "";
        }
        ArrayList hgsRealtime = new ArrayList();
        IStorageHostHandler hostHandler = this.getHandlerMgr().getHostHandler();
        if (null == hostHandler) {
            logger.error((Object)("hostHandler is null!devSn: " + deviceSn));
            return "";
        }
        for (Object lunMv : lunMvs) {
            List hgsByMvRealTime = hostHandler.queryHostGroups(deviceSn, XveMOType.MAPPINGVIEW, lunMv.getMappingViewId());
            hgsRealtime.addAll(hgsByMvRealTime);
        }
        StringBuffer hgSb = new StringBuffer();
        for (ArrayHostGroup hg : hgsRealtime) {
            hgSb.append(hg.getName()).append(",");
        }
        String hgName = hgSb.toString();
        if (!"".equals(hgName)) {
            hgName = hgName.substring(0, hgName.length() - 1);
        }
        return hgName;
    }

    public List<Lun> queryLunsByNames(String deviceSn, List<String> lunNames) {
        ArrayList<Lun> luns = new ArrayList<Lun>();
        return luns;
    }

    public boolean isLunMapped(String deviceSN, String resourceId) {
        Lun lun = this.handler.queryStorageLun(deviceSN, resourceId);
        if (null == lun) {
            logger.error((Object)("Querying lun failed.DevSN:" + deviceSN + ",ResId:" + resourceId), 90160758784001L);
            throw new LegoCheckedException(1073948705L);
        }
        return lun.getMapped();
    }

    public Lun createLun(Lun lun) {
        return this.handler.createLun(lun);
    }

    public void deleteLun(String devSN, String ... lunIds) {
        Arrays.stream(lunIds).forEach(lunId -> this.handler.deleteLun(devSN, lunId));
    }

    public Lun getLunById(String devSN, String lunId) {
        try {
            return this.handler.queryStorageLun(devSN, lunId);
        }
        catch (LegoCheckedException le) {
            logger.error((Object)("query Storage lun failed, errorcode:" + le.getErrorCode() + "," + le.getMessage()));
            throw le;
        }
        catch (Exception e) {
            logger.error((Object)("Not found, LUN info=" + devSN + ":" + lunId + ExceptionUtil.getErrorMessage((Throwable)e)));
            throw new LegoCheckedException(1073948705L, (Throwable)e);
        }
    }

    @Override
    protected boolean isResourceMapped(String devSn, String resourceId) {
        return this.isLunMapped(devSn, resourceId);
    }

    public OperationResult mappingLun(String devSn, String resourceId, HostVO hostVo) {
        OperationResult operationResult;
        logger.info((Object)("Enter auto mapping lun to host, devSn=" + devSn + ", resourceId=" + resourceId));
        if (VerifyUtil.isEmpty((String)devSn)) {
            logger.error((Object)"devSn is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)resourceId)) {
            logger.error((Object)"resourceId is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((Object)hostVo)) {
            logger.error((Object)"hostVo is null.");
            throw new LegoCheckedException(1073947393L);
        }
        IStorageMappingHandler mappingHandler = this.getHandlerMgr().getMappingHandler();
        try {
            Lun lun = DrmStorageUtil.getStorageLunById((String)devSn, (String)resourceId);
            if (null == lun) {
                throw new LegoCheckedException(1073947394L);
            }
            if (!this.isMapping(devSn, XveMOType.LUN, resourceId, (List)Arrays.asList(hostVo))) {
                List<ArrayHost> hosts = this.prepareHosts(devSn, hostVo, true);
                ArrayHostGroup hostGroup = this.prepareHostGroup(devSn, hosts);
                MappingView mappingView = this.prepareMappingView(devSn, hostGroup.getHostGroupId(), XveMOType.LUN, resourceId);
                XveLunGroup lunGroup = this.prepareLunGroup(devSn, mappingView);
                mappingHandler.addObjectToLunGroup(devSn, lunGroup.getLunGroupId(), XveMOType.LUN, lun.getLunId());
            }
            operationResult = new OperationResult("ism.drm.mappingluntohost.operation", true, true, new String[]{lun.getName(), hostVo.getName()});
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"Mapping lun to host failed.", (Throwable)e);
            String[] successParameters = new String[]{resourceId, hostVo.getName()};
            operationResult = this.generateOperationResult(e, "ism.drm.mappingluntohost.operation", successParameters);
        }
        logger.info((Object)("Exit auto mapping lun to host, devSn=" + devSn + ", resourceId=" + resourceId));
        return operationResult;
    }

    public OperationResult addLunToLunGroup(String devSn, String resourceId, List<HostVO> hostVoList, String lunGroupId, Map<String, Object> caches) {
        OperationResult operationResult;
        logger.info((Object)("Enter add lun to lunGroup, devSn=" + devSn + ", resourceId=" + resourceId + ", lunGroupId:" + lunGroupId));
        this.checkMappingLunParam(devSn, resourceId, hostVoList);
        if (VerifyUtil.isEmpty((String)lunGroupId)) {
            logger.error((Object)("lunGroupIdObj is null.lunGroupId:" + lunGroupId));
            throw new LegoCheckedException(1073947393L);
        }
        IStorageMappingHandler mappingHandler = this.getHandlerMgr().getMappingHandler();
        try {
            Lun lun = DrmStorageUtil.getStorageLunById((String)devSn, (String)resourceId);
            if (null == lun) {
                logger.error((Object)("query lun is empty!devSn:" + devSn + ", resourceId:" + resourceId));
                throw new LegoCheckedException(1073947394L);
            }
            if (!this.isMapping(devSn, XveMOType.LUN, resourceId, (List)hostVoList)) {
                mappingHandler.addObjectToLunGroup(devSn, lunGroupId, XveMOType.LUN, lun.getLunId());
            }
            operationResult = new OperationResult("ism.drm.mappingluntohost.operation", true, true, new String[]{lun.getName()});
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"add lun to lunGroup failed.", (Throwable)e);
            String[] successParameters = new String[]{resourceId};
            operationResult = this.generateOperationResult(e, "ism.drm.mappingluntohost.operation", successParameters);
        }
        logger.info((Object)("Exit add lun to lunGroup, devSn=" + devSn + ", resourceId=" + resourceId));
        return operationResult;
    }

    private void checkMappingLunParam(String devSn, String resourceId, List<HostVO> hostVOList) {
        if (VerifyUtil.isEmpty((String)devSn)) {
            logger.error((Object)"devSn is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)resourceId)) {
            logger.error((Object)"resourceId is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty(hostVOList)) {
            logger.error((Object)"hostVOList is null.");
            throw new LegoCheckedException(1073947393L);
        }
    }

    public OperationResult removeLunMapping(String devSn, String resourceId, HostVO hostVO) {
        OperationResult operationResult;
        IStorageMappingHandler mappingHandler = this.getHandlerMgr().getMappingHandler();
        String mappingResourceName = "--";
        try {
            MappingView mappingView = mappingHandler.getMappingViewByLunId(devSn, resourceId);
            if (mappingView != null) {
                mappingResourceName = mappingView.getName();
                mappingHandler.removeLunFromMappingView(devSn, mappingView, resourceId);
            }
            operationResult = new OperationResult("ism.drm.unmappinglun.operation", true, true, new String[]{resourceId, VerifyUtil.isEmpty((String)hostVO.getName()) ? mappingResourceName : hostVO.getName()});
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"Remove lun mapping failed.", (Throwable)e, 90160758784001L);
            String[] parameters = new String[]{resourceId, VerifyUtil.isEmpty((String)hostVO.getName()) ? mappingResourceName : hostVO.getName()};
            operationResult = this.generateOperationResult(e, "ism.drm.unmappinglun.operation", parameters);
        }
        return operationResult;
    }

    public OperationResult addLunToLunGroup(String devSn, String resourceId, String lunGroupId) {
        OperationResult operationResult;
        IStorageMappingHandler mappingHandler = this.getHandlerMgr().getMappingHandler();
        logger.info((Object)"Add lun id:%s to lun group id:%s on dev:%s", new Object[]{resourceId, lunGroupId, devSn});
        try {
            mappingHandler.addObjectToLunGroup(devSn, lunGroupId, XveMOType.LUN, resourceId);
            operationResult = new OperationResult("ism.drm.mappingluntohost.operation", true, true, new String[]{resourceId, lunGroupId});
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"Add lun to lun group failed, lun id:%s, lun group id:%s, devSn:%s", new Object[]{resourceId, lunGroupId, devSn});
            String[] successParameters = new String[]{resourceId, lunGroupId};
            operationResult = this.generateOperationResult(e, "ism.drm.mappingluntohost.operation", successParameters);
        }
        return operationResult;
    }

    public OperationResult deleteLunFromLunGroup(String devSn, String resourceId, String lunGroupId) {
        OperationResult operationResult;
        IStorageMappingHandler mappingHandler = this.getHandlerMgr().getMappingHandler();
        logger.info((Object)"Delete lun id:%s from lun group id:%s on dev:%s", new Object[]{resourceId, lunGroupId, devSn});
        try {
            mappingHandler.deleteObjectFromLunGroup(devSn, lunGroupId, XveMOType.LUN, resourceId);
            operationResult = new OperationResult("ism.drm.unmappinglun.operation", true, true, new String[]{resourceId, lunGroupId});
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"Remove lun from lun group failed, lun id:%s, lun group id:%s, devSn:%s", new Object[]{resourceId, lunGroupId, devSn});
            String[] successParameters = new String[]{resourceId, lunGroupId};
            operationResult = this.generateOperationResult(e, "ism.drm.unmappinglun.operation", successParameters);
        }
        return operationResult;
    }

    public OperationResult mappingLun(String devSn, String resourceId, HostGroupVO hgVo) {
        OperationResult operationResult;
        logger.info((Object)("Enter auto mapping lun to host group, devSn=" + devSn + ", resourceId=" + resourceId));
        if (VerifyUtil.isEmpty((String)devSn)) {
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)resourceId)) {
            throw new LegoCheckedException(1073947393L);
        }
        if (null == hgVo) {
            logger.error((Object)"input parameter hgVo is null");
            throw new LegoCheckedException(1073947393L);
        }
        IStorageMappingHandler mappingHandler = this.getHandlerMgr().getMappingHandler();
        try {
            Lun lun = DrmStorageUtil.getStorageLunById((String)devSn, (String)resourceId);
            if (null == lun) {
                throw new LegoCheckedException(1073947394L);
            }
            if (!this.isMapping(devSn, XveMOType.LUN, resourceId, hgVo.getHostVOs())) {
                ArrayList<ArrayHost> hosts = new ArrayList<ArrayHost>();
                for (HostVO hostVo : hgVo.getHostVOs()) {
                    List<ArrayHost> host = this.prepareHosts(devSn, hostVo, true);
                    hosts.addAll(host);
                }
                ArrayHostGroup hostGroup = this.prepareHostGroup(devSn, hosts);
                MappingView mappingView = this.prepareMappingView(devSn, hostGroup.getHostGroupId(), XveMOType.LUN, resourceId);
                XveLunGroup lunGroup = this.prepareLunGroup(devSn, mappingView);
                mappingHandler.addObjectToLunGroup(devSn, lunGroup.getLunGroupId(), XveMOType.LUN, lun.getResourceId());
            }
            operationResult = new OperationResult("ism.drm.mappingluntohost.operation", true, true, new String[]{lun.getName(), hgVo.getName()});
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"Mapping lun to host failed.", (Throwable)e);
            String[] successParameters = new String[]{resourceId, hgVo.getName()};
            operationResult = this.generateOperationResult(e, "ism.drm.mappingluntohost.operation", successParameters);
        }
        logger.info((Object)("Exit auto mapping lun to host group, devSn=" + devSn + ", resourceId=" + resourceId));
        return operationResult;
    }

    public OperationResult removeLunMapping(String deviceSN, String resourceId, HostGroupVO hostGroupVO) {
        OperationResult operationResult;
        IStorageMappingHandler mappingHandler = this.getHandlerMgr().getMappingHandler();
        try {
            Lun lun = DrmStorageUtil.getStorageLunById((String)deviceSN, (String)resourceId);
            if (lun == null) {
                throw new LegoCheckedException(1077936859L);
            }
            MappingView mappingView = mappingHandler.getMappingViewByLunId(deviceSN, resourceId);
            if (null != mappingView) {
                mappingHandler.removeLunFromMappingView(deviceSN, mappingView, lun);
            }
            operationResult = new OperationResult("ism.drm.unmappinglun.operation", true, true, new String[]{lun.getName(), hostGroupVO.getName()});
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"Remove lun mapping failed.", (Throwable)e, 90160758784001L);
            String[] successParameters = new String[]{resourceId, hostGroupVO.getName()};
            operationResult = this.generateOperationResult(e, "ism.drm.unmappinglun.operation", successParameters);
        }
        return operationResult;
    }

    @Override
    public String prepareMapping(String devSn, HostVO hostVo) {
        return super.prepareMapping(devSn, hostVo);
    }

    @Override
    public String prepareMapping(String devSn, HostGroupVO hostGroupVo) {
        return super.prepareMapping(devSn, hostGroupVo);
    }

    public IStorageLunHandler getHandler() {
        return this.handler;
    }

    public void setHandler(IStorageLunHandler handler) {
        this.handler = handler;
    }

    private final class QueryLunTask
    implements Callable<Lun> {
        private String lunId = null;
        private String devSn = null;

        public QueryLunTask(String devSn, String lunId) {
            this.devSn = devSn;
            this.lunId = lunId;
        }

        @Override
        public Lun call() {
            try {
                logger.debug((Object)"start to query lun. devSn:[%s], lunId:[%s]", new Object[]{this.devSn, this.lunId});
                return HvsStorageLunManager.this.handler.queryStorageLun(this.devSn, this.lunId);
            }
            catch (Exception e) {
                logger.error((Object)("Not found, LUN info=" + this.devSn + ":" + this.lunId + ExceptionUtil.getErrorMessage((Throwable)e)));
                throw new LegoCheckedException(1073948705L, (Throwable)e);
            }
        }
    }
}

