/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.manager;

import com.huawei.ism.array.sdk.model.HvsProtectionGroup;
import com.huawei.ism.array.sdk.model.HvsUnit;
import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.HvsRestConnection;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnectionManager;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.storage.handler.IStorageLunHandler;
import com.huawei.ism.drm.storage.hvs.discovery.util.HVSRestTransitionExtend;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageProtectGroupManager;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class HvsStorageProtectGroupManager
implements IStorageProtectGroupManager {
    private static final Log logger = LogFactory.getInstance(HvsStorageProtectGroupManager.class);
    private static final String PROTECT_GROUP_BATCH_URL = "/rest/${deviceId}/protectgroup/associate/batch";
    private static final String PROTECT_GROUP_UPDATE_URI = "/rest/${deviceId}/protectgroup/";
    private static final String PROTECT_GROUP_QUERY_URI = "/api/v2/protectgroup";
    private IStorageLunHandler lunHandler;

    public void addLuns(List<Lun> luns, String groupId) {
        String devSn = this.checkAndGetDevSn(luns, groupId);
        RestConnection conn = RestConnectionManager.getInstance().getConnection(devSn);
        if (VerifyUtil.isEmpty((Object)conn)) {
            logger.error((Object)"Storage Device(sn:%s) is offline.", new Object[]{devSn});
            throw new LegoCheckedException(104401L);
        }
        List<Map<String, String>> paramList = this.getParamList(luns, groupId, devSn);
        try {
            conn.postForList(PROTECT_GROUP_BATCH_URL, paramList);
        }
        catch (LegoCheckedException e) {
            if (e.getErrorCode() == 1086545669L) {
                logger.info((Object)"Lun already in protection group.");
            }
            logger.error((Object)"Add lun to protection group with error:%s", e.getErrorCode());
            throw e;
        }
        logger.info((Object)"Batch add lun to protect group success.");
    }

    public void removeLuns(List<Lun> luns, String groupId) {
        String devSn = this.checkAndGetDevSn(luns, groupId);
        RestConnection conn = RestConnectionManager.getInstance().getConnection(devSn);
        if (VerifyUtil.isEmpty((Object)conn)) {
            logger.error((Object)"Storage Device(sn:%s) is offline.", new Object[]{devSn});
            throw new LegoCheckedException(104401L);
        }
        List<Map<String, String>> paramList = this.getParamList(luns, groupId, devSn);
        conn.deleteForList(PROTECT_GROUP_BATCH_URL, paramList);
        this.checkRemoveLunSuccess(luns, groupId, devSn);
        logger.info((Object)"Batch remove lun to protect group success.");
    }

    private void checkRemoveLunSuccess(List<Lun> luns, String groupId, String devSn) {
        List currentLuns = this.lunHandler.queryLuns(devSn, XveMOType.PROTECT_GROUP, groupId);
        Set removeLunIds = luns.stream().map(Lun::getLunId).collect(Collectors.toSet());
        if (currentLuns.stream().map(Lun::getLunId).anyMatch(removeLunIds::contains)) {
            logger.error((Object)"Luns %s remove from protect group %s failed", new Object[]{removeLunIds, groupId});
            throw new LegoCheckedException(0x300001L);
        }
    }

    public HvsProtectionGroup associatedQueryProtectionGroup(String devSn, int resourceType, String resourceId) {
        if (VerifyUtil.isEmpty((String)devSn) || VerifyUtil.isEmpty((Object)resourceType) || VerifyUtil.isEmpty((String)resourceId)) {
            logger.error((Object)"Query protect group fail, invalid input param.");
            throw new LegoCheckedException(1073947393L);
        }
        RestConnection conn = RestConnectionManager.getInstance().getConnection(devSn);
        if (VerifyUtil.isEmpty((Object)conn)) {
            logger.error((Object)"Storage Device(sn:%s) is offline.", new Object[]{devSn});
            throw new LegoCheckedException(104401L);
        }
        String sb = "/rest/${deviceId}/protectgroup/associate?ASSOCIATEOBJTYPE=" + resourceType + "&ASSOCIATEOBJID=" + resourceId;
        Map responseMap = conn.get(sb, null);
        return HVSRestTransitionExtend.transitionHvsProtectGroup(responseMap, devSn);
    }

    private String checkAndGetDevSn(List<Lun> luns, String groupId) {
        if (VerifyUtil.isEmpty(luns) || VerifyUtil.isEmpty((String)groupId)) {
            logger.error((Object)"Batch operation lun to protect group fail, invalid input param.");
            throw new LegoCheckedException(1073947393L);
        }
        List devSns = luns.stream().map(StorageResource::getDevSn).distinct().collect(Collectors.toList());
        if (devSns.size() != 1) {
            logger.error((Object)"Lun is not from same device.");
            throw new LegoCheckedException(1073947393L);
        }
        return (String)devSns.get(0);
    }

    private List<Map<String, String>> getParamList(List<Lun> luns, String groupId, String devSn) {
        List lunIds = luns.stream().map(Lun::getLunId).collect(Collectors.toList());
        logger.info((Object)"Batch operation lun to protect group, srcIds=%s, srcDevSn:%s", new Object[]{String.join((CharSequence)",", lunIds), devSn});
        ArrayList<Map<String, String>> paramList = new ArrayList<Map<String, String>>();
        for (String lunId : lunIds) {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("ID", groupId);
            paramMap.put("ASSOCIATEOBJTYPE", "11");
            paramMap.put("ASSOCIATEOBJID", lunId);
            paramList.add(paramMap);
        }
        return paramList;
    }

    public Optional<HvsProtectionGroup> queryProtectionGroup(HvsProtectionGroup group) {
        if (VerifyUtil.isEmpty((String)group.getDevSn()) || VerifyUtil.isEmpty((String)group.getProtectGroupId())) {
            logger.warn((Object)"ProtectGroup info is empty, no info to query");
            return Optional.empty();
        }
        RestConnectionManager manager = RestConnectionManager.getInstance();
        RestConnection conn = Optional.ofNullable(manager.getConnection(group.getDevSn())).orElseThrow(() -> new LegoCheckedException(1073947649L));
        HashMap<String, String> params = null;
        if (!VerifyUtil.isEmpty((String)group.getVstoreId())) {
            params = new HashMap<String, String>();
            params.put("vstoreId", group.getVstoreId());
        }
        Map responseMap = conn.get(PROTECT_GROUP_UPDATE_URI + group.getProtectGroupId(), params);
        HvsProtectionGroup protectionGroup = HVSRestTransitionExtend.transitionHvsProtectGroup(responseMap, group.getDevSn());
        return Optional.of(protectionGroup);
    }

    public List<HvsProtectionGroup> batchQueryProtectionGroup(String devSn, String criteria) {
        if (VerifyUtil.isEmpty((String)devSn) || VerifyUtil.isEmpty((String)criteria)) {
            logger.error((Object)"Param list is empty, no info to query");
            throw new LegoCheckedException(1073947393L);
        }
        HvsRestConnection conn = (HvsRestConnection)RestConnectionManager.getInstance().getConnection(devSn);
        if (VerifyUtil.isEmpty((Object)conn)) {
            logger.error((Object)"Storage Device(sn:%s) is offline.", new Object[]{devSn});
            throw new LegoCheckedException(104401L);
        }
        List results = conn.getBatch(PROTECT_GROUP_QUERY_URI + criteria, null, false, true, true);
        return results.stream().map(result -> HVSRestTransitionExtend.transitionHvsProtectGroup(result, devSn)).collect(Collectors.toList());
    }

    public void deleteProtectGroup(String devSn, String groupId) {
        if (VerifyUtil.isEmpty((String)devSn) || VerifyUtil.isEmpty((String)groupId)) {
            logger.warn((Object)"ProtectGroup info is empty, no need to delete");
            return;
        }
        RestConnectionManager manager = RestConnectionManager.getInstance();
        RestConnection conn = Optional.ofNullable(manager.getConnection(devSn)).orElseThrow(() -> new LegoCheckedException(1073947649L));
        conn.delete(PROTECT_GROUP_UPDATE_URI + groupId, null);
    }

    public HvsProtectionGroup createProtectGroup(HvsProtectionGroup protectionGroup) {
        if (VerifyUtil.isAnyEmpty((Object[])new Object[]{protectionGroup, protectionGroup.getDevSn(), protectionGroup.getProtectGroupName()})) {
            logger.error((Object)"Delete protect group fail, invalid input param.");
            throw new LegoCheckedException(1073947393L);
        }
        RestConnection conn = RestConnectionManager.getInstance().getConnection(protectionGroup.getDevSn());
        if (VerifyUtil.isEmpty((Object)conn)) {
            logger.error((Object)"Storage Device(sn:%s) is offline.", new Object[]{protectionGroup.getDevSn()});
            throw new LegoCheckedException(104401L);
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("protectGroupName", protectionGroup.getProtectGroupName());
        if (!VerifyUtil.isEmpty((String)protectionGroup.getLunGroupId())) {
            param.put("lunGroupId", protectionGroup.getLunGroupId());
        }
        if (!VerifyUtil.isEmpty((String)protectionGroup.getVstoreId())) {
            param.put("vstoreId", protectionGroup.getVstoreId());
        }
        try {
            Map responseMap = conn.postByPipe(PROTECT_GROUP_QUERY_URI, param, true);
            return HVSRestTransitionExtend.transitionHvsProtectGroup(responseMap, protectionGroup.getDevSn());
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"Create protect group with error:%s, errorMsg:%s", new Object[]{e.getErrorCode(), e.getMessage()});
            throw e;
        }
    }

    public void deleteProtectGroup(HvsProtectionGroup pg) {
        if (VerifyUtil.isEmpty((String)pg.getDevSn()) || VerifyUtil.isEmpty((String)pg.getProtectGroupId())) {
            logger.warn((Object)"ProtectGroup info is empty, no need to delete");
            return;
        }
        this.deleteProtectGroup(pg.getDevSn(), pg.getProtectGroupId());
    }

    public String getStorageType() {
        return HvsUnit.class.getName();
    }

    public void setLunHandler(IStorageLunHandler lunHandler) {
        this.lunHandler = lunHandler;
    }
}

