/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.manager;

import com.huawei.ism.array.sdk.model.HvsUnit;
import com.huawei.ism.cbb.base.sdk.constant.DmEnumDefine;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnectionManager;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.storage.handler.IStorageReplicationHandler;
import com.huawei.ism.drm.storage.hvs.discovery.util.HVSRestTransitionExtend;
import com.huawei.ism.drm.storage.manager.proxy.StoragePortLinksManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStoragePortLinksManager;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageReplicationManager;
import com.huawei.ism.drm.storage.replication.service.impl.AbstractReplicationService;
import com.huawei.ism.drm.storage.sdk.model.RemoteLinkDevice;
import com.huawei.ism.drm.storage.sdk.model.ReplicationGroup;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelation;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.ism.drm.storage.service.fusion.IStorageReplicationFusionService;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class HvsStorageReplicationManagerAdapter
extends AbstractReplicationService
implements IStorageReplicationManager,
IStorageReplicationFusionService {
    private static final Log logger = LogFactory.getInstance(HvsStorageReplicationManagerAdapter.class);
    private static final String REPLICATION_PAIR_URI = "/rest/${deviceID}/REPLICATIONPAIR/";
    private static final String REPLICATION_GROUP_URI = "/rest/${deviceID}/CONSISTENTGROUP/";
    private final RestConnectionManager connMgr = RestConnectionManager.getInstance();
    private IStorageReplicationHandler replicationHandler;

    public String getStorageType() {
        return HvsUnit.class.getName();
    }

    public List<ReplicationTargetLun> querySyncStatus(String sourceArrayId, String targetArrayId, String replicationId, boolean isConsistentGroup) {
        HashMap paramMap = new HashMap();
        ReplicationRelation relation = this.getReplication(sourceArrayId, targetArrayId, replicationId, isConsistentGroup);
        if (null == relation) {
            logger.error((Object)("Replication does not exist. SrcDevId:" + sourceArrayId + ",TgtDevId:" + targetArrayId + ",replicationId:" + replicationId + ",isConsistentGroup:" + isConsistentGroup), 90160758784001L);
            if (isConsistentGroup) {
                throw new LegoCheckedException(1073948767L, new String[]{replicationId});
            }
            throw new LegoCheckedException(1073948677L, new String[]{replicationId});
        }
        ArrayList<ReplicationTargetLun> tgtLunList = new ArrayList<ReplicationTargetLun>();
        RestConnection conn = this.connMgr.getConnection(relation.getDevSn());
        if (relation instanceof ReplicationGroup) {
            String url = "/rest/${deviceID}/replicationpair?filter=CGID::" + relation.getReplicationId() + "&range=[0-65536]";
            logger.debug((Object)"querySyncStatus url = %s, params = %s", new Object[]{url, paramMap});
            List resultMapList = conn.getBatch(url, paramMap);
            if (!VerifyUtil.isEmpty((Collection)resultMapList)) {
                for (Map repResult : resultMapList) {
                    ReplicationTargetLun tgtLun = HVSRestTransitionExtend.transitionReplicationTargetLun(repResult, relation.getDevSn());
                    tgtLunList.add(tgtLun);
                }
            }
        } else {
            String url = "/rest/${deviceID}/replicationpair/" + replicationId;
            logger.debug((Object)"querySyncStatus url = %s, params = %s", new Object[]{url, paramMap});
            Map repResult = conn.get(url, paramMap);
            ReplicationTargetLun tgtLun = HVSRestTransitionExtend.transitionReplicationTargetLun(repResult, relation.getDevSn());
            tgtLunList.add(tgtLun);
        }
        this.updateSyncInfo(tgtLunList);
        return tgtLunList;
    }

    public List<String> supportedDeviceList() {
        return null;
    }

    public OperationResult processCommand(String deviceId, String operationName, String url, JSONObject bodyJson) {
        url = "/rest/${deviceID}/" + url.replaceFirst("^/", "");
        return super.processCommand(deviceId, operationName, url, bodyJson);
    }

    public List<ReplicationPair> queryReplications(String deviceSn, String resourceId, Integer resourceType) {
        logger.debug((Object)("sn=" + deviceSn + ", resourceId=" + resourceId));
        List<Object> replications = new ArrayList<ReplicationPair>();
        Integer type = this.getXveMoTypeFromResourceType(resourceType);
        if (type != null) {
            try {
                logger.debug((Object)"queryReplications deviceSn=%s, resourceId=%s ,resourceType=%s", new Object[]{deviceSn, resourceId, type});
                replications = this.replicationHandler.queryReplicationByAssociation(deviceSn, type.intValue(), resourceId);
            }
            catch (LegoCheckedException ex) {
                logger.error((Object)ex);
                String code = "50331651";
                if (code.equals(Long.toString(ex.getErrorCode()))) {
                    logger.error((Object)"Current device may not support FileSystem.");
                }
                throw ex;
            }
            catch (Exception e) {
                logger.error((Object)("queryReplications error." + ExceptionUtil.getErrorMessage((Throwable)e)));
            }
        } else {
            try {
                logger.debug((Object)"queryReplications resourceType is null deviceSn=%s, resourceId=%s", new Object[]{deviceSn, resourceId});
                replications = this.replicationHandler.queryReplicationByAssociation(deviceSn, XveMOType.LUN.getValue(), resourceId);
            }
            catch (Exception e) {
                logger.error((Object)("queryReplications error." + ExceptionUtil.getErrorMessage((Throwable)e)));
            }
            if (VerifyUtil.isEmpty(replications)) {
                try {
                    replications = this.replicationHandler.queryReplicationByAssociation(deviceSn, XveMOType.FILESYSTEM.getValue(), resourceId);
                }
                catch (LegoCheckedException ex) {
                    logger.error((Object)ex);
                    String code = "50331651";
                    if (code.equals(Long.toString(ex.getErrorCode()))) {
                        logger.error((Object)"Current device may not support FileSystem.");
                    }
                    throw ex;
                }
            }
        }
        return replications;
    }

    private Integer getXveMoTypeFromResourceType(Integer resourceType) {
        if (resourceType != null && resourceType.intValue() == DrmEnumDefine.ResourceTypeE.NAS.getValue()) {
            return XveMOType.FILESYSTEM.getValue();
        }
        if (resourceType != null && resourceType.intValue() == DrmEnumDefine.ResourceTypeE.LUN.getValue()) {
            return XveMOType.LUN.getValue();
        }
        return null;
    }

    public void changeRate(String sn, String id, boolean isCg, DmEnumDefine.SpeedLevelE rate) {
        logger.info((Object)("Enter change repliations rate, sn=" + sn + ", id=" + id + ", isCg=" + isCg + ", rate=" + rate));
        VerifyUtil.checkStrs((String[])new String[]{sn, id});
        DmEnumDefine.SpeedLevelE sl = null == rate ? DmEnumDefine.SpeedLevelE.SPEED_LEVEL_MIDDLE : rate;
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("SPEED", sl.getValue());
        this.getReplicationHandler().modify(sn, id, isCg, params);
        logger.info((Object)"Exit change repliations rate.");
    }

    public void modify(String sn, String id, boolean isCg, Map<String, Object> params) {
        this.getReplicationHandler().modify(sn, id, isCg, params);
    }

    public ReplicationRelation queryReplicationRelation(String sn, String id, boolean isCG) {
        return this.replicationHandler.queryReplication(sn, id, isCG);
    }

    public List<ReplicationPair> queryReplications(String deviceSn, Collection<String> resources, Integer resourceType) {
        RestConnection conn = RestConnectionManager.getInstance().getConnection(deviceSn);
        if (null == conn) {
            throw new LegoCheckedException(104401L);
        }
        if (VerifyUtil.isEmpty((String)deviceSn)) {
            return new ArrayList<ReplicationPair>();
        }
        List list = ExecutionService.map(resources, resoureId -> this.queryReplications(deviceSn, (String)resoureId, resourceType));
        ArrayList<ReplicationPair> pairs = new ArrayList<ReplicationPair>();
        list.stream().filter(pairList -> !VerifyUtil.isEmpty((Collection)pairList)).forEach(pairList -> pairs.addAll((Collection<ReplicationPair>)pairList));
        this.setRepTargettLuns(deviceSn, pairs);
        return pairs;
    }

    public IStorageReplicationHandler getReplicationHandler() {
        return this.replicationHandler;
    }

    public void setReplicationHandler(IStorageReplicationHandler replicationHandler) {
        this.replicationHandler = replicationHandler;
    }

    public void dispatchCommand(String deviceId, String url, Object data) {
        RestConnectionManager.getInstance().getConnection(deviceId).putForObject(url, data);
    }

    public List<ReplicationPair> getAllReplicationPairs(String deviceSN, String vstoreId) {
        RestConnection conn = RestConnectionManager.getInstance().getConnection(deviceSN);
        if (null == conn) {
            throw new LegoCheckedException(104401L);
        }
        if (VerifyUtil.isEmpty((String)deviceSN)) {
            return new ArrayList<ReplicationPair>();
        }
        String url = "/rest/${deviceID}/REPLICATIONPAIR?range=[0-65536]";
        if (!VerifyUtil.isEmpty((String)vstoreId)) {
            url = url + "&vstoreId=" + vstoreId;
        }
        logger.debug((Object)"Get replicationPairs: url = %s", new Object[]{url});
        List resultMapList = conn.getBatch(url, null);
        ArrayList<ReplicationPair> replicationPairList = new ArrayList<ReplicationPair>();
        for (Map record : resultMapList) {
            try {
                ReplicationPair replicationPair = HVSRestTransitionExtend.transitionReplicationPair(record, deviceSN);
                replicationPairList.add(replicationPair);
            }
            catch (Exception e) {
                logger.warn((Object)("Storage[" + deviceSN + "] transition to replication pair failed"), 90160777658373L);
            }
        }
        this.setRepTargettLuns(deviceSN, replicationPairList);
        return replicationPairList;
    }

    private void checkAndBuildReplicationPairDRRing(List<ReplicationPair> relations, List<ReplicationGroup> replicationGroups) {
        if (VerifyUtil.isEmpty(relations) || VerifyUtil.isEmpty(replicationGroups)) {
            return;
        }
        HashMap<String, String> replicationGroupMap = new HashMap<String, String>();
        for (ReplicationGroup replicationGroup : replicationGroups) {
            replicationGroupMap.put(replicationGroup.getReplicationId(), replicationGroup.getDrRingId());
        }
        for (ReplicationPair replicationPair : relations) {
            if (!VerifyUtil.isEmpty((String)replicationPair.getDrRingId())) continue;
            replicationPair.setDrRingId((String)replicationGroupMap.get(replicationPair.getConsistentGroupId()));
        }
    }

    public List<ReplicationGroup> getAllReplicationGroups(String deviceSN) {
        RestConnection conn = RestConnectionManager.getInstance().getConnection(deviceSN);
        if (conn == null) {
            throw new LegoCheckedException(104401L);
        }
        if (VerifyUtil.isEmpty((String)deviceSN)) {
            return new ArrayList<ReplicationGroup>();
        }
        String url = "/rest/${deviceID}/CONSISTENTGROUP?range=[0-65536]";
        logger.debug((Object)"Get replicationGroups: url = %s", new Object[]{url});
        List resultMapList = conn.getBatch(url, null);
        ArrayList<ReplicationGroup> replicationGroupList = new ArrayList<ReplicationGroup>();
        for (Map record : resultMapList) {
            try {
                ReplicationGroup replication = HVSRestTransitionExtend.transitionReplicationGroup(record, deviceSN);
                replicationGroupList.add(replication);
            }
            catch (Exception e) {
                logger.warn((Object)("Storage[" + deviceSN + "] transition to replication group failed"), 90160777658373L);
            }
        }
        return replicationGroupList;
    }

    private void setRepTargettLuns(String deviceSn, List<ReplicationPair> pairs) {
        boolean isVasa = LegoConfig.getInstance().getBoolean("VASA", Boolean.valueOf(false));
        if (!isVasa) {
            List<ReplicationGroup> replicationGroups = this.getAllReplicationGroups(deviceSn);
            this.checkAndBuildReplicationPairDRRing(pairs, replicationGroups);
        }
        for (ReplicationPair pair : pairs) {
            if (VerifyUtil.isEmpty((Object)pair) || VerifyUtil.isEmpty((Collection)pair.getChildMos())) continue;
            ReplicationTargetLun tgtLuns = (ReplicationTargetLun)pair.getChildMos().iterator().next();
            pair.setRepTgtLuns(Arrays.asList(tgtLuns));
        }
    }

    public ReplicationGroup getReplicationGroup(String devSN, String groupId) {
        if (null == devSN || null == groupId) {
            logger.error((Object)"input param is null.");
            return null;
        }
        return (ReplicationGroup)this.replicationHandler.queryReplication(devSN, groupId, true);
    }

    public List<ReplicationPair> queryReplicationPairByCgId(String devSN, String cgId) {
        logger.debug((Object)"query replication pair by CG start. devSn=%s, cgId=%s", new Object[]{devSN, cgId});
        RestConnection connection = RestConnectionManager.getInstance().getConnection(devSN);
        List resultMapList = connection.getBatch("/rest/${deviceID}/REPLICATIONPAIR?filter=CGID::" + cgId, null);
        ArrayList<ReplicationPair> replicationPairList = new ArrayList<ReplicationPair>();
        for (Map record : resultMapList) {
            try {
                ReplicationPair replicationPair = HVSRestTransitionExtend.transitionReplicationPair(record, devSN);
                replicationPairList.add(replicationPair);
            }
            catch (LegoCheckedException e) {
                logger.warn((Object)("Storage[" + devSN + "] transition to replication pair failed"), 90160777658373L);
                return null;
            }
        }
        for (ReplicationPair pair : replicationPairList) {
            if (VerifyUtil.isEmpty((Object)pair) || VerifyUtil.isEmpty((Collection)pair.getChildMos())) continue;
            ReplicationTargetLun tgtLuns = (ReplicationTargetLun)pair.getChildMos().iterator().next();
            pair.setRepTgtLuns(Arrays.asList(tgtLuns));
        }
        return replicationPairList;
    }

    public ReplicationPair getReplicationPair(String devSN, String pairId) {
        if (VerifyUtil.isEmpty((String)devSN)) {
            return null;
        }
        RestConnection conn = RestConnectionManager.getInstance().getConnection(devSN);
        if (conn == null) {
            throw new LegoCheckedException(104401L);
        }
        String url = REPLICATION_PAIR_URI + pairId;
        List resultMapList = conn.getBatch(url, null);
        ArrayList<ReplicationPair> replicationPairList = new ArrayList<ReplicationPair>();
        for (Map record : resultMapList) {
            try {
                ReplicationPair replicationPair = HVSRestTransitionExtend.transitionReplicationPair(record, devSN);
                replicationPairList.add(replicationPair);
            }
            catch (LegoCheckedException e) {
                logger.error((Object)"Storage[%s] transition to replication pair failed", new Object[]{devSN, 90160777658373L});
            }
        }
        this.setRepTargettLuns(devSN, replicationPairList);
        return (ReplicationPair)replicationPairList.get(0);
    }

    public ReplicationPair createReplicationPair(ReplicationPair pair) {
        String srcDevSn = pair.getSrcDevSN();
        String targetDevSn = pair.getTgtDevSN();
        if (VerifyUtil.isEmpty((Object)pair) || StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{srcDevSn, targetDevSn})) {
            logger.error((Object)"Create replication pair fail, invalid input param.");
            throw new LegoCheckedException(1073947393L);
        }
        RestConnection conn = RestConnectionManager.getInstance().getConnection(srcDevSn);
        if (VerifyUtil.isEmpty((Object)conn)) {
            logger.error((Object)"Storage Device(sn:%s) is offline.", new Object[]{srcDevSn});
            throw new LegoCheckedException(104401L);
        }
        logger.info((Object)"Create replication pair start. srcLunName=%s, srcDevSn:%s", new Object[]{pair.getSrcLunName(), srcDevSn});
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("LOCALRESID", pair.getSrcLunId());
        params.put("LOCALRESTYPE", pair.getLocalResType().toString());
        params.put("REMOTEDEVICEID", this.getRemoteDeviceId(srcDevSn, targetDevSn));
        params.put("REMOTERESID", pair.getTgtLunId());
        params.put("REPLICATIONMODEL", pair.getReplicationMode().toString());
        params.put("SPEED", VerifyUtil.isEmpty((String)pair.getReplicationRate()) ? String.valueOf(DmEnumDefine.SpeedLevelE.SPEED_LEVEL_MIDDLE.getValue()) : pair.getReplicationRate());
        try {
            Map resultMap = conn.post(REPLICATION_PAIR_URI, params);
            ReplicationPair replicationPair = HVSRestTransitionExtend.transitionReplicationPair(resultMap, srcDevSn);
            logger.info((Object)"Create replication pair success. pairId=%s", new Object[]{pair.getId()});
            return replicationPair;
        }
        catch (LegoCheckedException e) {
            if (e.getErrorCode() == 1073749234L) {
                return this.getExistPair(pair, e);
            }
            logger.error((Object)"Create replication pair failed.");
            throw e;
        }
    }

    private ReplicationPair getExistPair(ReplicationPair pair, LegoCheckedException ex) {
        List<ReplicationPair> pairs = this.queryReplications(pair.getSrcDevSN(), pair.getSrcLunId(), pair.getLocalResType());
        if (VerifyUtil.isEmpty(pairs)) {
            throw new LegoCheckedException(2117645L);
        }
        ReplicationPair replicationPair = pairs.get(0);
        if (replicationPair.getChildMos().isEmpty()) {
            throw new LegoCheckedException(2117645L);
        }
        ManagedObject tgTreplicationPair = (ManagedObject)replicationPair.getChildMos().iterator().next();
        if (tgTreplicationPair instanceof ReplicationTargetLun) {
            ReplicationTargetLun targetLun = (ReplicationTargetLun)tgTreplicationPair;
            if (this.checkDevSn(pair.getSrcDevSN(), replicationPair.getSrcDevSN(), pair.getTgtDevSN(), targetLun.getTgtDevSN()) && this.checkLunId(pair.getSrcLunId(), replicationPair.getSrcLunId(), pair.getTgtLunId(), targetLun.getTgtLunId()) && pair.getReplicationMode().equals(replicationPair.getReplicationMode())) {
                return replicationPair;
            }
        }
        throw ex;
    }

    private boolean checkDevSn(String srcDevSn, String existPairSrcDevSn, String tgtDevSn, String existPairTgtDevSn) {
        return srcDevSn.equals(existPairSrcDevSn) && tgtDevSn.equals(existPairTgtDevSn);
    }

    private boolean checkLunId(String srcId, String existPairSrcId, String tgtId, String existPairTgtId) {
        return srcId.equals(existPairSrcId) && tgtId.equals(existPairTgtId);
    }

    public void deleteReplicationGroup(ReplicationGroup group) {
        if (VerifyUtil.isEmpty((Object)group) || VerifyUtil.isEmpty((String)group.getReplicationId()) || VerifyUtil.isEmpty((String)group.getSrcDevSN())) {
            logger.warn((Object)"Group info is empty, no group to delete.");
            return;
        }
        String srcDevSN = group.getSrcDevSN();
        RestConnection conn = Optional.ofNullable(this.connMgr.getConnection(srcDevSN)).orElseThrow(() -> new LegoCheckedException(1073947649L));
        conn.delete(REPLICATION_GROUP_URI + group.getReplicationId(), null);
    }

    public void deleteReplicationPair(ReplicationPair pair) {
        String srcDevSn = pair.getSrcDevSN();
        String targetDevSn = pair.getTgtDevSN();
        String pairId = pair.getReplicationId();
        if (VerifyUtil.isEmpty((Object)pair) || StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{srcDevSn, targetDevSn, pairId})) {
            logger.error((Object)"DeleteReplicationPair failed for the invalid input params.");
            throw new LegoCheckedException(1073947393L);
        }
        if (this.deleteReplicationPair(srcDevSn, pairId)) {
            return;
        }
        logger.info((Object)"Retry deleteReplicationPair on peer site ...");
        if (!this.deleteReplicationPair(targetDevSn, pairId)) {
            logger.error((Object)"DeleteReplicationPair failed on both sides. srcDevSn:%s, targetDevSn: %s, pair id:%s.", new Object[]{srcDevSn, targetDevSn, pairId});
            throw new LegoCheckedException(1073947800L, new String[]{pairId});
        }
    }

    private boolean deleteReplicationPair(String devSn, String pairId) {
        RestConnection conn = RestConnectionManager.getInstance().getConnection(devSn);
        if (VerifyUtil.isEmpty((Object)conn)) {
            logger.error((Object)"Storage Device(sn:%s) is offline.", new Object[]{devSn});
            return false;
        }
        try {
            conn.delete(REPLICATION_PAIR_URI + pairId, null);
        }
        catch (LegoCheckedException e) {
            if (e.getErrorCode() == 1077937923L) {
                logger.error((Object)"The specified remote replication(%s) is unavailable on device(%s).", new Object[]{pairId, devSn});
                return true;
            }
            logger.error((Object)"Delete replication pair failed, error msg: %s, devSn:%s, pair id:%s.", new Object[]{e.getMessage(), devSn, pairId});
            return false;
        }
        logger.info((Object)"Delete replication pair(id: %s) on device(sn: %s) successfully.", new Object[]{pairId, devSn});
        return true;
    }

    private String getRemoteDeviceId(String srcDevSn, String targetDevSn) {
        IStoragePortLinksManager mgr = StoragePortLinksManagerProxy.getInstance().getStoragePortLinksMgrByDevId(srcDevSn);
        List remoteDevices = mgr.getStorageRemoteDeviceByRemoteSn(srcDevSn, targetDevSn);
        if (VerifyUtil.isEmpty((Collection)remoteDevices)) {
            logger.error((Object)"Query remote device id error, srcDevSn:%s, targetDevSn: %s", new Object[]{srcDevSn, targetDevSn});
            throw new LegoCheckedException(1073948474L);
        }
        return ((RemoteLinkDevice)remoteDevices.stream().findFirst().get()).getDeviceId();
    }

    public ReplicationGroup addReplicationPair(ReplicationGroup group, List<ReplicationPair> pairList) {
        this.checkParams(group, pairList);
        RestConnection conn = RestConnectionManager.getInstance().getConnection(group.getSrcDevSN());
        if (VerifyUtil.isEmpty((Object)conn)) {
            logger.error((Object)"Storage Device(sn:%s) is offline.", new Object[]{group.getSrcDevSN()});
            throw new LegoCheckedException(104401L);
        }
        List<Map<String, String>> paramList = this.getParamList(pairList, group);
        conn.putForList("/rest/${deviceId}/ADD_MIRROR/batch", paramList);
        return group;
    }

    public void removeReplicationPair(ReplicationGroup group, List<ReplicationPair> pairList) {
        this.checkParams(group, pairList);
        RestConnection conn = RestConnectionManager.getInstance().getConnection(group.getSrcDevSN());
        if (VerifyUtil.isEmpty((Object)conn)) {
            logger.error((Object)"Storage Device(sn:%s) is offline.", new Object[]{group.getSrcDevSN()});
            throw new LegoCheckedException(104401L);
        }
        List<Map<String, String>> paramList = this.getParamList(pairList, group);
        conn.putForList("/rest/${deviceId}/DEL_MIRROR/batch", paramList);
        this.checkRemovePairSuccess(group, pairList);
    }

    private void checkRemovePairSuccess(ReplicationGroup group, List<ReplicationPair> pairList) {
        List<ReplicationPair> currentPairs = this.queryReplicationPairByCgId(group.getSrcDevSN(), group.getReplicationId());
        Set removePairIds = pairList.stream().map(ReplicationRelation::getReplicationId).collect(Collectors.toSet());
        if (currentPairs.stream().map(ReplicationRelation::getReplicationId).anyMatch(removePairIds::contains)) {
            logger.error((Object)"Pairs %s remove from group %s failed", new Object[]{removePairIds, group.getReplicationId()});
            throw new LegoCheckedException(0x300001L);
        }
    }

    public ReplicationRelation queryRealtimeReplication(String deviceSn, String replicationId, boolean isGroup) {
        return this.replicationHandler.queryReplication(deviceSn, replicationId, isGroup);
    }

    private void checkParams(ReplicationGroup group, List<ReplicationPair> pairList) {
        if (VerifyUtil.isEmpty((Object)group) || VerifyUtil.isEmpty(pairList)) {
            logger.error((Object)"Batch remove pair to replication group fail, invalid input param.");
            throw new LegoCheckedException(1073947393L);
        }
        String replicationId = group.getReplicationId();
        String devSn = group.getSrcDevSN();
        VerifyUtil.checkStrs((String[])new String[]{replicationId, devSn});
    }

    private List<Map<String, String>> getParamList(List<ReplicationPair> pairList, ReplicationGroup group) {
        List replicationIds = pairList.stream().map(ReplicationRelation::getReplicationId).collect(Collectors.toList());
        logger.info((Object)"Batch operation pair to replication group, srcIds=%s, srcDevSn:%s", new Object[]{String.join((CharSequence)",", replicationIds), group.getDevSn()});
        ArrayList<Map<String, String>> paramList = new ArrayList<Map<String, String>>();
        for (String replicationId : replicationIds) {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("ID", group.getReplicationId());
            JSONArray array = new JSONArray();
            array.add((Object)replicationId);
            paramMap.put("RMLIST", array.toString());
            paramList.add(paramMap);
        }
        return paramList;
    }

    public ReplicationGroup createReplicationGroup(ReplicationGroup group) {
        if (VerifyUtil.isEmpty((Object)group) || VerifyUtil.isEmpty((String)group.getReplicationName())) {
            logger.error((Object)"Create replication group fail, invalid input param.");
            throw new LegoCheckedException(1073947393L);
        }
        RestConnection conn = RestConnectionManager.getInstance().getConnection(group.getSrcDevSN());
        if (VerifyUtil.isEmpty((Object)conn)) {
            logger.error((Object)"Storage Device(sn:%s) is offline.", new Object[]{group.getSrcDevSN()});
            throw new LegoCheckedException(104401L);
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("NAME", group.getReplicationName());
        paramMap.put("LOCALRESTYPE", group.getLocalResType().toString());
        paramMap.put("REPLICATIONMODEL", group.getReplicationMode().toString());
        paramMap.put("SPEED", group.getSpeedLevel().toString());
        paramMap.put("localpgId", group.getLocalPgId());
        paramMap.put("rmtpgId", group.getRemotePgId());
        paramMap.put("remoteArrayID", this.getRemoteDeviceId(group.getSrcDevSN(), group.getTgtDevSN()));
        if (!VerifyUtil.isEmpty((String)group.getVstoreId()) && !VerifyUtil.isEmpty((String)group.getRemoteVstoreId())) {
            paramMap.put("vstoreId", group.getVstoreId());
            paramMap.put("remoteVstoreId", group.getRemoteVstoreId());
        }
        try {
            Map resultMap = conn.post("/rest/${deviceId}/CONSISTENTGROUP", paramMap);
            return HVSRestTransitionExtend.transitionReplicationGroup(resultMap, group.getSrcDevSN());
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"Create replication group failed with error:%s, errorMsg:%s", new Object[]{e.getErrorCode(), e.getMessage()});
            throw e;
        }
    }

    public List<ReplicationGroup> batchQueryReplicationGroup(String devSn, String criteria) {
        if (VerifyUtil.isEmpty((String)devSn) || VerifyUtil.isEmpty((String)criteria)) {
            logger.error((Object)"Create replication group fail, invalid input param.");
            throw new LegoCheckedException(1073947393L);
        }
        RestConnection conn = RestConnectionManager.getInstance().getConnection(devSn);
        if (VerifyUtil.isEmpty((Object)conn)) {
            logger.error((Object)"Storage Device(sn:%s) is offline.", new Object[]{devSn});
            throw new LegoCheckedException(104401L);
        }
        try {
            List results = conn.getBatch("/rest/${deviceId}/CONSISTENTGROUP" + criteria, null, false);
            return results.stream().map(result -> HVSRestTransitionExtend.transitionReplicationGroup(result, devSn)).collect(Collectors.toList());
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"Query replication group failed with error:%s, errorMsg:%s", new Object[]{e.getErrorCode(), e.getMessage()});
            throw e;
        }
    }
}

