/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cbb.resource.sdk.model;

import com.huawei.lego.cbb.resource.sdk.model.TopoObject;
import com.huawei.lego.com.south.sdk.model.Protocol;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class Node
extends TopoObject {
    public static final String PRIVATE_ENTERPRISE_STR = ".iso.org.dod.internet.private.enterprises";
    public static final String PRIVATE_ENTERPRISE_OID = ".1.3.6.1.4.1";
    private static final long serialVersionUID = 6353073827056979277L;
    private static final Log LOG = LogFactory.getInstance(Node.class);
    private Map<String, Protocol> managementProtocolMap = new HashMap<String, Protocol>();
    private Timestamp discoveredTime = null;
    private String discoveredTimeStr = null;
    private String sysDescr;
    private String sysName;
    private String sysOid;
    private Protocol discoveryProtocol = null;

    public Node() {
        this.setType(this.getClass().getName());
    }

    public Protocol getDiscoveryProtocol() {
        return this.discoveryProtocol;
    }

    public void setDiscoveryProtocol(Protocol discoveryProtocol) {
        this.discoveryProtocol = discoveryProtocol;
    }

    public String getDiscoveredTimeStr() {
        if (this.discoveredTime != null) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            this.discoveredTimeStr = format.format(this.discoveredTime);
        }
        return this.discoveredTimeStr;
    }

    public Timestamp getDiscoveredTime() {
        return this.discoveredTime;
    }

    public void setDiscoveredTime(Timestamp discoveredTime) {
        this.discoveredTime = discoveredTime;
    }

    public Map<String, Protocol> getManagementProtocolMap() {
        return this.managementProtocolMap;
    }

    public void setManagementProtocolMap(Map<String, Protocol> managementProtocolMap) {
        this.managementProtocolMap = managementProtocolMap;
    }

    public void addManagementProtocol(String protocolParamName, Protocol managementProtocol) {
        this.managementProtocolMap.put(protocolParamName, managementProtocol);
    }

    public void removeManagementProtocol(String protocolParamName) {
        this.managementProtocolMap.remove(protocolParamName);
    }

    public Protocol getManagementProtocol(String protocolParamName) {
        return this.managementProtocolMap.get(protocolParamName);
    }

    public String getSysDescr() {
        return this.sysDescr;
    }

    public void setSysDescr(String sysDescrr) {
        this.sysDescr = sysDescrr;
    }

    public String getSysName() {
        return this.sysName;
    }

    public void setSysName(String sysNamer) {
        this.sysName = sysNamer;
    }

    public String getSysOid() {
        return this.sysOid;
    }

    public void setSysOid(String sysOid) {
        if (sysOid != null && sysOid.contains(PRIVATE_ENTERPRISE_STR)) {
            sysOid = sysOid.replace(PRIVATE_ENTERPRISE_STR, PRIVATE_ENTERPRISE_OID);
            LOG.info((Object)String.format(Locale.ENGLISH, "Converted sysOid is : %s.", sysOid), 0L);
        }
        this.sysOid = sysOid;
    }

    @Override
    public Node clone() {
        Node node = (Node)super.clone();
        if (this.managementProtocolMap != null) {
            HashMap<String, Protocol> clonedProtocolMap = new HashMap<String, Protocol>();
            node.setManagementProtocolMap(clonedProtocolMap);
            for (Map.Entry<String, Protocol> entry : this.managementProtocolMap.entrySet()) {
                clonedProtocolMap.put(entry.getKey(), entry.getValue().clone());
            }
        }
        return node;
    }

    @Override
    public String toString() {
        return super.toString() + "-->Node [discoveredTime=" + this.discoveredTime + ", managementProtocolMap=" + this.managementProtocolMap + ", sysOid=" + this.sysOid + "]";
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Node other = (Node)obj;
        if (!this.overrideEqualsOne(other)) {
            return false;
        }
        return this.overrideEqualsTwo(other);
    }

    private boolean overrideEqualsTwo(Node other) {
        if (this.sysName == null ? other.sysName != null : !this.sysName.equals(other.sysName)) {
            return false;
        }
        return !(this.sysOid == null ? other.sysOid != null : !this.sysOid.equals(other.sysOid));
    }

    private boolean overrideEqualsOne(Node other) {
        if (this.discoveredTime == null ? other.discoveredTime != null : !this.discoveredTime.equals(other.discoveredTime)) {
            return false;
        }
        return !(this.sysDescr == null ? other.sysDescr != null : !this.sysDescr.equals(other.sysDescr));
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
    }
}

