/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.com.south.snmp;

import com.huawei.lego.com.south.snmp.listener.SnmpTrapListener;
import com.huawei.lego.com.south.snmp.trap.LegoTrapListener;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.fault.sdk.model.SnmpTrapPDU;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;

public class SnmpTrapRecvAPI
implements Runnable {
    private static final long serialVersionUID = 2833299099608394253L;
    private static final List<LegoTrapListener> LISTENERS = new ArrayList<LegoTrapListener>();
    private static SnmpTrapRecvAPI strAPIs = null;
    private static LinkedBlockingQueue<SnmpTrapPDU> queue = new LinkedBlockingQueue();
    private Log logger = LogFactory.getInstance(this);

    private SnmpTrapRecvAPI() {
    }

    public static synchronized SnmpTrapRecvAPI getInstance() {
        if (strAPIs == null) {
            strAPIs = new SnmpTrapRecvAPI();
            Thread thread = new Thread((Runnable)strAPIs, "SnmpTrapRecvAPI");
            thread.start();
        }
        return strAPIs;
    }

    public synchronized void addTrapListener(SnmpTrapListener listener) {
        LISTENERS.add(new LegoTrapListener(listener));
    }

    public synchronized void notifyListener(SnmpTrapPDU snmpTrappdu) {
        try {
            queue.offer(snmpTrappdu);
        }
        catch (Exception e) {
            this.logger.error((Object)"the queue is error", 200L);
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                block3: while (true) {
                    SnmpTrapPDU snmpTrappdu = queue.take();
                    Iterator<LegoTrapListener> iterator = LISTENERS.iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block3;
                        LegoTrapListener listener = iterator.next();
                        listener.receivedTrap(snmpTrappdu);
                    }
                    break;
                }
            }
            catch (Exception t) {
                this.logger.error((Object)("SnmpTrapRecvAPI Catch a Exception" + ExceptionUtil.getErrorMessage(t)), 200L);
                continue;
            }
            break;
        }
    }
}

