/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.com.south.snmp.walk;

import com.huawei.lego.com.south.sdk.model.LegoSnmpVarBind;
import com.huawei.lego.com.south.snmp.listener.SnmpWalkListener;
import com.huawei.lego.com.south.snmp.util.SnmpUtil;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.util.TreeEvent;
import org.snmp4j.util.TreeListener;

public class LegoWalkListener
implements TreeListener {
    private Log logger = LogFactory.getInstance(this);
    private SnmpWalkListener listener;
    private boolean finishStatus = false;
    private int requests;

    public LegoWalkListener(SnmpWalkListener listener) {
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finished(TreeEvent treeevent) {
        if (null != treeevent.getVariableBindings() && treeevent.getVariableBindings().length > 0) {
            this.next(treeevent);
        }
        if (treeevent.isError()) {
            this.logger.error((Object)"The following error occurred during walk:", (Throwable)treeevent.getException(), 653110169501696L);
        }
        this.finishStatus = true;
        this.listener.finished();
        SnmpWalkListener snmpWalkListener = this.listener;
        synchronized (snmpWalkListener) {
            this.listener.notifyAll();
        }
    }

    public boolean isFinished() {
        return this.finishStatus;
    }

    public boolean next(TreeEvent treeevent) {
        ++this.requests;
        VariableBinding[] variables = treeevent.getVariableBindings();
        LegoSnmpVarBind[] snmpVariables = SnmpUtil.convert(variables);
        return this.listener.next(snmpVariables);
    }

    public int getRequests() {
        return this.requests;
    }
}

