/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.sdk.log;

import com.huawei.lego.core.sdk.log.LogUtil;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AsyncAppender;
import org.apache.logging.log4j.core.appender.RollingRandomAccessFileAppender;
import org.apache.logging.log4j.core.appender.rolling.DefaultRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.SizeBasedTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.action.Action;
import org.apache.logging.log4j.core.appender.rolling.action.DeleteAction;
import org.apache.logging.log4j.core.appender.rolling.action.IfAccumulatedFileCount;
import org.apache.logging.log4j.core.appender.rolling.action.IfFileName;
import org.apache.logging.log4j.core.appender.rolling.action.PathCondition;
import org.apache.logging.log4j.core.appender.rolling.action.PosixViewAttributeAction;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;

public class DefaultLogConfiguratorParent {
    private static final int MAX_DEPTH = 1;
    private static final int FILE_COUNT_CONDITION = 20;

    public static void configurator(String product) {
        String logName = "com.huawei.lego." + product;
        DefaultLogConfiguratorParent.configuratorLogger(product, logName);
    }

    public static void configuratorLogger(String fileName, String logName) {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        if (!config.getLoggers().containsKey(logName)) {
            RollingRandomAccessFileAppender appender = DefaultLogConfiguratorParent.getDefaultRollingAppender(fileName, logName, config);
            config.addAppender((Appender)appender);
            AppenderRef ref = AppenderRef.createAppenderRef((String)logName, null, null);
            AppenderRef[] refs = new AppenderRef[]{ref};
            AsyncAppender asyncAppender = AsyncAppender.newBuilder().setAppenderRefs(refs).setName("Async" + logName).setConfiguration(config).build();
            asyncAppender.start();
            LoggerConfig loggerConfig = LoggerConfig.createLogger((boolean)false, (Level)Level.INFO, (String)logName, (String)"true", (AppenderRef[])refs, null, (Configuration)config, null);
            loggerConfig.addAppender((Appender)asyncAppender, Level.DEBUG, null);
            config.addLogger(logName, loggerConfig);
            ctx.updateLoggers();
        }
    }

    private static RollingRandomAccessFileAppender getDefaultRollingAppender(String fileName, String logName, Configuration config) {
        SizeBasedTriggeringPolicy policy = SizeBasedTriggeringPolicy.createPolicy((String)"20M");
        Action deleteAction = DefaultLogConfiguratorParent.getDeleteAction(fileName, config);
        PosixViewAttributeAction attributeAction = DefaultLogConfiguratorParent.getPosixViewAttributeAction(fileName);
        DefaultRolloverStrategy strategy = DefaultRolloverStrategy.newBuilder().withCustomActions(new Action[]{deleteAction, attributeAction}).build();
        RollingRandomAccessFileAppender appender = ((RollingRandomAccessFileAppender.Builder)((RollingRandomAccessFileAppender.Builder)((RollingRandomAccessFileAppender.Builder)RollingRandomAccessFileAppender.newBuilder().withName(logName)).withImmediateFlush(false)).withFileName(LogUtil.getLogFile(fileName) + ".log").withFilePattern(LogUtil.getLogFile(fileName) + "_%d{yyyyMMddHHmmss}.log.zip").withStrategy((RolloverStrategy)strategy).withLayout(LogUtil.getDefaultLayout())).withPolicy((TriggeringPolicy)policy).withFilePermissions("rw-r-----").withAdvertise(false).withAppend(LogUtil.isAppend()).build();
        appender.start();
        return appender;
    }

    private static PosixViewAttributeAction getPosixViewAttributeAction(String fileName) {
        HashSet<PosixFilePermission> permissions = new HashSet<PosixFilePermission>(){
            {
                this.add(PosixFilePermission.OWNER_READ);
                this.add(PosixFilePermission.GROUP_READ);
            }
        };
        return PosixViewAttributeAction.newBuilder().withBasePath(LogUtil.getLogPath(fileName)).withMaxDepth(1).withFilePermissions((Set)permissions).withPathConditions(new PathCondition[]{IfFileName.createNameCondition((String)"*.log.zip", null, (PathCondition[])new PathCondition[0])}).withSubst(new StrSubstitutor()).build();
    }

    private static Action getDeleteAction(String fileName, Configuration config) {
        PathCondition[] pathConditions = new PathCondition[]{IfFileName.createNameCondition((String)(LogUtil.getLogFileName(fileName) + "_[0-9]*.log.zip"), null, (PathCondition[])new PathCondition[0]), IfAccumulatedFileCount.createFileCountCondition((int)20, (PathCondition[])new PathCondition[0])};
        return DeleteAction.createDeleteAction((String)LogUtil.getLogPath(fileName), (boolean)false, (int)1, (boolean)false, null, (PathCondition[])pathConditions, null, (Configuration)config);
    }
}

