/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.sdk.log.filter;

import com.huawei.lego.core.sdk.log.filter.FlagMarker;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.message.FormattedMessage;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.util.PerformanceSensitive;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Plugin(name="SensitiveFlagFilter", category="Core", elementType="filter", printObject=true)
@PerformanceSensitive(value={"allocation"})
public class SensitiveFlagFilter
extends AbstractFilter {
    private static final Logger log = LoggerFactory.getLogger(SensitiveFlagFilter.class);
    private static final Set<String> PATH_PREFIX_DEFAULT_SET = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("com.huawei.")));
    private static final Set<String> DEFAULT_SENSITIVE_FIELDS = new HashSet<String>(Arrays.asList("account", "email", "mac", "password", "cookie", "token", "headers", "auth", "session", "ticket", "crypt", "cmd", "command", "psw", "pwd", "passwd"));
    private static final String PARAM_SEPARATOR = "\\|";
    private final Set<String> pathPrefixSet;
    private final Set<String> sensitiveFieldSets;
    private final String sensitiveFieldRegex = "\\b(%s)\\b";
    private FlagMarker flagMarker = FlagMarker.INSTANCE;

    private SensitiveFlagFilter(String sensitivePathPrefix, String sensitiveFields, Filter.Result onMatch, Filter.Result onMismatch) {
        super(onMatch, onMismatch);
        this.pathPrefixSet = VerifyUtil.isEmpty(sensitivePathPrefix) ? PATH_PREFIX_DEFAULT_SET : Collections.unmodifiableSet(Arrays.stream(sensitivePathPrefix.split(PARAM_SEPARATOR)).filter(pathPrefix -> !VerifyUtil.isEmpty(pathPrefix)).collect(Collectors.toSet()));
        this.sensitiveFieldSets = VerifyUtil.isEmpty(sensitiveFields) ? DEFAULT_SENSITIVE_FIELDS : Collections.unmodifiableSet(Arrays.stream(sensitiveFields.split(PARAM_SEPARATOR)).map(str -> str.toLowerCase(Locale.ROOT)).collect(Collectors.toSet()));
    }

    public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, Object msg, Throwable throwable) {
        if (this.skipPrefix(logger)) {
            return this.getOnMismatch();
        }
        return this.filterSensitiveInformation(logger, level, SensitiveFlagFilter.getFormattedMessage(String.valueOf(msg), new Object[0]));
    }

    public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, Message msg, Throwable throwable) {
        if (this.skipPrefix(logger)) {
            return this.getOnMismatch();
        }
        return this.filterSensitiveInformation(logger, level, msg.getFormattedMessage());
    }

    public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, String msg, Object ... params) {
        if (this.skipPrefix(logger)) {
            return this.getOnMismatch();
        }
        if (params.length > 0 && params[params.length - 1].getClass().isInstance((Object)this.flagMarker)) {
            return this.getOnMismatch();
        }
        return this.filterSensitiveInformation(logger, level, SensitiveFlagFilter.getFormattedMessage(msg, params));
    }

    public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, String msg, Object param) {
        if (this.skipPrefix(logger)) {
            return this.getOnMismatch();
        }
        if (param.getClass().isInstance((Object)this.flagMarker)) {
            return this.getOnMismatch();
        }
        String message = SensitiveFlagFilter.getFormattedMessage(msg, new Object[]{param});
        return this.filterSensitiveInformation(logger, level, message);
    }

    private static String getFormattedMessage(String msg, Object[] params) {
        return new FormattedMessage(msg, params).getFormattedMessage();
    }

    private boolean skipPrefix(org.apache.logging.log4j.core.Logger logger) {
        String loggerName = logger.getName();
        return this.pathPrefixSet.stream().noneMatch(loggerName::startsWith);
    }

    private Filter.Result filterSensitiveInformation(org.apache.logging.log4j.core.Logger logger, Level level, String formatMessage) {
        String formatMessageLow = formatMessage.toLowerCase(Locale.ROOT).replaceAll(" ", "");
        for (String prefix : this.sensitiveFieldSets) {
            if (!formatMessageLow.contains(prefix) || !this.isMatchSensitivePatterns(formatMessageLow, prefix)) continue;
            logger.log(level, prefix + " ************", (Object)this.flagMarker);
            return this.getOnMatch();
        }
        return this.getOnMismatch();
    }

    private boolean isMatchSensitivePatterns(String formatMessageLow, String prefix) {
        if (formatMessageLow.contains(prefix + ":")) {
            return true;
        }
        if (formatMessageLow.contains(prefix + "\":")) {
            return true;
        }
        return this.regxCheck(formatMessageLow, prefix);
    }

    private boolean regxCheck(String formatMessageLow, String prefix) {
        String regex = String.format("\\b(%s)\\b", prefix);
        return Pattern.compile(regex).matcher(formatMessageLow).find();
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    extends AbstractFilter.AbstractFilterBuilder<Builder>
    implements org.apache.logging.log4j.core.util.Builder<SensitiveFlagFilter> {
        @PluginBuilderAttribute
        private String sensitiveFields;
        @PluginBuilderAttribute
        private String sensitivePathPrefix;

        public SensitiveFlagFilter build() {
            return new SensitiveFlagFilter(this.sensitivePathPrefix, this.sensitiveFields, this.getOnMatch(), this.getOnMismatch());
        }
    }
}

