/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.sdk.util;

import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class CollectionUtils {
    public static <T> Collection<T> compare(Collection<T> sourceList, Collection<T> targetList) {
        ArrayList<T> results = new ArrayList<T>();
        for (T t : targetList) {
            if (sourceList.contains(t)) continue;
            results.add(t);
        }
        return results;
    }

    public static <R, T> Set<T> mapToSet(Collection<R> collection, Function<R, T> function) {
        if (VerifyUtil.isEmpty(collection) || function == null) {
            return Collections.emptySet();
        }
        return collection.stream().map(function).collect(Collectors.toSet());
    }

    public static <R, T> List<T> mapToList(Collection<R> collection, Function<R, T> function) {
        if (VerifyUtil.isEmpty(collection) || function == null) {
            return Collections.emptyList();
        }
        return collection.stream().map(function).collect(Collectors.toList());
    }
}

