/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.sdk.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.fasterxml.jackson.databind.ser.SerializerFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import java.io.IOException;
import java.util.Collection;

public class CustomSerializerProvider
extends DefaultSerializerProvider {
    private static final long serialVersionUID = 8134089332517831285L;

    public CustomSerializerProvider() {
    }

    public CustomSerializerProvider(CustomSerializerProvider provider, SerializationConfig cfg, SerializerFactory sf) {
        super((SerializerProvider)provider, cfg, sf);
    }

    public DefaultSerializerProvider createInstance(SerializationConfig cfg, SerializerFactory sf) {
        return new CustomSerializerProvider(this, cfg, sf);
    }

    public JsonSerializer<Object> findNullValueSerializer(BeanProperty property) throws JsonMappingException {
        Class clazz = property.getType().getRawClass();
        if (this.isString(clazz)) {
            return this.getEmptyStringSerializer();
        }
        if (this.isArray(clazz)) {
            return this.getEmptyArraySerializer();
        }
        if (this.isNumber(clazz)) {
            if (this.isDouble(clazz)) {
                return this.getEmptyDoubleSerializer();
            }
            return this.getEmptyIntSerializer();
        }
        if (this.isBoolean(clazz)) {
            return this.getEmptyBooleanSerializer();
        }
        return super.findNullValueSerializer(property);
    }

    private boolean isArray(Class clazz) {
        return clazz != null && (clazz.isArray() || Collection.class.isAssignableFrom(clazz) || JSONArray.class.isAssignableFrom(clazz));
    }

    private boolean isString(Class clazz) {
        return clazz != null && (String.class.isAssignableFrom(clazz) || Character.TYPE.isAssignableFrom(clazz) || Character.class.isAssignableFrom(clazz));
    }

    private boolean isNumber(Class clazz) {
        if (null == clazz) {
            return false;
        }
        if (Byte.TYPE.isAssignableFrom(clazz) || Short.TYPE.isAssignableFrom(clazz) || Integer.TYPE.isAssignableFrom(clazz)) {
            return true;
        }
        return Long.TYPE.isAssignableFrom(clazz) || Float.TYPE.isAssignableFrom(clazz) || Double.TYPE.isAssignableFrom(clazz) || Number.class.isAssignableFrom(clazz);
    }

    private boolean isDouble(Class clazz) {
        return clazz != null && (Double.TYPE.isAssignableFrom(clazz) || Double.class.isAssignableFrom(clazz));
    }

    private boolean isBoolean(Class clazz) {
        return clazz != null && (Boolean.TYPE.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz));
    }

    private JsonSerializer<Object> getEmptyStringSerializer() {
        return new JsonSerializer<Object>(){

            public void serialize(Object obj, JsonGenerator jgen, SerializerProvider provider) throws IOException {
                jgen.writeString("");
            }
        };
    }

    private JsonSerializer<Object> getEmptyBooleanSerializer() {
        return new JsonSerializer<Object>(){

            public void serialize(Object obj, JsonGenerator jgen, SerializerProvider provider) throws IOException {
                jgen.writeBoolean(false);
            }
        };
    }

    private JsonSerializer<Object> getEmptyArraySerializer() {
        return new JsonSerializer<Object>(){

            public void serialize(Object value, JsonGenerator gen, SerializerProvider arg2) throws IOException {
                gen.writeObject((Object)new JSONArray());
            }
        };
    }

    private JsonSerializer<Object> getEmptyIntSerializer() {
        return new JsonSerializer<Object>(){

            public void serialize(Object value, JsonGenerator gen, SerializerProvider arg2) throws IOException {
                gen.writeNumber(0);
            }
        };
    }

    private JsonSerializer<Object> getEmptyDoubleSerializer() {
        return new JsonSerializer<Object>(){

            public void serialize(Object value, JsonGenerator gen, SerializerProvider arg2) throws IOException {
                gen.writeNumber(0.0);
            }
        };
    }
}

