/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.sdk.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.google.json.JsonSanitizer;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CustomSerializerProvider;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.LegoBaseConfig;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.map.ListOrderedMap;

public class JSONObject
implements Map,
Serializable {
    private static final String JSON_NEST_DEPTH_CONFIG = "jsonSanitizer.nestDepth";
    private static int nestDepth;
    private static final long serialVersionUID = -54719329954411374L;
    private static final Log logger;
    private static ObjectMapper defaultObjMapper;
    private Map properties = new ListOrderedMap();

    public static JSONObject fromObject(Object obj) {
        if (VerifyUtil.isEmpty(obj)) {
            return new JSONObject();
        }
        if (obj instanceof JSONObject) {
            return (JSONObject)obj;
        }
        JSONObject json = new JSONObject();
        try {
            Map ret = null;
            if (obj instanceof String) {
                ret = (Map)defaultObjMapper.readValue(JsonSanitizer.sanitize((String)obj.toString(), (int)nestDepth), Map.class);
            } else {
                String jsonString = defaultObjMapper.writeValueAsString(obj);
                ret = (Map)defaultObjMapper.readValue(JsonSanitizer.sanitize((String)jsonString, (int)nestDepth), Map.class);
            }
            if (null != ret) {
                JSONObject.convertProperty(json, ret, null);
            }
        }
        catch (Exception e) {
            logger.error("fromObject failed:" + ExceptionUtil.getErrorMessage(e));
            ExceptionUtil.rethrowException(e, "fromObject failed:", -1L, null, logger);
        }
        return json;
    }

    public static int getNestDepth() {
        return nestDepth;
    }

    private static void convertProperty(JSONObject json, Map ret, Set<String> ignoreProperties) {
        Iterator iterator = ret.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry obj;
            Map.Entry entry = obj = iterator.next();
            String key = entry.getKey().toString();
            if (null != ignoreProperties && ignoreProperties.contains(key)) continue;
            Object value = entry.getValue();
            Object tempValue = JSONObject.transforValueToJson(value);
            json.properties.put(entry.getKey(), tempValue);
        }
    }

    private static Object transforValueToJson(Object value) {
        Object tempValue = value;
        if (value instanceof Map && !(value instanceof JSONObject)) {
            tempValue = JSONObject.fromObject(value);
        } else if (value instanceof Collection && !(value instanceof JSONArray)) {
            tempValue = JSONArray.fromObject(value);
        }
        return tempValue;
    }

    public static JSONObject fromObject(Object obj, String[] ignoreProperties) {
        HashSet<String> ignoreSet = new HashSet<String>();
        if (null != ignoreProperties) {
            for (String property : ignoreProperties) {
                ignoreSet.add(property);
            }
        }
        return JSONObject.fromObject(obj, ignoreSet);
    }

    public static JSONObject fromObject(Object obj, List<String> includes) {
        JSONObject json = JSONObject.fromObject(obj);
        if (includes != null && !includes.isEmpty()) {
            json.entrySet().removeIf(entry -> !includes.contains(((Map.Entry)entry).getKey()));
        }
        return json;
    }

    public static JSONObject fromObject(Object obj, Set<String> ignoreProperties) {
        if (null == obj) {
            logger.error("fromObject param is emtpy");
            throw new LegoCheckedException(1073947393L);
        }
        JSONObject json = new JSONObject();
        try {
            Map ret = null;
            ObjectWriter objWriter = defaultObjMapper.writer();
            if (!VerifyUtil.isEmpty(ignoreProperties)) {
                objWriter = JSONObject.getWriterWithFilter(obj, ignoreProperties);
            }
            if (obj instanceof String) {
                ret = (Map)defaultObjMapper.readValue(obj.toString(), Map.class);
            } else {
                String jsonString = objWriter.writeValueAsString(obj);
                ret = (Map)defaultObjMapper.readValue(jsonString, Map.class);
            }
            if (null != ret) {
                JSONObject.convertProperty(json, ret, ignoreProperties);
            }
        }
        catch (Exception e) {
            logger.error("fromObject failed:" + ExceptionUtil.getErrorMessage(e));
            ExceptionUtil.rethrowException(e, "fromObject failed:", -1L, null, logger);
        }
        return json;
    }

    private static ObjectWriter getWriterWithFilter(Object obj, Set<String> ignoreProperties) {
        ObjectMapper objMapper = new ObjectMapper();
        objMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objMapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        CustomSerializerProvider sp = new CustomSerializerProvider();
        objMapper.setSerializerProvider((DefaultSerializerProvider)sp);
        objMapper.setAnnotationIntrospector((AnnotationIntrospector)new JacksonAnnotationIntrospector(){
            private static final long serialVersionUID = 7803579234214249536L;

            public Object findFilterId(Annotated ac) {
                return ac.getName();
            }
        });
        SimpleFilterProvider filters = new SimpleFilterProvider().addFilter(obj.getClass().getName(), SimpleBeanPropertyFilter.serializeAllExcept(ignoreProperties));
        ObjectWriter objWriter = objMapper.writer((FilterProvider)filters);
        return objWriter;
    }

    public static <T> T toBean(JSONObject jsonObject, Class<T> beanClass) {
        if (null == jsonObject) {
            logger.info("JSON Object is null");
            return null;
        }
        return JSONObject.toBean(jsonObject.toString(), beanClass);
    }

    public static <T> T toBean(String jsonStr, Class<T> clazz) {
        if (null == clazz) {
            logger.error("parameter error");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty(jsonStr)) {
            logger.info("Json Str is null");
            return null;
        }
        Object body = null;
        try {
            body = defaultObjMapper.readValue(JsonSanitizer.sanitize((String)jsonStr, (int)nestDepth), clazz);
        }
        catch (Exception e) {
            logger.error("json to bean failed:" + ExceptionUtil.getErrorMessage(e));
            ExceptionUtil.rethrowException(e, "json to bean failed", -1L, null, logger);
        }
        return (T)body;
    }

    public Object get(String key) {
        if (null == key || key.isEmpty()) {
            logger.error("the key is empty");
            throw new LegoCheckedException(1073947393L);
        }
        return this.properties.get(key);
    }

    public boolean getBoolean(String key) {
        Object value = this.get(key);
        if (null != value) {
            if (Boolean.FALSE.equals(value) || value instanceof String && ((String)value).equalsIgnoreCase("false")) {
                return false;
            }
            if (Boolean.TRUE.equals(value) || value instanceof String && ((String)value).equalsIgnoreCase("true")) {
                return true;
            }
        }
        logger.error("JSONObject getBoolean failed,value is null or doesn't contain this key.key=" + key);
        throw new LegoCheckedException(-1L);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        boolean value = defaultValue;
        if (this.properties.containsKey(key)) {
            value = this.getBoolean(key);
        }
        return value;
    }

    public double getDouble(String key) {
        Object value = this.get(key);
        if (null != value) {
            try {
                return value instanceof Number ? ((Number)value).doubleValue() : Double.parseDouble(value.toString());
            }
            catch (Exception e) {
                logger.error("getDouble failed:" + ExceptionUtil.getErrorMessage(e));
                ExceptionUtil.rethrowException(e, "getDouble failed", -1L, null, logger);
            }
        }
        logger.error("JSONObject getDouble failed,value is null or doesn't contain this key.key=" + key);
        throw new LegoCheckedException(-1L);
    }

    public double getDouble(String key, double defaultValue) {
        double value = defaultValue;
        if (this.properties.containsKey(key)) {
            value = this.getDouble(key);
        }
        return value;
    }

    public int getInt(String key) {
        Object obj = this.get(key);
        if (obj != null) {
            return obj instanceof Number ? ((Number)obj).intValue() : (int)this.getDouble(key);
        }
        logger.error("JSONObject getInt failed,value is null or doesn't contain this key.key=" + key);
        throw new LegoCheckedException(-1L);
    }

    public int getInt(String key, int defaultValue) {
        int value = defaultValue;
        if (this.properties.containsKey(key)) {
            value = this.getInt(key);
        }
        return value;
    }

    public long getLong(String key) {
        Object obj = this.get(key);
        if (obj != null) {
            return obj instanceof Number ? ((Number)obj).longValue() : (long)((int)this.getDouble(key));
        }
        logger.error("JSONObject getLong failed,value is null or doesn't contain this key.key=" + key);
        throw new LegoCheckedException(-1L);
    }

    public long getLong(String key, long defaultValue) {
        long value = defaultValue;
        if (this.properties.containsKey(key)) {
            value = this.getLong(key);
        }
        return value;
    }

    public String getString(String key) {
        if (!this.properties.containsKey(key)) {
            logger.debug(String.format(Locale.ENGLISH, "JSONObject getString failed,the object doesn't contain this key.key=%s.", key));
            throw new LegoCheckedException(-1L);
        }
        Object obj = this.get(key);
        if (obj != null) {
            return obj.toString();
        }
        return null;
    }

    public String getString(String key, String defaultValue) {
        String value = defaultValue;
        if (this.properties.containsKey(key)) {
            value = this.getString(key);
        }
        return value;
    }

    public String toString() {
        try {
            return defaultObjMapper.writeValueAsString((Object)this.properties);
        }
        catch (JsonProcessingException e) {
            logger.error("toString failed:" + ExceptionUtil.getErrorMessage(e));
            ExceptionUtil.rethrowException(e, "Json to string failed", -1L, null, logger);
            throw new LegoCheckedException(-1L);
        }
    }

    public JSONObject getJSONObject(String key) {
        Object obj = this.get(key);
        if (null != obj) {
            JSONObject json = null;
            json = !(obj instanceof JSONObject) ? JSONObject.fromObject(obj) : (JSONObject)obj;
            return json;
        }
        return null;
    }

    public JSONArray getJSONArray(String key) {
        Object obj = this.get(key);
        if (null != obj) {
            JSONArray array = null;
            array = !(obj instanceof JSONArray) ? JSONArray.fromObject(obj) : (JSONArray)obj;
            return array;
        }
        return null;
    }

    @Override
    public void clear() {
        this.properties.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.properties.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.properties.containsValue(value);
    }

    public Set entrySet() {
        return this.properties.entrySet();
    }

    public Object get(Object key) {
        return this.properties.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    public Iterator keys() {
        return this.properties.keySet().iterator();
    }

    public Set keySet() {
        return this.properties.keySet();
    }

    public Object put(Object key, Object value) {
        if (null == key) {
            logger.error("the key is empty");
            throw new LegoCheckedException(1073947393L);
        }
        if (null == value) {
            logger.debug("the value will put is null");
            return this;
        }
        Object tempValue = value;
        if (value instanceof String) {
            tempValue = this.convertStr2Json(value);
        } else if (value instanceof Map && !(value instanceof JSONObject)) {
            tempValue = JSONObject.fromObject(value);
        } else if (value instanceof Collection && !(value instanceof JSONArray)) {
            tempValue = JSONArray.fromObject(value);
        }
        return this.properties.put(key, tempValue);
    }

    public JSONObject set(Object key, Object value) {
        this.put(key, value);
        return this;
    }

    private Object convertStr2Json(Object value) {
        Object tempValue = value;
        try {
            if (((String)value).startsWith("{") && ((String)value).endsWith("}")) {
                tempValue = JSONObject.fromObject(value);
            } else if (((String)value).startsWith("[") && ((String)value).endsWith("]")) {
                tempValue = JSONArray.fromObject(value);
            }
        }
        catch (LegoCheckedException e) {
            logger.debug(String.format(Locale.ENGLISH, "Can't convert string to JSON Object:str=%s.", value));
        }
        return tempValue;
    }

    public void putAll(Map map) {
        if (null == map) {
            logger.error("the map is null");
            throw new LegoCheckedException(1073947393L);
        }
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry obj;
            Map.Entry entry = obj = iterator.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            this.put(key, value);
        }
    }

    public Object remove(Object key) {
        return this.properties.remove(key);
    }

    @Override
    public int size() {
        return this.properties.size();
    }

    public Collection values() {
        return this.properties.values();
    }

    public <T> T toBean(Class<T> type) {
        return JSONObject.toBean(this, type);
    }

    public <T> Map<String, T> toMap(Class<T> type) {
        HashMap map = new HashMap();
        if (type != null) {
            this.properties.forEach((key, value) -> {
                if (value == null || type.isInstance(value)) {
                    map.put(key.toString(), type.cast(value));
                }
            });
        }
        return map;
    }

    public static <T> Map<String, T> toMap(JSONObject object, Class<T> type) {
        if (object == null) {
            return Collections.emptyMap();
        }
        return object.toMap(type);
    }

    public JSONObject pick(Map<String, ?> data, String ... fields) {
        if (data == null || fields == null) {
            return this;
        }
        for (String field : fields) {
            if (!data.containsKey(field)) continue;
            this.put(field, data.get(field));
        }
        return this;
    }

    public JSONObject pick(JSONObject data, String ... fields) {
        if (data == null || fields == null) {
            return this;
        }
        return this.pick(data.toMap(Object.class), fields);
    }

    public JSONObject rename(String source, String target) {
        if (!VerifyUtil.isEmpty(source) && !VerifyUtil.isEmpty(target) && this.containsKey(source)) {
            this.properties.put(target, this.properties.remove(source));
        }
        return this;
    }

    public JSONObject copyAs(String source, String target) {
        if (!VerifyUtil.isEmpty(source) && !VerifyUtil.isEmpty(target) && this.containsKey(source)) {
            this.properties.put(target, this.properties.remove(source));
        }
        return this;
    }

    public JSONObject putString(String key, String value) {
        if (null == key) {
            logger.error("The key is empty");
            throw new LegoCheckedException(1073947393L);
        }
        if (null == value) {
            logger.debug("The value will put is null");
            return this;
        }
        this.properties.put(key, value);
        return this;
    }

    static {
        logger = LogFactory.getInstance(JSONObject.class);
        defaultObjMapper = new ObjectMapper();
        try {
            defaultObjMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            defaultObjMapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
            CustomSerializerProvider sp = new CustomSerializerProvider();
            defaultObjMapper.setSerializerProvider((DefaultSerializerProvider)sp);
        }
        catch (Exception e) {
            logger.error("Initialize ObjectMapper failed:" + ExceptionUtil.getErrorMessage(e));
        }
        long configNestDepth = LegoBaseConfig.getInstance().getNumberWithMaxValue(JSON_NEST_DEPTH_CONFIG, 64L, 4096L);
        nestDepth = (int)Math.max(64L, configNestDepth);
    }
}

