/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.sdk.util;

import com.huawei.ism.drm.wcc.util.utils.FileWatchService;
import com.huawei.ism.drm.wcc.util.utils.SysPropertiesUtils;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.file.util.FileUtil;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.PathUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.core.sdk.util.WccEncryptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.text.Normalizer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class LegoBaseConfig {
    public static final String SYSTEM_PROPERTIES = "conf/lego.properties";
    private static final String ARB_CONFIG = "conf/arb.properties";
    private static final String NODE_CONFIG = "conf/node.properties";
    private static final String SYS_DEFAULT_DBPASSWORD_ISCHANGED = "sys.default.dbpassword.ischanged";
    private static final String SYS_DEFAULT_MANAGERDBPASSWORD_ISCHANGED = "sys.default.managerdbpassword.ischanged";
    private static final Log LOGGER = LogFactory.getInstance(LegoBaseConfig.class);
    private static final Map<String, LegoBaseConfig> INSTANCES = new HashMap<String, LegoBaseConfig>();
    private static final String CERT_ALARM_SWITCH_OFF = "off";
    private static final String CERT_ALARM_SWITCH = "CertificateAlarmSwith";
    private static final String DEPLOY_CONFIG = "conf/legoDeploy.conf";
    public static final String TOMCAT_CONFIG = "../conf/catalina.properties";
    protected Properties properties;
    private String path;
    private long updateTime;

    public LegoBaseConfig(String path) {
        this.path = path;
        this.readConfigProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readConfigProperties() {
        File file = new File(this.path);
        if (file.exists()) {
            FileInputStream fileInputStream = null;
            InputStreamReader inputReader = null;
            try {
                fileInputStream = new FileInputStream(file);
                inputReader = new InputStreamReader((InputStream)fileInputStream, Charset.defaultCharset());
                Properties props = new Properties();
                props.load(inputReader);
                this.setProperties(props);
                this.setUpdateTime(System.currentTimeMillis());
            }
            catch (IOException e) {
                try {
                    LOGGER.error((Object)"Read lego.properties fail, error:%s.", ExceptionUtil.getErrorMessage(e));
                }
                catch (Throwable throwable) {
                    CommonUtil.close(inputReader);
                    CommonUtil.close(fileInputStream);
                    throw throwable;
                }
                CommonUtil.close(inputReader);
                CommonUtil.close(fileInputStream);
            }
            CommonUtil.close(inputReader);
            CommonUtil.close(fileInputStream);
        }
    }

    public static LegoBaseConfig getArbConfig() {
        return LegoBaseConfig.getInstance(ARB_CONFIG);
    }

    public static LegoBaseConfig getNodeConfig() {
        return LegoBaseConfig.getInstance(NODE_CONFIG);
    }

    public synchronized void reloadConfigProperties() {
        this.readConfigProperties();
    }

    public static synchronized void updateInstance() {
        for (LegoBaseConfig config : INSTANCES.values()) {
            if (config == null) continue;
            config.reloadConfigProperties();
        }
    }

    public void setConfigValue(String key, String value) {
        this.setConfigValue(key, value, Boolean.FALSE);
    }

    public void setConfigValue(String key, String value, boolean preciseMatch) {
        if (key == null || value == null) {
            LOGGER.error("SetConfigValue failed, cause key or value is null.");
            return;
        }
        Map<String, String> data = Collections.singletonMap(key, value);
        try {
            FileUtil.modifyPropFileUsingStr(this.path, data, this.path, preciseMatch);
            this.reloadConfigProperties();
        }
        catch (IOException e) {
            LOGGER.error((Object)"SetConfigValue failed, error:%s.", ExceptionUtil.getErrorMessage(e));
            throw new LegoCheckedException(-1L);
        }
    }

    public static synchronized LegoBaseConfig getInstance(String path) {
        LegoBaseConfig config = INSTANCES.get(path);
        if (config == null) {
            config = new LegoBaseConfig(path);
            INSTANCES.put(path, config);
        }
        return config;
    }

    public static LegoBaseConfig getInstance() {
        return LegoBaseConfig.getInstance(SYSTEM_PROPERTIES);
    }

    public String getKeyValue(String key) {
        String value = "";
        if (this.properties != null) {
            value = this.properties.getProperty(key);
        }
        return value;
    }

    public String getKeyValue(String key, String defaultValue) {
        String value = this.getKeyValue(key);
        value = value != null ? Normalizer.normalize(value, Normalizer.Form.NFKC) : defaultValue;
        return value;
    }

    public long getNumber(String key, long defaultValue) {
        long num;
        String value = this.getKeyValue(key, String.valueOf(defaultValue));
        LOGGER.debug((Object)"Get value from config file with key, key:%s value:%s.", key, value);
        value = value != null ? value : "";
        value = value.replaceAll("^\\s*|\\s*$", "");
        value = value.matches("^\\d+$") ? value : String.valueOf(defaultValue);
        try {
            num = Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)"Number format error for %s , will use default value:%s.", key, defaultValue);
            num = defaultValue;
        }
        return num;
    }

    public int getInt(String key, int defaultValue, int lowerLimit, int upperLimit) {
        int value = this.getInt(key, defaultValue);
        value = Math.max(value, lowerLimit);
        value = Math.min(value, upperLimit);
        return value;
    }

    public int getInt(String key, int defaultValue) {
        return this.getInt(key, () -> defaultValue);
    }

    public int getInt(String key, Supplier<Integer> defaultValueSupplier) {
        if (this.properties == null) {
            return defaultValueSupplier.get();
        }
        String property = this.properties.getProperty(key);
        if (property == null) {
            return defaultValueSupplier.get();
        }
        try {
            return Integer.parseInt(property.trim());
        }
        catch (NumberFormatException e) {
            int defaultValue = defaultValueSupplier.get();
            LOGGER.error((Object)"Number format error for %s , will use default value: %s.", key, defaultValue);
            return defaultValue;
        }
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        String value = this.getKeyValue(key, String.valueOf(defaultValue));
        if (!VerifyUtil.isEmpty(value)) {
            return Boolean.parseBoolean(value);
        }
        return defaultValue;
    }

    public Set<String> getArbRegionIdList() {
        HashSet<String> regionIdList = new HashSet<String>();
        if (Boolean.parseBoolean(this.properties.getProperty("arb.enable", "false"))) {
            regionIdList.add(LegoBaseConfig.getNodeConfig().getKeyValue("config.hcs.node.region"));
        }
        List regionAutoRecoveryKeys = this.properties.stringPropertyNames().stream().filter(e -> e.endsWith(".arb.enable")).collect(Collectors.toList());
        for (String key : regionAutoRecoveryKeys) {
            regionIdList.add(key.substring(0, key.indexOf(".arb.enable")));
        }
        return regionIdList;
    }

    public static void diffDataBaseConfig(Map<String, String> data) {
        String fileName = PathUtil.getRuntimePath() + File.separator + "bin" + File.separator + "config" + File.separator + "system.xml";
        File file = new File(fileName);
        SAXReader sax = new SAXReader();
        try {
            CommonUtil.setSecurityFeatures(sax);
            Document document = sax.read(file);
            String falseString = "false";
            Node node = document.selectSingleNode("/install/database");
            if (!(node instanceof Element)) {
                LOGGER.error("Node is not instanceof document.");
                return;
            }
            Element dbElement = (Element)node;
            String enDbpassword = dbElement.attributeValue("dbpassword");
            if (!WccEncryptor.decrypt(enDbpassword).equals(WccEncryptor.decrypt(LegoBaseConfig.getInstance().getKeyValue("sys.default.dbPwd", "")))) {
                data.put(SYS_DEFAULT_DBPASSWORD_ISCHANGED, "true");
            } else {
                data.put(SYS_DEFAULT_DBPASSWORD_ISCHANGED, falseString);
            }
            String enManagerdbusername = dbElement.attributeValue("managerpassword");
            if (!WccEncryptor.decrypt(enManagerdbusername).equals(WccEncryptor.decrypt(LegoBaseConfig.getInstance().getKeyValue("sys.default.managerdbPwd", "")))) {
                data.put(SYS_DEFAULT_MANAGERDBPASSWORD_ISCHANGED, "true");
            } else {
                data.put(SYS_DEFAULT_MANAGERDBPASSWORD_ISCHANGED, falseString);
            }
        }
        catch (DocumentException | SAXException e1) {
            LOGGER.error((Object)"Parse document error: %s.", e1);
        }
    }

    private void setProperties(Properties properties) {
        this.properties = properties;
    }

    public long getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(long updateTime) {
        this.updateTime = updateTime;
    }

    public long getNumberWithMaxValue(String key, long defaultValue, long maxLimitValue) {
        long num = this.getNumber(key, defaultValue);
        return Math.min(num, maxLimitValue);
    }

    public void updateKeyValue(String key, String value) throws IOException {
        Set<String> propertyNames = this.properties.stringPropertyNames();
        if (!propertyNames.contains(key)) {
            LOGGER.error("Not support add new key, only set key`s value.");
            throw new IllegalArgumentException("Not support the key");
        }
        this.properties.setProperty(key, value);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.path), StandardCharsets.UTF_8);){
            this.properties.store(writer, "save data");
        }
        catch (FileNotFoundException | UnsupportedEncodingException e) {
            LOGGER.error((Object)"Exception when update file, errorMsg: %s", ExceptionUtil.getErrorMessage(e));
            throw e;
        }
    }

    public boolean isCertAlarmSwitch() {
        boolean certAlarmSwitch = true;
        String alarmSwitch = this.properties.getProperty(CERT_ALARM_SWITCH);
        LOGGER.debug((Object)("cert alarm switch:" + alarmSwitch), 1L);
        if (CERT_ALARM_SWITCH_OFF.equalsIgnoreCase(alarmSwitch)) {
            certAlarmSwitch = false;
        }
        return certAlarmSwitch;
    }

    public static LegoBaseConfig getDeployConfig() {
        return LegoBaseConfig.getInstance(DEPLOY_CONFIG);
    }

    static {
        Optional runtimePathOption = SysPropertiesUtils.getRuntimePath();
        if (runtimePathOption.isPresent()) {
            try {
                FileWatchService.registerTask((String)Paths.get((String)runtimePathOption.get(), "/LegoRuntime/conf/lego.properties").getParent().toString(), (String)"lego.properties", LegoBaseConfig::updateInstance);
            }
            catch (IOException e) {
                LOGGER.error((Object)"LegoConfig initialize fail, msg:%s", ExceptionUtil.getErrorMessage(e));
                throw new ExceptionInInitializerError("LegoConfig initialize fail.");
            }
        } else {
            LOGGER.info("RuntimePath not find, skip register file watch task.");
        }
    }
}

