/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.sdk.util;

import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.LegoProperties;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;

public class PathUtil {
    public static final String EXPORT_PATH = "/LegoRuntime/data/export/";
    private static final String LEGO_RUNTIME = "LegoRuntime";
    private static String basePath = null;
    private static final Log LOG = LogFactory.getInstance(PathUtil.class);

    public static String getRuntimePath() {
        if (LegoProperties.getProperty("Runtime.path", null) != null) {
            LOG.debug((Object)"Get LegoRuntime from lego.properties", 200L);
            return LegoProperties.getProperty("Runtime.path", null);
        }
        if (basePath == null) {
            LOG.debug((Object)"BasePath is null", 200L);
            return null;
        }
        File basefile = new File(basePath);
        if (!basefile.exists()) {
            LOG.debug((Object)"The file is not exist, path:", 200L);
            return null;
        }
        File pathFile = basefile.getParentFile();
        if (null != pathFile && pathFile.exists()) {
            return pathFile.getPath();
        }
        if (null == pathFile) {
            return "";
        }
        return basePath;
    }

    public static String getLegoRuntimePath() {
        return PathUtil.getLegoRuntimePath(true);
    }

    public static String getLegoRuntimePath(boolean quiet) {
        String runtimePath = PathUtil.getRuntimePath();
        if (runtimePath != null) {
            return runtimePath + File.separator + LEGO_RUNTIME;
        }
        if (!quiet) {
            throw new LegoCheckedException("not found LegoRuntime path.");
        }
        return null;
    }

    public static Path getPathUnderRuntime(String path, boolean quiet) {
        String home = PathUtil.getRuntimePath();
        if (home != null) {
            return Paths.get(home, path);
        }
        if (!quiet) {
            throw new LegoCheckedException("not found Runtime path.");
        }
        return null;
    }

    public static Path getPathUnderLegoRuntime(String path, boolean quiet) {
        return Optional.ofNullable(PathUtil.getPathUnderRuntime(LEGO_RUNTIME, quiet)).map(base -> base.resolve(path)).orElse(null);
    }

    public static Path getLegoRuntimeTempDir() {
        return PathUtil.getLegoRuntimeTempDir(false);
    }

    public static Path getLegoRuntimeTempDir(boolean quiet) {
        return PathUtil.getPathUnderLegoRuntime("tmp", quiet);
    }

    public static void setBasePath(String path) {
        if (basePath == null) {
            basePath = path;
        }
    }

    public static String getExportPath() {
        return PathUtil.getRuntimePath() + EXPORT_PATH;
    }

    public static String raiseTo(Path path, String name) {
        Path home = Paths.get(name, new String[0]);
        while (path != null && !home.equals(path.getFileName())) {
            path = path.getParent();
        }
        if (path == null) {
            throw new LegoCheckedException("not found the provided name: " + name);
        }
        return path.toString();
    }

    public static String getInstallPath() {
        try {
            Path path = Paths.get(PathUtil.class.getProtectionDomain().getCodeSource().getLocation().toURI());
            return PathUtil.raiseTo(path, "Runtime");
        }
        catch (Exception e) {
            LOG.error((Object)"get current path failed.", e);
            throw new LegoCheckedException("search home path failed");
        }
    }
}

