/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.sdk.util;

import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ReflectUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.lang.reflect.Field;
import java.text.Normalizer;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class SecurityUtil {
    private static final Log LOG = LogFactory.getInstance(SecurityUtil.class);
    public static final String EMPTY_STRING = "";
    public static final String PHONE_INTERNATION = "^([\\+]\\d{1,6}){0,1}([\\-]{0,1})(\\d{3,20})$";
    private static final String PROPERTIES_BLACK_LIST = "[|&<>$`!;\n]";
    private static final String PROPERTIES_LOOSE_BLACK_LIST = "[|<>$`!\n]";
    private static final String SENSITIVE_PATTERN = "\"(admin_pass|password|Password|PASSWORD|passwd|oldPasswd|newPasswd|passwdNew)\"\\s*:\\s*\"([^\\\\\"]|\\\\.)*\"";
    private static final int PHONE_NUMBER_REGX_THRESHOLD = 8;
    private static final int ERASE_COUNT = 3;
    private static final int PREFIX_LENGTH = 6;
    private static final List<Function<String, String>> maskFunctions = Arrays.asList(SecurityUtil::maskEmail, SecurityUtil::maskPhoneNumber);

    private SecurityUtil() {
    }

    public static String desensitization(String string) {
        String[] exprs;
        String newString = string;
        if (newString == null) {
            return null;
        }
        for (String expr : exprs = new String[]{SENSITIVE_PATTERN}) {
            newString = newString.replaceAll(expr, "\"$1\":\"***\"");
        }
        String str = "(iqn|eui)\\.[A-Za-z0-9.:-]{4,219}";
        newString = newString.replaceAll(str, "***");
        return newString;
    }

    public static boolean fileValueBlackListCheck(String param) {
        if (Objects.isNull(param) || EMPTY_STRING.equals(param)) {
            return false;
        }
        Pattern pattern = Pattern.compile(PROPERTIES_BLACK_LIST);
        Matcher matcher = pattern.matcher(Normalizer.normalize(param, Normalizer.Form.NFKC));
        return matcher.find();
    }

    public static boolean fileValueBlackListCheck(String[] params) {
        for (String param : params) {
            if (!SecurityUtil.fileValueBlackListCheck(param)) continue;
            return true;
        }
        return false;
    }

    public static boolean propertiesValueBlackListCheck(String param) {
        if (VerifyUtil.isEmpty(param)) {
            return false;
        }
        Pattern pattern = Pattern.compile(PROPERTIES_LOOSE_BLACK_LIST);
        Matcher matcher = pattern.matcher(Normalizer.normalize(param, Normalizer.Form.NFKC));
        return matcher.find();
    }

    public static void erasePwd(String password) {
        if (VerifyUtil.isEmpty(password)) {
            return;
        }
        Field value = ReflectUtil.field(String.class, "value", char[].class);
        char[] strValArr = (char[])ReflectUtil.get((Object)password, value);
        SecurityUtil.eraseChars(strValArr);
    }

    public static void eraseChars(char[] chars) {
        if (chars == null) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            Arrays.fill(chars, '\u0000');
        }
    }

    public static void sensitiveClean(String sensitiveStr) {
        if (StringUtils.isEmpty((CharSequence)sensitiveStr)) {
            return;
        }
        try {
            Field valueFieldOfString = String.class.getDeclaredField("value");
            valueFieldOfString.setAccessible(true);
            char[] value = (char[])valueFieldOfString.get(sensitiveStr);
            Arrays.fill(value, '\u0000');
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            LOG.error("Sensitive clean failed.");
        }
    }

    public static String desensitizeId(String id) {
        if (StringUtils.isEmpty((CharSequence)id) || id.length() < 6) {
            return id;
        }
        return id.substring(0, 6) + "******" + id.substring(id.length() - 6);
    }

    public static String tryMask(String str) {
        String maskedStr = str;
        for (Function<String, String> maskFunction : maskFunctions) {
            maskedStr = maskFunction.apply(maskedStr);
        }
        return maskedStr;
    }

    public static String maskEmail(String email) {
        if (VerifyUtil.isEmpty(email)) {
            return EMPTY_STRING;
        }
        int splitIndex = email.lastIndexOf("@");
        if (splitIndex == -1) {
            return email;
        }
        return "******" + email.substring(splitIndex);
    }

    public static String maskPhoneNumber(String phoneNumber) {
        if (VerifyUtil.isEmpty(phoneNumber)) {
            return EMPTY_STRING;
        }
        if (!SecurityUtil.isPhoneNumber(phoneNumber)) {
            return phoneNumber;
        }
        String purePhoneNumber = phoneNumber.substring(phoneNumber.indexOf("-") + 1).replace("+", EMPTY_STRING);
        if (purePhoneNumber.length() < 8) {
            return phoneNumber.substring(0, phoneNumber.length() / 2) + "****";
        }
        return phoneNumber.replaceAll("(\\d{3})\\d+(\\d{4})", "$1****$2");
    }

    private static boolean isPhoneNumber(String phoneNumber) {
        String number = Normalizer.normalize(phoneNumber, Normalizer.Form.NFKC);
        return Pattern.compile(PHONE_INTERNATION).matcher(number).matches();
    }

    public static String escapeControlChar(String text) {
        StringBuilder builder = new StringBuilder();
        if (text != null) {
            for (int index = 0; index < text.length(); ++index) {
                char code = text.charAt(index);
                if (Character.isISOControl(code)) {
                    builder.append(String.format(Locale.ENGLISH, "\\x%04x;", (int)code));
                    continue;
                }
                builder.append(code);
            }
        }
        return builder.toString();
    }
}

