/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.topo.sdk.model;

import com.huawei.lego.nem.topo.sdk.annotation.XmlProperty;
import com.huawei.lego.nem.topo.sdk.model.UIElement;
import com.huawei.lego.nem.topo.sdk.model.UIStyle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TopoElement
implements Serializable {
    private static final long serialVersionUID = 6472875595666199033L;
    @XmlProperty(Alias="UIID")
    private Long id;
    @XmlProperty(Alias="name")
    private String disName;
    private TopoElement parentElement;
    private Set<UIElement> childElements = new HashSet<UIElement>();
    private Map<String, UIStyle> styleSet = new HashMap<String, UIStyle>();

    public TopoElement() {
    }

    public TopoElement(Long id) {
        this.id = id;
    }

    public void addStyle(UIStyle style) {
        if (style == null) {
            return;
        }
        if (this.styleSet.get(style.getStyleName()) != null) {
            UIStyle oldStyle = this.styleSet.get(style.getStyleName());
            style.setStyleId(oldStyle.getStyleId());
            this.styleSet.remove(style.getStyleName());
        }
        this.styleSet.put(style.getStyleName(), style);
    }

    public void removeStyle(String styleName) {
        if (this.styleSet.get(styleName) != null) {
            this.styleSet.remove(styleName);
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getDisName() {
        return this.disName;
    }

    public void setDisName(String disName) {
        this.disName = disName;
    }

    public TopoElement getParentElement() {
        return this.parentElement;
    }

    public void setParentElement(TopoElement parentElement) {
        this.parentElement = parentElement;
    }

    public Set<UIElement> getChildElements() {
        return this.childElements;
    }

    public void setChildElements(Set<UIElement> childElements) {
        this.childElements = childElements;
    }

    public Map<String, UIStyle> getStyleSet() {
        return this.styleSet;
    }

    public void setStyleSet(Map<String, UIStyle> styleSet) {
        this.styleSet = styleSet;
    }
}

