# -*- coding:utf-8 -*-

class Account(object):
    def __init__(self, account_name, account_pwd):
        self.account_name = account_name
        self.account_pwd = account_pwd


class NodeUser(object):
    def __init__(self, user_name, user_pwd, root_name, root_pwd, extra=""):
        self.user_name = user_name
        self.user_pwd = user_pwd
        self.root_name = root_name
        self.root_pwd = root_pwd
        self.extra = extra


class SshInfo(object):
    def __init__(self, node_ips, ssh_user, ssh_passwd="", sudo_passwd=""):
        self.node_ips = node_ips
        self.ssh_user = ssh_user
        self.ssh_passwd = ssh_passwd
        self.sudo_passwd = sudo_passwd


class CmdInfo(object):
    def __init__(self, ssh_client, cmd_list, expect_list=None, is_expect=False):
        if not expect_list:
            expect_list = []
        self.ssh_client = ssh_client
        self.cmd_list = cmd_list
        self.expect_list = expect_list
        self.is_expect = is_expect


class SshCmdInfo(object):
    def __init__(self, ip, cmds, fsp_user, fsp_pass, passwd, authname, authpwd):
        self.ip = ip
        self.cmds = cmds
        self.fsp_user = fsp_user
        self.fsp_pass = fsp_pass
        self.passwd = passwd
        self.authname = authname
        self.authpwd = authpwd


class AccountQualityInfo(object):
    def __init__(self, last_modify_time, expire_time, quality_item, ssh_info):
        self.last_modify_time = last_modify_time
        self.expire_time = expire_time
        self.quality_item = quality_item
        self.account = ssh_info.ssh_user
        self.node_ip = ssh_info.node_ips
        self.ssh_info = ssh_info


class SshParamsCheckInfo(object):
    def __init__(self):
        self.ssh_user_fail_nodes = []
        self.sudo_user_fail_nodes = []
        self.ssh_user_fail_reason = dict()
        self.sudo_user_fail_reason = dict()


class DmkUserInfo(object):
    def __init__(self, user_name, account_name, team_lst, passwd_list):
        self.user_name = user_name
        self.account_name = account_name
        self.team_lst = team_lst
        self.passwd = passwd_list[0]
        self.sudo_passwd = passwd_list[1]


class DmkTaskInfo(object):
    def __init__(self, app_version, deploy_action, content_list, app_name='eBackup_Upgrade'):
        self.app_name = app_name
        self.app_version = app_version
        self.deploy_action = deploy_action
        if len(content_list) != 2:
            raise Exception("Dmk task info content is invalid.")
        self.host_info = content_list[0]
        self.config_info = content_list[1]
