# -*- coding: utf-8 -*-
from utils.business.param_util import HandleParamCheck
from utils.business.param_util import ParamUtil
from utils.common.exception import HCCIException

from plugins.eBackup.common.params_check_tool import check_datamover_web_login, param_check_judge
from plugins.eBackup.common.params_check_tool import check_ebackup_nodes
from plugins.eBackup.common.params_check_tool import check_openstack_params
from plugins.eBackup.common.params_check_tool import init_params
from plugins.eBackup.common.model import SshParamsCheckInfo, SshInfo
from plugins.eBackup.common.util import Utils


def params_check(project_id):
    """插件参数校验接口函数

    错误信息返回值（需要中英文信息）：
    1、支持通过HCCIException(error_code, *arg, **kwargs)类获取中英文信息,此方法是获取公共方法中的错误
    2、支持通过code2Msg(error_code, *arg, **kwargs)函数获取中英文信息,此方法是获取各组件自定义的错误
    """
    ebackup_datamover_nodes = Utils.get_ebackup_datamover_nodes_from_cmdb(project_id)
    Utils.set_value_to_config_file("eBackup_Datamover_nodes", ebackup_datamover_nodes)
    db_opt = ParamUtil()
    check_data = db_opt.get_need_check_cloud_params(project_id, "eBackup")
    check_data.update({"eBackup_Datamover_nodes": ebackup_datamover_nodes})
    check_result = HandleParamCheck()
    all_params = ["openstack_cps_admin_pwd",
                  "eBackup_Datamover_nodes", "eBackup_hcp_pwd",
                  "eBackup_root_pwd", "eBackup_admin_pwd", "eBackup_dmk_user",
                  "eBackup_dmk_password"]
    init_params(check_data, db_opt, project_id, check_result, all_params)

    ebackup_abnormal_nodes_info = SshParamsCheckInfo()
    openstack_abnormal_nodes_info = SshParamsCheckInfo()
    ip_list = check_data.get("eBackup_Datamover_nodes").replace(" ", "").replace("|", ";").split(";")
    ssh_info = SshInfo(ip_list, "hcp", check_data.get("eBackup_hcp_pwd"), check_data.get("eBackup_root_pwd"))
    check_ebackup_nodes(check_result, "eBackup_Datamover_nodes", ssh_info, ebackup_abnormal_nodes_info)

    param_check_judge(check_result, ebackup_abnormal_nodes_info)
    check_openstack_params(check_result, check_data, openstack_abnormal_nodes_info)
    ebackup_check_openstack_param(
        check_result, ebackup_abnormal_nodes_info, openstack_abnormal_nodes_info)
    # check datamover web login
    result = check_datamover_web_login(check_data, check_result, all_params)
    return result


def ebackup_check_openstack_param(check_result, ebackup_abnormal_nodes_info, openstack_abnormal_nodes_info):

    unpassed_ebackup_hcp_nodes = ebackup_abnormal_nodes_info.ssh_user_fail_nodes
    unpassed_openstack_fsp_nodes = openstack_abnormal_nodes_info.ssh_user_fail_nodes
    fsp_expire_msg = openstack_abnormal_nodes_info.ssh_user_fail_reason
    unpassed_openstack_root_nodes = openstack_abnormal_nodes_info.sudo_user_fail_nodes
    if 0 != len(unpassed_openstack_fsp_nodes) and 0 != len(fsp_expire_msg):
        result = HCCIException(650038, ",".join(unpassed_ebackup_hcp_nodes), 'fsp',
                               ','.join(list(fsp_expire_msg.keys())), 'fsp', str(fsp_expire_msg))
        check_result.set_check_result(param_keys=["openstack_cps_admin_pwd"], status=500, error_msg=result)
    elif 0 != len(fsp_expire_msg):
        check_result.set_check_result(param_keys=["openstack_cps_admin_pwd"], status=500,
                                      error_msg=HCCIException(650037, ','.join(list(fsp_expire_msg.keys())), "fsp",
                                                              str(fsp_expire_msg)))
    elif 0 != len(unpassed_openstack_fsp_nodes):
        check_result.set_check_result(param_keys=["openstack_cps_admin_pwd"], status=500, error_msg=HCCIException(
            650005, ",".join(unpassed_openstack_fsp_nodes)))

    if 0 != len(unpassed_openstack_root_nodes):
        check_result.set_check_result(param_keys=["openstack_cps_admin_pwd"], status=500, error_msg=HCCIException(
            650006, ",".join(unpassed_openstack_root_nodes)))


