# -*- coding:utf-8 -*-

from utils.DBAdapter.DBConnector import BaseOps
from utils.business.dmk_util import DmkApi
from utils.business.param_util import ParamUtil
from utils.common import log as logger
from utils.common.exception import HCCIException
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message

logger.init("eBackup Reset DMK User State")


class ResetDMKUserState(StepBaseInterface):
    def __init__(self, project_id, pod_id):
        params = ParamUtil()
        self.__config_dict = params.get_service_cloud_param(pod_id, "eBackup")
        self.project_id = project_id
        self.pod_id = pod_id

    def pre_check(self, project_id, pod_id):
        """
        插件内部接口：执行安装前的资源预检查，该接口由execute接口调用，工具框架不会直接调用此接口。
        :param project_id:
        :param pod_id:
        :return:
        """

    def execute(self, project_id, pod_id, *args, **kwargs):
        """
        标准调用接口：执行安装前预检查&安装&配置
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        logger.info("Start to reset the DMK user status.")
        try:
            self.reset_dmk_user_state()
        except HCCIException as err:
            return Message(500, err)
        except Exception as err:
            logger.error("ebackup harden failed:%s" % str(err))
            return Message(500, err, err)
        return Message(200)

    def reset_dmk_user_state(self):
        params = ParamUtil()
        dmk_float_ip = params.get_param_value(
            self.pod_id, "DMK", 'dmk_floatIp', 'dmk_floatIp')
        logger.info(f"Get DMK float ip, float ip is {dmk_float_ip}.")
        logger.info("Get eBackup DMK user.")
        ebackup_dmk_user = self.__config_dict.get('eBackup_dmk_user')
        logger.info("Get eBackup DMK password.")
        ebackup_dmk_password = self.__config_dict.get('eBackup_dmk_password')

        dmk_api = DmkApi()
        logger.info("Log in to DMK.")
        dmk_api.login_dmk(dmk_float_ip, ebackup_dmk_user, ebackup_dmk_password)
        logger.info("Reset the eBackup DMK account to the first login state.")
        dmk_api.reset_first_login()

    def rollback(self, project_id, pod_id):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """

    def retry(self, project_id, pod_id):
        """
        标准调用接口：重试
        :return: Message类对象
        """
        return self.execute(project_id, pod_id)

    def check(self, project_id, pod_id):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :return:
        """

# the code has been updated to python3.7
