#!/bin/bash
set +x
echo "please input Envpassword:"
read -s EnvPassWord
EnvAddress=$1
EnvUserName=$2
eBackupIpList=$3
>AddDeviceManagerWhiteList.log

function check_parameter()
{
    special_characters='!$%&()*+,-./:;<=>?@[\]^`{|}~'
    contains_special_character=false
    if ! echo "${EnvPassWord}" | xargs echo -n | grep -Pw '^[0-9a-zA-Z !#$%&()*+,-./:;<=>?@[\]^`{|}~'\''"]{1,}$'; then
        return 1
    else
        return 0
    fi
}

check_parameter
if [ $? -ne 0 ];then
    echo "Failed_check_parameter:addeBackup_to_deviceManager()[$eBackupIpList]" >>AddDeviceManagerWhiteList.log
    exit 1
fi

Num=0
while [ $Num -le 1 ]
do
    expect -f config_V3_white_list.exp $EnvAddress $EnvUserName $eBackupIpList 2>>AddDeviceManagerWhiteList.log 1>>AddDeviceManagerWhiteList.log <<EOF
${EnvPassWord}
EOF
    Ret=$?
    if [ $Ret -eq 1 ]
    then
        echo "Failed1:addeBackup_to_deviceManager()[$eBackupIpList]" >>AddDeviceManagerWhiteList.log
    elif [ $Ret -eq 2 ]
    then
        echo "OK2:addeBackup_to_deviceManager()[$eBackupIpList]" >>AddDeviceManagerWhiteList.log
        sed -i s/$EnvPassWord/xxx/g /var/log/messages
        exit 0
    elif [ $Ret -eq 0 ]
    then
        echo "OK0:addeBackup_to_deviceManager()[$eBackupIpList]" >>AddDeviceManagerWhiteList.log
        sed -i s/$EnvPassWord/xxx/g /var/log/messages
        exit 0
    fi
    Num=`expr $Num + 1`
done
echo "Failed:addeBackup_to_deviceManager()[$eBackupIpList]" >>AddDeviceManagerWhiteList.log
sed -i s/$EnvPassWord/xxx/g /var/log/messages
>~/.bash_history&&history -c
exit 1