#!/bin/bash

G_PYTHON_PATH=""
G_CONFIG_SCRIPT=""
G_CPS_PASSWORD=""
G_PARAMETER_INI=""
G_CPS_USER_NAME=""
G_NBIUSER_PASSWORD=""

function CheckIPv4()
{
    local ipstr=$1

    echo $ipstr|egrep '^\s*((25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9][0-9]|[0-9])\.){3}(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9][0-9]|[0-9])$\s*' >/dev/null 2>&1
    if [ $? -ne 0 ]
    then
       return 1
    fi
    return 0
}

function CheckIPv6()
{
    local ipstr=$1

    echo $ipstr | egrep '^\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])(\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])(\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])(\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])(\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])(\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])(\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])(\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])){3}))|:)))?\s*$' >/dev/null 2>&1
    if [ $? -ne 0 ]
    then
       return 1
    fi
    return 0
}

function CheckIp()
{
    local ipstr=$1

    CheckIPv4 ${ipstr} || CheckIPv6 ${ipstr}

    return $?
}

function initGlobalVariable()
{
    local cinderPath=$1

    G_CONFIG_SCRIPT=${cinderPath}/ebackupconfig.py
    G_PARAMETER_INI="/home/fsp/eBackupbin/bin/eBackupServer.ini"
    G_CPS_USER_NAME=`cat ${G_PARAMETER_INI} | grep -w "CpsUsername" | awk -F ":" '{print $2}' | sed 's/ //g'`
    G_PYTHON_PATH="/usr/bin/python3"
    return 0
}

function configItem()
{
    local interface=$1
    local item=$2
    local value=$3
    local section=$4
    local ret=

    if [[ "${value}" != "" && "${value}" != "NULL" ]]
    then
        if [[ "${item}" == "ebackup_login_password_v2" ]]
        then
            echo "${G_CPS_PASSWORD} ${value}" | ${G_PYTHON_PATH}  ${G_CONFIG_SCRIPT} ${interface} ${G_CPS_USER_NAME} ${item}  ${section}
        else
            echo  "${G_CPS_PASSWORD}" | ${G_PYTHON_PATH}  ${G_CONFIG_SCRIPT} ${interface} ${G_CPS_USER_NAME} ${item} ${value} ${section}
        fi
        ret=$?
        if [ ${ret} -ne 0 ]
        then
            echo "Error:Fail to ${interface} ${item}(${value})!"
            exit 1
        fi
    fi
    return ${ret}
}

function clear_env()
{
    if [ -f ${G_PARAMETER_INI} ];then
        rm ${G_PARAMETER_INI}
    fi
}

function configeBackupParameter()
{
    local cloudScheme=$1
    local PhysicalNetworkTypes=""
    local FusionStorageIps=""
    local FusionStorageAgentIps=""
    local lazyLoading=`cat ${G_PARAMETER_INI} | grep -w "LazyLoading" | awk -F ":" '{print $2}' | sed 's/ //g'`
    local ebkIps=`cat ${G_PARAMETER_INI} | grep -w "Ipaddr" | awk -F "=" '{print $2}' | sed 's/ //g'`
    local azs=`cat ${G_PARAMETER_INI} | grep -w "Azs" | awk -F ":" '{print $2}' | sed 's/ //g'`
    local ebkUsers=`cat ${G_PARAMETER_INI} | grep -w "LoginUser" | awk -F ":" '{print $2}' | sed 's/ //g'`
    local ports=`cat ${G_PARAMETER_INI} | grep -w "Port" | awk -F ":" '{print $2}' | sed 's/ //g'`
    local certFilePath=`cat ${G_PARAMETER_INI} | grep -w "CertFilePath" | awk -F ":" '{print $2}' | sed 's/ //g'`
    local configMode=`cat ${G_PARAMETER_INI} | grep -w "configMode" | awk -F ":" '{print $2}' | sed 's/ //g'`
    local extend=`cat ${G_PARAMETER_INI} | grep -w "Extend" | awk -F ":" '{print $2}' | sed 's/ //g'`
    local tenant_list=`cat ${G_PARAMETER_INI} | grep -w "Tenant_list" | awk -F ":" '{print $2}' | sed 's/ //g'`
    #1.Format parameters as arrays
    OLD_IFS="$IFS"
    IFS=","
    ebkIp_array=($ebkIps)
    az_array=($azs)
    ebkUser_array=($ebkUsers)
    port_array=($ports)
    cert_array=($certFilePath)
    extend_array=($extend)
    tenant_list_array=($tenant_list)
    IFS="$OLD_IFS"

    local ebkIpNum=${#ebkIp_array[@]}
    local azNum=${#az_array[@]}
    local ebkUserNum=${#ebkUser_array[@]}

    local portNum=${#port_array[@]}
    local certNum=${#cert_array[@]}
    local extendNum=${#extend_array[@]}
    local tenant_listNum=${#tenant_list_array[@]}

    #2.check the parameters
    if [[ ${ebkIpNum} -eq 0 || ${ebkUserNum} -eq 0 ]];then
        echo "Error:some parameter is None,please check the parameters such as Ipaddr,LoginUser,PasswordUsr."
        return 1
    fi

    if [[ ${ebkIpNum} -ne ${ebkUserNum} && ${ebkUserNum} -ne 1 ]];then
        echo "Error:If all servers have the same LoginUser and PasswordUsr,you just need input a set of username and password.Otherwise,you must input the username and password for every server!"
        return 1
    fi

    if [[ ${portNum} -ne 0 && ${ebkIpNum} -ne ${portNum} &&  ${portNum} -ne 1 ]];then
        echo "Error:If all servers use the same port,you just need input one port only.Otherwise,you must input a port for every server!"
        return 1
    fi

    if [[ ${certNum} -ne 0 && ${ebkIpNum} -ne ${certNum} &&  ${certNum} -ne 1 ]];then
        echo "Error:If all servers use the same CertFilePath,you just need input one CertFilePath only.Otherwise,you must input a CertFilePath for every server!"
        return 1
    fi


    for ip in "${ebkIp_array[@]}"
    do
        CheckIp $ip
        if [ $? -ne 0 ];then
            echo "Error:Ipaddr($ip) is invalid!"
            return 1
        fi
    done
    #3.config parameter
    local index=0
    while [ $index -lt ${ebkIpNum} ]
    do
        local ip=${ebkIp_array[$index]}
        local az=`echo "${az_array[$index]}" | sed 's/|/,/g'`
        local user=""
        local userPwd=""
        local port=""
        local cert=""

        if [ ${ebkUserNum} -eq 1 ];then
            user=${ebkUser_array[0]}
        else
            user=${ebkUser_array[$index]}
        fi

        if [ ${portNum} -eq 1 ];then
            port=${port_array[0]}
        else
            port=${port_array[$index]}
        fi

        if [ ${certNum} -eq 1 ];then
            cert=${cert_array[0]}
        else
            cert=${cert_array[$index]}
        fi

        if [ "${G_PYTHON_PATH}" = "/usr/bin/python3" ]
        then
            local pwd=$(echo "import base64;print(base64.b64encode(bytes('${G_NBIUSER_PASSWORD}', encoding='utf-8')).decode(encoding='utf-8'));" | ${G_PYTHON_PATH})
        else
            local pwd=$(echo "import base64;print base64.b64encode('${G_NBIUSER_PASSWORD}');" | ${G_PYTHON_PATH})
        fi

        configItem "update" "ebackup_server_ip" "$ip" "$ip"
        configItem "update" "ebackup_login_password_v2" "${pwd}" "$ip"

        configItem "update" "ebackup_login_username" "${user}" "$ip"
        configItem "update" "ebackup_server_port" "${port}" "$ip"
        configItem "update" "ebackup_login_crt" "${cert}" "$ip"
        if [[ "${configMode}x" == "0x" ]];then
            configItem "append" "azs" "${az}" "$ip"
        else
            configItem "update" "azs" "${az}" "$ip"
        fi

        if [ $index -ge $extendNum ];then
            extendStatus="False"
            tenantList=""
        else
            extendStatus=${extend_array[$index]}
            tenantList=${tenant_list_array[$index]}
            tenantList=${tenantList//|/,}
        fi

        if [ $extendStatus = "True" -a "X$tenantList" != "X" ];then
            configItem "update" "extend" "${extendStatus}" "$ip"
            configItem "update" "tenant_white_list" "${tenantList}" "$ip"
        else
            configItem "update" "extend" "False" "$ip"
        fi

        index=$((index+1))
    done

    return 0
}

function main()
{
    read -s pwd_str
    G_CPS_PASSWORD=`echo "${pwd_str}" |awk '{print $1}'`
    G_NBIUSER_PASSWORD=`echo "${pwd_str}" |awk '{print $2}'`

    local cloudScheme=$1
    local cinderPath=$2
    local ret=1

    initGlobalVariable ${cinderPath}
    configeBackupParameter ${cloudScheme}
    ret=$?
    clear_env

    return ${ret}
}

main "$@"
exit $?