from functools import wraps

from utils.business.project_condition_utils import get_project_condition_boolean
from utils.common.exception import HCCIException
import utils.common.log as logger
from utils.common.message import Message


class Project:
    def __init__(self, project_id, pod_id):
        self.project_id = project_id
        self.pod_id = pod_id
        self.agent_proxy = get_project_condition_boolean(
            self.project_id, 'CSBS-VBS-Proxy')
        # 当CSBS-VBS Proxy安装完成后，CSBS-VBS-ProxyInstalled为真。
        self.exist_agent_proxy = get_project_condition_boolean(
            self.project_id, 'CSBS-VBS-ProxyInstalled')


def project_preset(func):
    @wraps(func)
    def handle_func_args(self, project_id, pod_id, regionid_list=None):
        dec_class_name = func.__qualname__
        logger.info("[KarborProxy] %s execute start" % dec_class_name)
        try:
            func(self, project_id, pod_id, regionid_list)
        except HCCIException as err:
            logger.error(
                "[KarborProxy]%s execute error:%s" % (dec_class_name, str(err)))
            return Message(500, err)
        except Exception as err:
            logger.error(
                "[KarborProxy] %s execute error:%s" % (dec_class_name, str(err)))
            return Message(500, err, err)
        logger.info("[KarborProxy] %s execute success" % dec_class_name)
        return Message(200)

    return handle_func_args
