import configparser
import os

from plugins.CSBS.common import node_installer
from plugins.CSBS.common.karbor_cpshelper import CPSInfo, CpsHelper
from plugins.CSBS.common.karbor import KarborUtil
from plugins.CSBS.common.params_tool import ParamTool
from plugins.CSBS.common.util import open_file


class ConfigureSet(node_installer.Installer):
    def __init__(self, project_id, pod_id):
        super(ConfigureSet, self).__init__()
        self.param_tool = ParamTool(project_id, pod_id)
        self.karbor_util = KarborUtil(project_id, pod_id)
        self.installer_config_file = self.param_tool.get_installer_config()
        self.pod_id = pod_id

    def install(self):
        if os.path.isfile(self.installer_config_file):
            os.remove(self.installer_config_file)
        cps_node = CPSInfo(self.pod_id).get_cps_node()
        cps_client = CpsHelper(cps_node)
        cps_client.set_backup_quota()
        self.write_conf_system_file()
        self.write_conf_file('SYSTEM', 'auth_url',
                             self.param_tool.get_auth_url(cps_client),
                             self.installer_config_file)
        self.write_conf_file('SYSTEM', 'nova_url',
                             cps_client.get_nova_endpoint(),
                             self.installer_config_file)
        self.write_conf_file('SYSTEM', 'cinder_url',
                             cps_client.get_cinder_endpoint(),
                             self.installer_config_file)
        self.write_conf_file('SYSTEM', 'glance_url',
                             cps_client.get_glance_endpoint(),
                             self.installer_config_file)
        self.write_conf_file('SYSTEM', 'ceilometer_url',
                             cps_client.get_ceilometer_endpoint(),
                             self.installer_config_file)
        self.write_conf_file('SYSTEM', 'timezone',
                             self.param_tool.get_karbor_timezone(),
                             self.installer_config_file)

        self.write_conf_file('FEATURE', 'file_flag', "0",
                             self.installer_config_file)
        self.write_conf_file('FEATURE', 'backup_flag', "1",
                             self.installer_config_file)
        self.write_conf_file('SYSTEM', 'auth_ca_file', "/opt/huawei/dj",
                             self.installer_config_file)
        karbor_ip_list = self.karbor_util.get_karbor_ip_list()
        if self.param_tool.get_install_type() == "private_recover":
            karbor_internal_float_ip = self.karbor_util.get_karbor_internal_float_ip()
            karbor_ip_list.append(karbor_internal_float_ip)
        for index, karbor_ip in enumerate(karbor_ip_list):
            self.write_conf_file(karbor_ip, 'tenant_ip', karbor_ip, self.installer_config_file)
            self.write_conf_file(karbor_ip, 'internal_ip', karbor_ip, self.installer_config_file)
            self.write_conf_file(karbor_ip, 'hostname', f'karbor{index+1}', self.installer_config_file)
        return True

    def check(self):
        installer_config_file = self.param_tool.get_installer_config()
        return os.path.isfile(installer_config_file)

    def rollback(self):
        installer_config_file = self.param_tool.get_installer_config()
        return os.remove(installer_config_file)

    @staticmethod
    def write_conf_file(key, name, value, file_name):
        config = configparser.ConfigParser()
        config.read(file_name)
        if not config.has_section(key):
            config.add_section(key)
        config.set(key, name, str(value))
        if not config.has_option(key, name):
            return False
        if str(value) != config.get(key, name):
            return False
        with open_file(file_name, 'w') as fwobj:
            config.write(fwobj)
        return True

    def write_conf_system_file(self):
        self.write_conf_file('SYSTEM', 'region_id', self.param_tool.get_region_id(), self.installer_config_file)
        self.write_conf_file('SYSTEM', 'region_name', self.param_tool.get_region_name(), self.installer_config_file)
        self.write_conf_file('SYSTEM', 'profile', self.param_tool.get_install_type(), self.installer_config_file)
        self.write_conf_file('SYSTEM', 'manage_float_ip', self.karbor_util.get_karbor_float_ip(),
                             self.installer_config_file)
        self.write_conf_file('SYSTEM', 'manage_ip_netmask',
                             self.karbor_util.get_karbor_ip_netmask(),
                             self.installer_config_file)
        self.write_conf_file('SYSTEM', 'ip_version', 'ipv4' if self.param_tool.get_ip_version() == 4 else 'ipv6',
                             self.installer_config_file)
        self.write_conf_file('SYSTEM', 'tenant_float_ip',
                             self.karbor_util.get_karbor_float_ip(),
                             self.installer_config_file)
        self.write_conf_file('SYSTEM', 'tenant_ip_netmask',
                             self.karbor_util.get_karbor_ip_netmask(),
                             self.installer_config_file)
        self.write_conf_file('SYSTEM', 'inter_float_ip_start',
                             self.karbor_util.get_karbor_float_ip(),
                             self.installer_config_file)
        self.write_conf_file('SYSTEM', 'inter_float_ip_end',
                             self.karbor_util.get_karbor_internal_float_ip(),
                             self.installer_config_file)
        self.write_conf_file('SYSTEM', 'haproxy_float_ip',
                             self.karbor_util.get_karbor_float_ip(),
                             self.installer_config_file)
        self.write_conf_file('SYSTEM', 'gaussdb_float_ip',
                             self.karbor_util.get_karbor_internal_float_ip(),
                             self.installer_config_file)
        self.write_conf_file('SYSTEM', 'inter_ip_netmask',
                             self.karbor_util.get_karbor_ip_netmask(),
                             self.installer_config_file)
        self.write_conf_file('SYSTEM', 'auth_type',
                             self.param_tool.get_auth_type(),
                             self.installer_config_file)
        self.write_conf_file('SYSTEM', 'dns_ip',
                             ','.join(self.param_tool.get_dns_ip_list()),
                             self.installer_config_file)
        self.write_conf_file('SYSTEM', 'ntp_server_ip',
                             ','.join(self.param_tool.get_ntp_server_ip()),
                             self.installer_config_file)
