from utils.common.exception import HCCIException
from utils.common.message import RESULT_CODE, Message

from plugins.CSBS.common.dmk_tool import DmkTool
from plugins.CSBS.common.karbor import KarborUtil
from plugins.CSBS.common.step_base import DeployBaseSubJob


class InstallAgent(DeployBaseSubJob):
    def execute(self, project_id, pod_id, regionid_list=None):
        dmk_tools = DmkTool(project_id, pod_id)
        karbor_nodes = KarborUtil(project_id, pod_id).get_karbor_node_list()
        node_names = ["CSBS-Karbor-01", "CSBS-Karbor-02", "CSBS-Karbor-03"]
        if dmk_tools.install_maglev_agent(karbor_nodes, node_names):
            return Message(RESULT_CODE['SUCCESS'])
        return Message(RESULT_CODE['ERROR'], HCCIException(640137))
