import utils.common.log as logger
from utils.business.param_util import ParamUtil
from utils.business.project_util import ProjectApi
from utils.business.vm_util import PublicServiceOM

from plugins.CSBS.common import node_installer
from plugins.CSBS.common.constant import KARBOR_PROXY_IMAGE_NAME
from plugins.CSBS.common.os_util import OSUtil
from plugins.CSBS.common.karborproxy.utils import KarborProxyOperation

logger.init("Karbor create vm")


class ProxyCreateVM(node_installer.ThreadInstaller):
    def __init__(self, project_id, pod_id):
        self.pod_id = pod_id
        self.project_id = project_id
        self.proxy_util = KarborProxyOperation(project_id)
        self.project_api = ProjectApi()
        node_list = self.proxy_util.get_proxy_node_list()
        super().__init__(node_list)
        self.project_api = ProjectApi()
        self.pub_om = PublicServiceOM()
        self.network_name = "DMZ_Service"
        self.vm_names = {}
        self.vm_params = {}
        self._init_params()
        self.file_name = OSUtil.get_kvm_image_file(self.project_id)

    def _init_params(self):
        ip_list = self.proxy_util.all_ip_list
        group_names = ["KarborProxy-01", "KarborProxy-02"]
        self.vm_names = dict(zip(ip_list, group_names))
        params = ParamUtil()
        self.vm_params.setdefault("cpu", params.get_value_from_cloudparam(self.pod_id, "CSBS-VBS", "CSBS_proxy_cpu"))
        self.vm_params.setdefault("mem", params.get_value_from_cloudparam(self.pod_id, "CSBS-VBS", "CSBS_proxy_mem"))

    def install_thread(self, node):
        """
        创建虚拟机
        """
        logger.info("Start to create vm.")
        vm_name = self.vm_names.get(node.node_ip)
        cpu = self.vm_params.get('cpu')
        mem = self.vm_params.get('mem')
        availability_zone = "manage-az"
        volume_type = "manager.fsa.csg"
        if self.is_ha_scene and "KarborProxy-02" in vm_name:
            logger.info("Current is ha scenario.")
            availability_zone = "dr-manage-az"
            volume_type = "dr.manager.fsa.csg"
        logger.info(f"VM params, cpu: {cpu}, mem: {mem}, vm name: {vm_name}, ip: {node.node_ip}")
        self.pub_om.create_servers_with_group(self.pod_id, "CSBS", vm_name,
                                              cpu, mem, 110, [node.node_ip],
                                              self.network_name, vm_image_name=KARBOR_PROXY_IMAGE_NAME, sys_disk=10,
                                              image_file_name=self.file_name, availability_zone=availability_zone,
                                              volume_type=volume_type)
        self.install_result[node.node_ip] = True

    def rollback_thread(self, node):
        """
        删除虚拟机
        """
        vm_name = self.vm_names.get(node.node_ip)
        logger.info(f"Start to delete vm {node.node_ip}, vm_name: {vm_name}")
        PublicServiceOM.delete_servers_with_group(self.pod_id, "Service", vm_name,
                                                  [node.node_ip], self.network_name)
        self.rollback_result[node.node_ip] = True

    @property
    def is_ha_scene(self):
        ha_info = self.project_api.get_project_ha_dr_status(self.project_id)
        return ha_info.get("RegionConHA")
