import utils.common.log as logger
from utils.business.param_util import ParamUtil
from utils.common.exception import HCCIException
from utils.common.message import Message

from plugins.CSBS.common.step_base import DeployBaseSubJob
from plugins.CSBS.common.karborproxy.project_set import project_preset
from plugins.CSBS.scripts.deploy.karborproxy.libs.create_vm import ProxyCreateVM

logger.init("create KarborProxy vm")


class CreateAgentProxyVM(DeployBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super().__init__(project_id, pod_id, regionid_list)
        self.vm_util = ProxyCreateVM(project_id, pod_id)
        self.param_util = ParamUtil()
        self.float_ip = self.param_util.get_value_from_cloudparam(self.pod_id, "CSBS-VBS", "karbor_proxy_management_ip")

    @project_preset
    def execute(self, project_id, pod_id, regionid_list=None):
        if not self.vm_util.install(do_rollback=False):
            raise HCCIException("640001", "Create VM failed! Please check logs.")

        self.vm_util.pub_om.create_port(
            pod_id,
            "Management-KarborProxy-Float",
            self.float_ip,
            self.vm_util.network_name
        )

    def rollback(self, project_id, pod_id, regionid_list=None):
        if not self.vm_util.rollback():
            raise HCCIException("640001", "Delete VM failed! Please check logs.")

        self.vm_util.pub_om.delete_port_by_name(
            pod_id,
            "Management-KarborProxy-Float",
            self.float_ip,
            self.vm_util.network_name
        )
        return Message(200)

    def retry(self, project_id, pod_id, regionid_list=None):
        try:
            self.rollback(project_id, pod_id)
        except HCCIException as err:
            return Message(500, err)
        except Exception as err:
            logger.error("delete vm error:%s" % str(err))
            return Message(500, err, err)
        return self.execute(project_id, pod_id)
