import utils.common.log as logger

from plugins.CSBS.common.dpa_login_check import DPALoginCheck
from plugins.CSBS.common.step_base import DeployBaseSubJob
from plugins.CSBS.common.karborproxy.project_set import project_preset

logger.init("DPA Login Checking")
DEFAULT_REQUEST_TIMEOUT = 120


class DPALoginCheckSubJob(DeployBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super().__init__(project_id, pod_id, regionid_list)
        self.dpa_login_check = DPALoginCheck(project_id)

    @project_preset
    def execute(self, project_id, pod_id, regionid_list=None):
        self.dpa_login_check.check_account_info()
