from utils.common.exception import HCCIException
from utils.common.message import Message, RESULT_CODE

from plugins.CSBS.common.dmk_tool import DmkTool
from plugins.CSBS.common.karborproxy.utils import KarborProxyOperation
from plugins.CSBS.common.step_base import DeployBaseSubJob


class InstallAgent(DeployBaseSubJob):
    def execute(self, project_id, pod_id, regionid_list=None):
        dmk_tools = DmkTool(project_id, pod_id)
        proxy_nodes = KarborProxyOperation(project_id).get_proxy_node_list()
        node_names = ["CSBS-KarborProxy-01", "CSBS-KarborProxy-02"]
        if dmk_tools.install_maglev_agent(proxy_nodes, node_names):
            return Message(RESULT_CODE['SUCCESS'])
        return Message(RESULT_CODE['ERROR'], HCCIException(640137))
