import utils.common.log as logger
from utils.business.manageone_cmdb_util import ManageOneCmdbUtil
from utils.business.param_util import ParamUtil
from utils.business.project_util import ProjectApi
from utils.common.message import Message

from plugins.CSBS.common.step_base import DeployBaseSubJob
from plugins.CSBS.common.params_tool import ParamTool
from plugins.CSBS.common.karborproxy.project_set import project_preset

logger.init("KarborProxy RegisterCMDB")


class RegisterCMDB(DeployBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super().__init__(project_id, pod_id, regionid_list)
        param_tool = ParamTool(self.project_id, pod_id)
        self.region_id = param_tool.get_region_id()
        self.cipher_type = param_tool.get_cipher_type()
        self.index_name = "CSBS-VBS"
        self.project_api = ProjectApi()
        self.cmdb_util = ManageOneCmdbUtil(project_id, pod_id)

    @project_preset
    def execute(self, project_id, pod_id, regionid_list=None):
        # 将KarborProxy扩容信息注册至CMDB
        self._update_karbor_proxy_info_to_cmdb()
        return Message(200)

    def _update_karbor_proxy_info_to_cmdb(self):
        cmdb_service_name = f"{self.index_name}_{self.region_id}"
        csbs_vbs_service_info = self.cmdb_util.get_cloud_service_info(
            self.region_id, self.index_name,
            name=cmdb_service_name)
        if not csbs_vbs_service_info:
            raise Exception("Failed to query the CMDB information registered "
                            "with the CSBS-VBS.")
        csbs_vbs_version = csbs_vbs_service_info[0].get("version")
        if not csbs_vbs_version:
            raise Exception(f"Failed to obtain the {self.index_name} version.")

        service_scale = ParamUtil().get_project_scales_by_project_id(
            self.project_id).get("scale")

        extend_infos = [
            {
                "key": "InstalledCSBS-VBS-Proxy",
                "value": "True"
            },
            {
                "key": "karborproxy_region_service_scale",
                "value": service_scale,
            },
            {
                "key": "ProxyCipherType",
                "value": self.cipher_type
            }
        ]
        # 组织注册数据
        cloud_service_info = dict()
        for service_info in csbs_vbs_service_info:
            if service_info.get("name") != cmdb_service_name:
                continue
            cloud_service_info["indexName"] = service_info.get("indexName")
            cloud_service_info["version"] = service_info.get("version")
            cloud_service_info["name"] = service_info.get("name")
            extend_info_list = []
            extend_infos_result = service_info.get("extendInfos")
            if not extend_infos_result:
                raise Exception(f"Failed to get extend information:{extend_infos_result}.")
            for extend_info in extend_infos_result:
                if extend_info.get("key") != "ProxyCipherType":
                    extend_info_list.append(extend_info)
            extend_info_list.extend(extend_infos)
            cloud_service_info["extendInfos"] = extend_info_list

        # 注册CMDB
        logger.info(f"Start to update {self.index_name} extend info, "
                    f"update extend info is:{str(extend_infos)}.")
        self.cmdb_util.set_cloud_service_info(
            region_code=self.region_id,
            cloud_service_info=cloud_service_info)
        logger.info(f"Update {self.index_name} extend info to cmdb succeed.")
