#!/usr/bin/env python
# -*- coding: utf-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
import utils.common.log as logger
from utils.business.project_condition_utils import get_project_condition_boolean
from utils.business.vm_util import PublicServiceOM
from utils.common.exception import HCCIException
from utils.common.message import Message

from plugins.CSBS.common.constant import KARBOR_IMAGE_NAME, KARBOR_PROXY_IMAGE_NAME
from plugins.CSBS.common.util import MSG_200, MSG_500
from plugins.CSBS.common.step_base import UpgradeBaseSubJob


class RollbackKVM(UpgradeBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list):
        super().__init__(project_id, pod_id, regionid_list)
        self.vm_util = PublicServiceOM()

    def execute(self, project_id, pod_id, regionid_list=None):
        try:
            self._rollback(KARBOR_IMAGE_NAME)
            if get_project_condition_boolean(self.project_id, "InstalledCSBSProxy"):
                self._rollback(KARBOR_PROXY_IMAGE_NAME)
        except Exception as err:
            logger.error(f"Rollback image failed. {err}")
            return Message(MSG_500, HCCIException("645070"))
        return Message(MSG_200)

    def _rollback(self, image_name):
        logger.info(f"Start to rollback {image_name}.")
        backup_image = self.vm_util.get_image_info_by_name_id(pod_id=self.pod_id,
                                                              image_name=f"{image_name}_backup")
        if backup_image:
            self.vm_util.delete_image(pod_id=self.pod_id, image_name=image_name)
            self.vm_util.update_image_attributes(self.pod_id, f"{image_name}_backup",
                                                 name=image_name)
        logger.info("Rollback image success.")
