# -*- coding:utf-8 -*-
import utils.common.log as logger

from plugins.CSBS.common.karbor import KarborUtil
from plugins.CSBS.common.ssh_client import SshClient
from plugins.CSBS.common.step_base import UpgradeBaseSubJob
from plugins.CSBS.common.karborproxy.project_set import project_preset

logger.init("KarborProxy")


class RestartResourceManager(UpgradeBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super().__init__(project_id, pod_id, regionid_list)
        self.ssh_util = SshClient()
        self.karbor_util = KarborUtil(project_id, pod_id)

    @project_preset
    def execute(self, project_id, pod_id, regionid_list=None):
        logger.info("Start restart ResourceManager on the Karbor node.")
        self.restart_resource_manager()

    def restart_resource_manager(self):
        cmds = "source /opt/huawei/dj/inst/utils.sh;" \
               "resource_managerControl -A RESTART;" \
               "echo restart Resource Manager result: $?"
        for karbor_node in self.karbor_util.get_karbor_node_list():
            ssh_client = None
            try:
                ssh_client = self.ssh_util.get_ssh_client_user_su_root(karbor_node)
                listout = self.ssh_util.ssh_exec_command_return(ssh_client, cmds)
            except Exception as error:
                logger.warn(f"restart RM fail in karbor node={karbor_node}, error is {error}.")
                continue
            finally:
                if ssh_client:
                    self.ssh_util.ssh_close(ssh_client)
            if str(karbor_node.node_ip) in str(listout):
                break
        else:
            raise Exception("restart RM fail in all karbor node.")
        logger.info("restart RM success.")

# the code has been updated to python3.7
