import utils.common.log as logger

from plugins.CSBS.common.karbor import KarborUtil
from plugins.CSBS.common.ssh_client import SshClient

logger.init("Karbor config az")


class ConfigAz:
    def __init__(self, project_id, pod_id):
        karbor_info = KarborUtil(project_id, pod_id)
        self.karbor_node = karbor_info.get_karbor_node_list()[0]
        self.ssh_client = SshClient()

    def check_az_exists(self, available_zone):
        """
        检查az对应关系是否已经存在
        return: True: 已存在
                False: 不存在
        """
        cmd_list_az = f"source /opt/huawei/dj/inst/utils.sh;set_az_backup_cp --op list | grep {available_zone}"
        client = self.ssh_client.get_ssh_client(self.karbor_node)
        logger.info(f'Login karbor to execute cmd: {cmd_list_az}.')
        cmd_list_az_result = self.ssh_client.ssh_exec_command_return(client, cmd_list_az, 30)
        self.ssh_client.ssh_close(client)
        return not self.ssh_client.failed_to_return(cmd_list_az_result, available_zone, client)

    def add_az(self, available_zone):
        """
        添加az对应关系
        return: True: 添加成功
                False: 添加失败
        """
        cmd_add_az = f"source /opt/huawei/dj/inst/utils.sh;set_az_backup_cp --op add --name {available_zone}"
        client = self.ssh_client.get_ssh_client(self.karbor_node)
        logger.info(f'Login karbor to execute cmd: {cmd_add_az}.')
        add_az_result = self.ssh_client.ssh_send_command_expect(client, cmd_add_az, "succ", 30)
        self.ssh_client.ssh_close(client)
        return not self.ssh_client.failed_to_return(add_az_result, "succ", client)

    def delete_az(self, available_zone):
        """
        删除az对应关系
        return: True: 删除成功
                False: 删除失败
        """
        cmd_delete_az = f"source /opt/huawei/dj/inst/utils.sh;set_az_backup_cp --op delete --name {available_zone}"
        client = self.ssh_client.get_ssh_client(self.karbor_node)
        logger.info(f'Login karbor to execute cmd: {cmd_delete_az}.')
        delete_az_result = self.ssh_client.ssh_send_command_expect(client, cmd_delete_az, "succ", 30)
        self.ssh_client.ssh_close(client)
        return not self.ssh_client.failed_to_return(delete_az_result, "succ", client)

