# -*- coding:utf-8 -*-
import utils.common.log as logger
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message
from utils.common.message import RESULT_CODE

from plugins.CSBS.common.monkey_patches import do_patch_code_2_msg
from plugins.CSBS.common.upgrade.params import ParamsStore

do_patch_code_2_msg()

logger.init("CSBS-VBS")


class BaseStep(StepBaseInterface):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super().__init__(project_id, pod_id, regionid_list)
        self.project_id = project_id
        self.pod_id = pod_id

    def pre_check(self, project_id, pod_id, regionid_list=None):
        """Plug-in internal interface.

        Perform resource pre-check before installation,
        this interface is called by the execute interface,
        The tool framework does not directly call this interface.
        """
        return Message(RESULT_CODE['SUCCESS'])

    def execute(self, project_id, pod_id, regionid_list=None):
        """Plug-in internal interface.

        Perform installation & configuration.
        """
        return Message(RESULT_CODE['SUCCESS'])

    def rollback(self, project_id, pod_id, regionid_list=None):
        """Plug-in internal interface.

        Perform job job failed rollback.
        """
        return Message(RESULT_CODE['SUCCESS'])

    def retry(self, project_id, pod_id, regionid_list=None):
        """Plug-in internal interface.

        Perform job failed retry.
        """
        self.rollback(project_id, pod_id, regionid_list)
        return self.execute(project_id, pod_id, regionid_list)

    def check(self, project_id, pod_id, regionid_list=None):
        """Plug-in internal interface.

        Check before task execution.
        """
        return Message(RESULT_CODE['SUCCESS'])


class DeployBaseSubJob(BaseStep):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super().__init__(project_id, pod_id, regionid_list)
        self.project_id = project_id
        self.pod_id = pod_id
        self.region_id = None
        if regionid_list:
            self.region_id = regionid_list[0]


class UpgradeBaseSubJob(BaseStep):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super(UpgradeBaseSubJob, self).__init__(project_id, pod_id, regionid_list)
        if not (regionid_list and isinstance(regionid_list, (list, tuple))):
            raise Exception("The parameter of regionid_list cannot be empty "
                            "and parameter type must be list or tuple."
                            "regionid_list is {}, type is {}".
                            format(str(regionid_list), type(regionid_list)))
        self.regionid_list = regionid_list
        self.region_id = self.regionid_list[0]
        self.params_store = ParamsStore(self.project_id, self.pod_id, self.region_id)
        self.project_scene = self.params_store.get_project_scene_params()
        self.upgrade_path = self.params_store.get_upgrade_path_params()
