import utils.common.log as logger
from utils.business.install_csp_agent import CSPAgent
from utils.common.exception import HCCIException
from utils.common.message import Message

from plugins.CSBS.common.step_base import DeployBaseSubJob
from plugins.CSBS.common.karborproxy.agent_proxy_param import AgentProxy
from plugins.CSBS.common.karborproxy.utils import KarborProxyOperation

logger.init("KarborProxy")


class InstallCspAgent(DeployBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super(InstallCspAgent, self).__init__(project_id, pod_id, regionid_list)
        self.project_id = project_id
        self.pod_id = pod_id
        self.proxy_util = KarborProxyOperation(project_id)
        self.proxy_param = AgentProxy(self.project_id, self.pod_id)

    def execute(self, project_id, pod_id, regionid_list=None):
        try:
            self._install_csp_agent()
        except Exception as err:
            logger.error(f"Failed to execute InstallCSPAgent, err_msg:{str(err)}.")
            return Message(500, HCCIException(640086, str(err)))
        logger.info(f"Succeed to install csp agent for {self.proxy_param} service.")
        return Message(200)

    def _get_proxy_node_list(self):
        logger.info(f"Succeed to obtain proxy ips.")
        node_list = []
        for node in self.proxy_util.get_proxy_node_list():
            node_info = {
                "node_ip": node.node_ip,
                "process_username": node.user,
                "user_password": node.user_pwd,
                "sudo_cmd": "su",
                "root_password": node.root_pwd
            }
            node_list.append(node_info)
        return node_list

    def _install_csp_agent(self):
        logger.info(f"Start to install csp agent "
                    f"for {self.proxy_param.proxy_name} service.")
        proxy_node_list = self._get_proxy_node_list()
        ret_dic = \
            CSPAgent(self.pod_id).install_csp_agent(
                service_name=self.proxy_param.service_name,
                node_list=proxy_node_list)

        if ret_dic["result_code"] != "0":
            raise Exception("Install csp agent failed, result "
                            f"code:[{ret_dic['result_code']}], msg: [{ret_dic['result_msg']}].")
        logger.info(f"Succeed to install csp agent "
                    f"for {self.proxy_param} service.")
