import utils.common.log as logger
from utils.common.exception import HCCIException
from utils.common.message import Message

from plugins.CSBS.common.upgrade.console_upgrade import ConsoleUpgrade
from plugins.CSBS.common.step_base import UpgradeBaseSubJob

logger.init("CSBS-VBS")


class BackupConsole(UpgradeBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list):
        super(BackupConsole, self).__init__(project_id, pod_id, regionid_list)
        self.console_upgrade = ConsoleUpgrade(self.params_store)

    def execute(self, project_id, pod_id, regionid_list=None):
        # upload cf2 pkg into primary region ManageOne-Tenant01/02 nodes
        # For the standby region, the value of region_flag is True.
        # For other regions, the value is False.
        region_flag = False
        if self.project_scene.is_global_dr_scene and not self.project_scene.is_primary_region:
            region_flag = True
        logger.info("Start to backup console.")
        try:
            result = self.console_upgrade.backup_cbs_console(
                pod_id, service_type="cbs",
                backup_type="backup",
                region_flag=region_flag,
                region_id=self.region_id,
                version=self.region_id,
                is_region=True)
        except Exception as err:
            logger.error(f"Failed to backup console, error: {str(err)}.")
            return Message(500, HCCIException(645028))
        if not result:
            logger.error("Failed to backup console.")
            return Message(500, HCCIException(645028))
        logger.info("Backup console successfully.")
        return Message(200)
