import utils.common.log as logger
from utils.common.exception import HCCIException
from utils.common.message import Message

from plugins.CSBS.common.upgrade.dmk_client import DMKClient
from plugins.CSBS.common.upgrade.karbor import KarborOperation
from plugins.CSBS.common.step_base import UpgradeBaseSubJob


logger.init("CSBS-VBS")


class RollbackKarbor(UpgradeBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list):
        super(RollbackKarbor, self).__init__(project_id, pod_id, regionid_list)
        self.karbor_operation = KarborOperation(self.project_id)
        self.dmk_client = DMKClient(self.params_store)

    def execute(self, project_id, pod_id, regionid_list=None):
        logger.info("Login dmk and call DMK to rollback Karbor.")
        action = "[Rollback] CSBS-VBS Karbor"
        try:
            result = self.dmk_client.dmk_deploy_karbor(action, self.upgrade_path.karbor_pkg_version)
            self.karbor_operation.operate_karbor_service(service="karbor-api", operate="stop")
            self.karbor_operation.operate_karbor_service(service="karbor-api", operate="start")
        except Exception as err:
            logger.error("Failed to rollback Karbor, "
                         "reason: {}.".format(str(err)))
            return Message(500, HCCIException(645012))
        if result:
            logger.info("Rollback Karbor successfully.")
        else:
            return Message(500, HCCIException(645012))
        return Message(200)
